/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.lagfixer.features;

import com.spunkyinsaan.lagfixer.SpunkysLagFixer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ItemsCleaner {
    private final SpunkysLagFixer plugin;
    private BukkitTask cleanupTask;
    private final Map<String, List<ItemStack>> abyssStorage = new HashMap<String, List<ItemStack>>();
    private boolean enabled = true;

    public ItemsCleaner(SpunkysLagFixer plugin) {
        this.plugin = plugin;
        this.startScheduledCleanup();
    }

    private void startScheduledCleanup() {
        long interval = this.plugin.getConfig().getLong("items-cleaner.interval", 5L) * 1200L;
        this.cleanupTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.enabled) {
                this.announceCleanup();
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::cleanNow, 600L);
            }
        }, interval, interval);
    }

    private void announceCleanup() {
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "[LagFixer] Ground items will be cleaned in 30 seconds!"));
    }

    public void cleanNow() {
        int count = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Item)) continue;
                Item item = (Item)entity;
                if (this.isValuableItem(item.getItemStack())) {
                    this.storeInAbyss(item.getItemStack());
                }
                entity.remove();
                ++count;
            }
        }
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GREEN) + "[LagFixer] Cleaned " + count + " items from the ground!"));
    }

    private boolean isValuableItem(ItemStack item) {
        return item.hasItemMeta() || item.getEnchantments().size() > 0;
    }

    private void storeInAbyss(ItemStack item) {
        String owner = "server";
        this.abyssStorage.computeIfAbsent(owner, k -> new ArrayList()).add(item);
    }

    public List<ItemStack> getAbyssItems(String player) {
        return this.abyssStorage.getOrDefault(player, new ArrayList());
    }

    public void clearAbyssItems(String player) {
        this.abyssStorage.remove(player);
    }

    public void shutdown() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

