/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.lagfixer.features;

import com.spunkyinsaan.lagfixer.SpunkysLagFixer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LagMonitor {
    private final SpunkysLagFixer plugin;
    private BukkitTask monitorTask;
    private long lastTick = 0L;
    private double tps = 20.0;
    private static final int TICK_SAMPLE_SIZE = 100;
    private final double[] tickHistory = new double[100];
    private int tickIndex = 0;

    public LagMonitor(SpunkysLagFixer plugin) {
        this.plugin = plugin;
        this.startMonitoring();
    }

    private void startMonitoring() {
        this.monitorTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long maxMemory;
            Runtime runtime;
            long usedMemory;
            long now = System.currentTimeMillis();
            if (this.lastTick == 0L) {
                this.lastTick = now;
                return;
            }
            long diff = now - this.lastTick;
            this.tps = Math.min(20.0, 1000.0 / (double)diff * 20.0);
            this.lastTick = now;
            this.tickHistory[this.tickIndex] = this.tps;
            this.tickIndex = (this.tickIndex + 1) % 100;
            double avgTPS = this.calculateAverageTPS();
            if (avgTPS < 18.0) {
                this.handleLowTPS();
            }
            if ((double)(usedMemory = ((runtime = Runtime.getRuntime()).totalMemory() - runtime.freeMemory()) / 1024L / 1024L) > (double)(maxMemory = runtime.maxMemory() / 1024L / 1024L) * 0.8) {
                this.handleHighMemoryUsage();
            }
        }, 20L, 20L);
    }

    private double calculateAverageTPS() {
        double sum = 0.0;
        int count = 0;
        for (double tick : this.tickHistory) {
            if (!(tick > 0.0)) continue;
            sum += tick;
            ++count;
        }
        return count > 0 ? sum / (double)count : 20.0;
    }

    private void handleLowTPS() {
        Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("lagfixer.admin")).forEach(player -> player.sendMessage(String.valueOf(ChatColor.RED) + "[LagFixer] Server TPS has dropped to " + String.format("%.2f", this.tps)));
        this.plugin.getCustomAI().setEnabled(true);
        this.plugin.getItemsCleaner().cleanNow();
        this.plugin.getEntityLimiter().enforceLimit();
    }

    private void handleHighMemoryUsage() {
        System.gc();
        Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("lagfixer.admin")).forEach(player -> player.sendMessage(String.valueOf(ChatColor.RED) + "[LagFixer] High memory usage detected. Requesting garbage collection."));
    }

    public void shutdown() {
        if (this.monitorTask != null) {
            this.monitorTask.cancel();
        }
    }

    public double getTPS() {
        return this.tps;
    }

    public double getAverageTPS() {
        return this.calculateAverageTPS();
    }
}

