/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.util.Arrays;
import me.drex.meliuscommands.parser.ArgumentTypeParser;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class BrigadierArgumentTypeParser
implements ArgumentTypeParser {
    public static final BrigadierArgumentTypeParser INSTANCE = new BrigadierArgumentTypeParser();

    private BrigadierArgumentTypeParser() {
    }

    @Override
    public boolean canParse(class_2960 resourceLocation) {
        if (!resourceLocation.method_12836().equals("brigadier")) {
            return false;
        }
        return switch (resourceLocation.method_12832()) {
            case "bool", "string", "integer", "long", "float", "double" -> true;
            default -> false;
        };
    }

    @Override
    public ArgumentType<?> parse(class_7157 context, class_2960 resourceLocation, String args) {
        return switch (resourceLocation.method_12832()) {
            case "bool" -> BoolArgumentType.bool();
            case "string" -> BrigadierArgumentTypeParser.parseStringArgumentType(args);
            case "integer" -> BrigadierArgumentTypeParser.parseIntegerArgumentType(args);
            case "double" -> BrigadierArgumentTypeParser.parseDoubleArgumentType(args);
            case "long" -> BrigadierArgumentTypeParser.parseLongArgumentType(args);
            case "float" -> BrigadierArgumentTypeParser.parseFloatArgumentType(args);
            default -> throw new AssertionError();
        };
    }

    private static StringArgumentType parseStringArgumentType(String args) {
        return switch (args) {
            case "word", "single_word" -> StringArgumentType.word();
            case "phrase", "quotable_phrase" -> StringArgumentType.string();
            case "greedy", "greedy_phrase" -> StringArgumentType.greedyString();
            default -> throw new IllegalArgumentException("Unknown string type: " + args);
        };
    }

    private static IntegerArgumentType parseIntegerArgumentType(String args) {
        Object[] arguments = BrigadierArgumentTypeParser.splitArguments(args);
        if (arguments.length > 2) {
            throw new IllegalArgumentException("Expected 0-2 arguments, but received " + arguments.length + ": " + Arrays.toString(arguments));
        }
        if (arguments.length > 0) {
            int min = Integer.parseInt((String)arguments[0]);
            if (arguments.length > 1) {
                int max = Integer.parseInt((String)arguments[1]);
                return IntegerArgumentType.integer((int)min, (int)max);
            }
            return IntegerArgumentType.integer((int)min);
        }
        return IntegerArgumentType.integer();
    }

    private static DoubleArgumentType parseDoubleArgumentType(String args) {
        Object[] arguments = BrigadierArgumentTypeParser.splitArguments(args);
        if (arguments.length > 2) {
            throw new IllegalArgumentException("Expected 0-2 arguments, but received " + arguments.length + ": " + Arrays.toString(arguments));
        }
        if (arguments.length > 0) {
            double min = Double.parseDouble((String)arguments[0]);
            if (arguments.length > 1) {
                double max = Double.parseDouble((String)arguments[1]);
                return DoubleArgumentType.doubleArg((double)min, (double)max);
            }
            return DoubleArgumentType.doubleArg((double)min);
        }
        return DoubleArgumentType.doubleArg();
    }

    private static LongArgumentType parseLongArgumentType(String args) {
        Object[] arguments = BrigadierArgumentTypeParser.splitArguments(args);
        if (arguments.length > 2) {
            throw new IllegalArgumentException("Expected 0-2 arguments, but received " + arguments.length + ": " + Arrays.toString(arguments));
        }
        if (arguments.length > 0) {
            long min = Long.parseLong((String)arguments[0]);
            if (arguments.length > 1) {
                long max = Long.parseLong((String)arguments[1]);
                return LongArgumentType.longArg((long)min, (long)max);
            }
            return LongArgumentType.longArg((long)min);
        }
        return LongArgumentType.longArg();
    }

    private static FloatArgumentType parseFloatArgumentType(String args) {
        Object[] arguments = BrigadierArgumentTypeParser.splitArguments(args);
        if (arguments.length > 2) {
            throw new IllegalArgumentException("Expected 0-2 arguments, but received " + arguments.length + ": " + Arrays.toString(arguments));
        }
        if (arguments.length > 0) {
            float min = Float.parseFloat((String)arguments[0]);
            if (arguments.length > 1) {
                float max = Float.parseFloat((String)arguments[1]);
                return FloatArgumentType.floatArg((float)min, (float)max);
            }
            return FloatArgumentType.floatArg((float)min);
        }
        return FloatArgumentType.floatArg();
    }

    private static String[] splitArguments(String args) {
        if (args.isEmpty()) {
            return new String[0];
        }
        return args.split(" ");
    }
}

