/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.config.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.drex.meliuscommands.config.command.CommandNode;
import me.drex.meliuscommands.config.command.LiteralNode;
import me.drex.meliuscommands.config.common.CommandAction;
import me.drex.meliuscommands.parser.ArgumentTypeParser;
import me.drex.meliuscommands.parser.BrigadierArgumentTypeParser;
import me.drex.meliuscommands.parser.MinecraftArgumentTypeParser;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class ArgumentNode<T>
extends CommandNode<RequiredArgumentBuilder<class_2168, T>> {
    public final String type;
    public static final Codec<ArgumentNode<?>> CODEC = Codec.lazyInitialized(() -> Codec.recursive((String)"Argument Node", argumentCodec -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(node -> node.id), (App)Codec.STRING.fieldOf("type").forGetter(node -> node.type), (App)LiteralNode.CODEC.listOf().optionalFieldOf("literals", Collections.emptyList()).forGetter(node -> node.literals), (App)argumentCodec.listOf().optionalFieldOf("arguments", Collections.emptyList()).forGetter(node -> node.arguments), (App)PredicateRegistry.CODEC.optionalFieldOf("require").forGetter(node -> node.requires), (App)CommandAction.CODEC.listOf().optionalFieldOf("executes", Collections.emptyList()).forGetter(node -> node.executions), (App)Codec.STRING.optionalFieldOf("redirect").forGetter(node -> node.redirect)).apply((Applicative)instance, ArgumentNode::new))));
    private static final ArgumentTypeParser[] PARSERS = new ArgumentTypeParser[]{BrigadierArgumentTypeParser.INSTANCE, MinecraftArgumentTypeParser.INSTANCE};

    protected ArgumentNode(String id, String type, List<LiteralNode> literals, List<ArgumentNode<?>> arguments, Optional<MinecraftPredicate> require, List<CommandAction> actions, Optional<String> redirect) {
        super(id, literals, arguments, require, actions, redirect);
        this.type = type;
    }

    @Override
    RequiredArgumentBuilder<class_2168, T> getArgumentBuilder(class_7157 context) {
        return class_2170.method_9244((String)this.id, this.getArgumentType(context));
    }

    private ArgumentType<T> getArgumentType(class_7157 context) {
        String[] splits = this.type.split(" ", 2);
        String type = splits[0];
        String args = splits.length > 1 ? splits[1] : "";
        class_2960 resourceLocation = class_2960.method_60654((String)type);
        for (ArgumentTypeParser parser : PARSERS) {
            if (!parser.canParse(resourceLocation)) continue;
            ArgumentType<?> parse = parser.parse(context, resourceLocation, args);
            return parse;
        }
        throw new IllegalArgumentException("Unknown argument type: " + type);
    }
}

