/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.config.common;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.DynamicTextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import me.drex.meliuscommands.mixin.CommandContextAccessor;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_8935;

public record CommandAction(String command, boolean console, boolean silent, Optional<Integer> permissionLevel) {
    private static final TagLikeParser.Format PLACEHOLDER_COMMAND = TagLikeParser.Format.of((String)"${", (String)"}", (String)" ");
    private static final ParserContext.Key<Function<String, class_2561>> ARGUMENTS = DynamicTextNode.key((String)"melius_commands");
    private static final NodeParser PARSER = NodeParser.builder().globalPlaceholders(PLACEHOLDER_COMMAND).placeholders(TagLikeParser.PLACEHOLDER_USER, ARGUMENTS).build();
    public static final Codec<CommandAction> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(CommandAction::command), (App)Codec.BOOL.optionalFieldOf("as_console", (Object)true).forGetter(CommandAction::console), (App)Codec.BOOL.optionalFieldOf("silent", (Object)true).forGetter(CommandAction::silent), (App)Codec.INT.optionalFieldOf("op_level").forGetter(CommandAction::permissionLevel)).apply((Applicative)instance, CommandAction::new));
    public static final Codec<CommandAction> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Codec.STRING, CommandAction::new);

    public CommandAction(String command) {
        this(command, true, true, Optional.of(4));
    }

    public int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String parsedCommand;
        Map arguments = ((CommandContextAccessor)ctx).getArguments();
        try {
            ParserContext parserContext = PlaceholderContext.of((class_2168)((class_2168)ctx.getSource())).asParserContext().with(ARGUMENTS, input -> {
                ParsedArgument argument = (ParsedArgument)arguments.get(input);
                if (argument == null) {
                    throw new IllegalStateException((Throwable)new SimpleCommandExceptionType((Message)new LiteralMessage("Unknown argument '" + input + "' in '" + this.command + "'")).create());
                }
                String value = argument.getRange().get(ctx.getInput() + " ");
                return class_2561.method_43470((String)value);
            });
            parsedCommand = PARSER.parseText(this.command, parserContext).getString();
        }
        catch (IllegalStateException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CommandSyntaxException) {
                CommandSyntaxException syntaxException = (CommandSyntaxException)throwable;
                throw syntaxException;
            }
            throw new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to parse '" + this.command + "', because '" + e.getMessage() + "'")).create();
        }
        AtomicInteger result = new AtomicInteger();
        class_2168 modifiedSource = ((class_2168)ctx.getSource()).method_9209((bl, i) -> result.set(i), class_8935::chain);
        if (this.console) {
            modifiedSource = modifiedSource.method_36321((class_2165)((class_2168)ctx.getSource()).method_9211());
        }
        if (this.silent) {
            modifiedSource = modifiedSource.method_9217();
        }
        if (this.permissionLevel.isPresent()) {
            modifiedSource = modifiedSource.method_9206(this.permissionLevel.get().intValue());
        }
        ((class_2168)ctx.getSource()).method_9211().method_3734().method_44252(modifiedSource, parsedCommand);
        return result.get();
    }
}

