/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class CooldownManager {
    private static final Map<UUID, Map<String, Long>> cooldowns = new HashMap<UUID, Map<String, Long>>();

    public static void init() {
        ServerTickEvents.START_SERVER_TICK.register(server -> CooldownManager.tick());
    }

    public static void addCooldown(UUID uuid, String id, long seconds) {
        long currentMillis = System.currentTimeMillis();
        long millis = seconds * 1000L;
        Map playerCooldowns = cooldowns.computeIfAbsent(uuid, ignored -> new HashMap());
        playerCooldowns.put(id, currentMillis + millis);
    }

    private static void tick() {
        long currentMillis = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Map<String, Long>>> iterator = cooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Map<String, Long>> mapEntry = iterator.next();
            mapEntry.getValue().entrySet().removeIf(cooldown -> (Long)cooldown.getValue() <= currentMillis);
            if (!mapEntry.getValue().isEmpty()) continue;
            iterator.remove();
        }
    }

    public static boolean hasCooldown(UUID uuid, String id) {
        return CooldownManager.getCooldown(uuid, id) > 0L;
    }

    public static long getCooldown(UUID uuid, String id) {
        Map cooldown = cooldowns.getOrDefault(uuid, Collections.emptyMap());
        return cooldown.getOrDefault(id, 0L) - System.currentTimeMillis();
    }
}

