/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import pl.ziomalu.backpackplus.utils.Utils;

public final class ItemUtil {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String itemToBase64(ItemStack stack) throws IllegalStateException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)stack);
                dataOutput.flush();
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            }
            return string;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to convert item to base64: ", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack itemFromBase64(String encoded) throws IOException {
        if (!Utils.isValidBase64(encoded)) {
            return null;
        }
        try {
            byte[] decodedData = Base64.getDecoder().decode(encoded);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedData);){
                ItemStack itemStack;
                try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                    itemStack = (ItemStack)dataInput.readObject();
                }
                return itemStack;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Unable to decode class type.", ex);
        }
        catch (StreamCorruptedException | IllegalArgumentException ex) {
            throw new IOException("Failed to decode Base64 string: " + encoded, ex);
        }
    }
}

