/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.backpackplus;

import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackItem {
    private final Material material;
    private int amount;
    @Nullable
    private final ItemStack itemStack;
    private final boolean isCustomStack;

    public BackpackItem(@NotNull Material material, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount cannot be negative");
        }
        this.material = material;
        this.amount = amount;
        this.itemStack = null;
        this.isCustomStack = false;
    }

    public BackpackItem(@NotNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        this.itemStack = itemStack.clone();
        this.material = itemStack.getType();
        this.amount = itemStack.getAmount();
        this.isCustomStack = true;
    }

    public void increaseAmount(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value cannot be negative");
        }
        this.amount += value;
    }

    public void decreaseAmount(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value cannot be negative");
        }
        if (this.amount - value < 0) {
            throw new IllegalStateException("Resulting amount cannot be negative");
        }
        this.amount -= value;
    }

    @NotNull
    public ItemStack toItemStack() {
        if (this.isCustomStack && this.itemStack != null) {
            ItemStack result = this.itemStack.clone();
            result.setAmount(Math.min(this.amount, result.getMaxStackSize()));
            return result;
        }
        return new ItemStack(this.material, Math.min(this.amount, this.material.getMaxStackSize()));
    }

    public boolean isSimilar(@NotNull BackpackItem other) {
        if (this.isCustomStack != other.isCustomStack) {
            return false;
        }
        if (this.isCustomStack) {
            return this.itemStack != null && other.itemStack != null && this.itemStack.isSimilar(other.itemStack);
        }
        return this.material == other.material;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Nullable
    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Generated
    public boolean isCustomStack() {
        return this.isCustomStack;
    }

    @Generated
    public void setAmount(int amount) {
        this.amount = amount;
    }
}

