/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.backpackplus;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.utils.Utils;

public class BackpackPlusAPI {
    private final JavaPlugin plugin;

    public BackpackPlusAPI(@NotNull JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null");
    }

    public void getBackpack(@NotNull ItemStack stack, @NotNull Consumer<@Nullable Backpack> callback) {
        if (!BackpackManager.getInstance().isBackpackStack(stack)) {
            callback.accept(null);
            return;
        }
        UUID backpackUniqueId = BackpackManager.getInstance().getBackpackUniqueId(stack);
        int tier = BackpackManager.getInstance().getBackpackTier(stack);
        this.getBackpack(backpackUniqueId, tier, callback);
    }

    public @NotNull CompletableFuture<@Nullable Backpack> getBackpackAsync(@NotNull ItemStack stack) {
        CompletableFuture<Backpack> future = new CompletableFuture<Backpack>();
        if (!BackpackManager.getInstance().isBackpackStack(stack)) {
            future.complete(null);
            return future;
        }
        UUID backpackUniqueId = BackpackManager.getInstance().getBackpackUniqueId(stack);
        int tier = BackpackManager.getInstance().getBackpackTier(stack);
        this.getBackpack(backpackUniqueId, tier, future::complete);
        return future;
    }

    public void getBackpack(@NotNull UUID backpackUniqueId, int tier, @NotNull Consumer<@Nullable Backpack> callback) {
        if (BackpackManager.getInstance().backpackIsLoaded(backpackUniqueId)) {
            callback.accept(BackpackManager.getInstance().getBackpackFromMap(backpackUniqueId));
            return;
        }
        DatabaseManager.getInstance().getDatabase().loadBackpackFromDatabaseAsync(backpackUniqueId, tier, result -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (result == null) {
                Utils.debugLogToConsole("Failed to load backpack (UUID: " + String.valueOf(backpackUniqueId) + ")");
                callback.accept(null);
                return;
            }
            callback.accept((Backpack)result);
        }));
    }

    public @NotNull CompletableFuture<@Nullable Backpack> getBackpackAsync(@NotNull UUID backpackUniqueId, int tier) {
        CompletableFuture<Backpack> future = new CompletableFuture<Backpack>();
        this.getBackpack(backpackUniqueId, tier, future::complete);
        return future;
    }
}

