/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.ziomalu.api.cache.CacheObject;
import me.ziomalu.api.logger.ErrorLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Cache {
    private static final Cache INSTANCE = new Cache();
    private static final long DEFAULT_EXPIRATION_TIME_MS = TimeUnit.MINUTES.toMillis(30L);
    private static final long CLEANUP_INTERVAL_SECONDS = 60L;
    private final ConcurrentMap<String, CacheObject<?>> cache = new ConcurrentHashMap();
    private final ScheduledExecutorService cleanupScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("cache-cleanup-%d").build());
    private static final ErrorLogger logger = ErrorLogger.getInstance();

    private Cache() {
        this.scheduleCleanup();
    }

    private void scheduleCleanup() {
        this.cleanupScheduler.scheduleAtFixedRate(this::clearExpiredEntries, 60L, 60L, TimeUnit.SECONDS);
    }

    private void clearExpiredEntries() {
        long now = System.currentTimeMillis();
        this.cache.entrySet().removeIf(entry -> ((CacheObject)entry.getValue()).isExpired(now));
    }

    public static <T> void put(@NotNull String key, @NotNull T value) {
        Cache.put(key, value, DEFAULT_EXPIRATION_TIME_MS);
    }

    public static <T> void put(@NotNull String key, @NotNull T value, long ttlMs) {
        Cache.INSTANCE.cache.put(key, new CacheObject<T>(value, System.currentTimeMillis() + ttlMs));
    }

    @Nullable
    public static <T> T get(@NotNull String key) {
        CacheObject cached = (CacheObject)Cache.INSTANCE.cache.get(key);
        return cached != null && !cached.isExpired() ? (T)cached.getValue() : null;
    }

    public static <T> T getOrCompute(@NotNull String key, @NotNull Supplier<T> supplier) {
        return Cache.getOrCompute(key, supplier, DEFAULT_EXPIRATION_TIME_MS);
    }

    public static <T> T getOrCompute(@NotNull String key, @NotNull Supplier<T> supplier, long ttlMs) {
        T value = Cache.get(key);
        if (value == null) {
            value = supplier.get();
            Cache.put(key, value, ttlMs);
        }
        return value;
    }

    public static boolean containsKey(@NotNull String key) {
        return Cache.INSTANCE.cache.containsKey(key);
    }

    public static void remove(@NotNull String key) {
        Cache.INSTANCE.cache.remove(key);
    }

    @Nullable
    public static <T> T findBy(@NotNull Predicate<T> predicate) {
        return Cache.INSTANCE.cache.values().stream().map(CacheObject::getValue).filter(Objects::nonNull).map(obj -> obj).filter(predicate).findFirst().orElse(null);
    }

    public static <T> List<T> findAllBy(@NotNull Predicate<T> predicate) {
        return new ArrayList(Cache.INSTANCE.cache.values().stream().map(CacheObject::getValue).filter(Objects::nonNull).map(obj -> obj).filter(predicate).collect(Collectors.toList()));
    }

    public static void shutdown() {
        try {
            Cache.INSTANCE.cleanupScheduler.shutdown();
            if (!Cache.INSTANCE.cleanupScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                Cache.INSTANCE.cleanupScheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.logError("Cache shutdown interrupted", e);
        }
    }

    private static class ThreadFactoryBuilder {
        private String nameFormat;

        private ThreadFactoryBuilder() {
        }

        ThreadFactoryBuilder setNameFormat(String format) {
            this.nameFormat = format;
            return this;
        }

        ThreadFactory build() {
            return r -> {
                Thread t = new Thread(r);
                if (this.nameFormat != null) {
                    t.setName(String.format(this.nameFormat, t.getId()));
                }
                t.setDaemon(true);
                return t;
            };
        }
    }
}

