/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.cache;

import java.util.UUID;

public final class CacheKeyManager {
    private CacheKeyManager() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String playerName(UUID uuid) {
        return KeyType.PLAYER_NAME.format(uuid);
    }

    public static String playerCache(UUID uuid) {
        return KeyType.PLAYER_CACHE.format(uuid);
    }

    public static String playerUUID(String name) {
        return KeyType.PLAYER_UUID.format(name.toLowerCase());
    }

    public static String skullByUUID(UUID uuid) {
        return KeyType.SKULL_ITEM_UID.format(uuid);
    }

    public static String skullByName(String name) {
        return KeyType.SKULL_ITEM_NAME.format(name);
    }

    public static String backpackTier(int tier) {
        return KeyType.BACKPACK_TIER.format(tier);
    }

    public static String playerSkull(UUID uuid) {
        return KeyType.PLAYER_SKULL.format(uuid);
    }

    public static String playerProfile(UUID uuid) {
        return KeyType.PLAYER_PROFILE.format(uuid);
    }

    public static String deathItems(UUID uuid) {
        return KeyType.PLAYER_DEATH_ITEMS.format(uuid);
    }

    public static String custom(String dataType, Object identifier) {
        return KeyType.CUSTOM_DATA.format(dataType + ":" + String.valueOf(identifier));
    }

    public static enum KeyType {
        PLAYER_NAME("PlayerName"),
        PLAYER_CACHE("PlayerCache"),
        PLAYER_UUID("PlayerUUID"),
        OFFLINE_PLAYER("OfflinePlayer"),
        SKULL_ITEM_UID("SkullItemUID"),
        SKULL_ITEM_NAME("SkullItemName"),
        BACKPACK_TIER("BackpackTier"),
        PLAYER_SKULL("PlayerSkull"),
        PLAYER_PROFILE("PlayerProfile"),
        PLAYER_DEATH_ITEMS("PlayerDeathItems"),
        CUSTOM_DATA("CustomData");

        private final String prefix;

        private KeyType(String prefix) {
            this.prefix = prefix;
        }

        public String format(Object identifier) {
            return String.format("%s:%s", this.prefix, identifier);
        }
    }
}

