/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.cache;

import java.util.Objects;

public final class CacheObject<T> {
    private final T value;
    private final long expirationTimestamp;

    CacheObject(T value, long expirationTimestamp) {
        this.value = Objects.requireNonNull(value, "Value cannot be null");
        this.expirationTimestamp = expirationTimestamp;
    }

    public T getValue() {
        return this.value;
    }

    boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    boolean isExpired(long currentTime) {
        return currentTime > this.expirationTimestamp;
    }
}

