/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.config;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import me.ziomalu.api.config.Config;
import me.ziomalu.api.config.IConfigValues;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigValues
extends Config
implements IConfigValues {
    private int missingFields = 0;

    public ConfigValues(JavaPlugin plugin) {
        super(plugin);
    }

    public ConfigValues(JavaPlugin plugin, String path, String fileName) {
        super(plugin, path, fileName);
    }

    @Override
    public <T> T getAndSaveIfNotExists(String path, T defaultValue, String ... comments) {
        if (!this.getConfig().isSet(path)) {
            this.getConfig().set(path, defaultValue);
            if (comments.length > 0) {
                this.getConfig().setComments(path, Arrays.asList(comments));
            }
            ++this.missingFields;
            return defaultValue;
        }
        Object val = defaultValue instanceof String ? this.getConfig().getString(path) : (defaultValue instanceof Integer ? Integer.valueOf(this.getConfig().getInt(path)) : (defaultValue instanceof Long ? Long.valueOf(this.getConfig().getLong(path)) : (defaultValue instanceof Boolean ? Boolean.valueOf(this.getConfig().getBoolean(path)) : (defaultValue instanceof Double ? Double.valueOf(this.getConfig().getDouble(path)) : (defaultValue instanceof List ? this.getConfig().getList(path) : this.getConfig().get(path))))));
        return (T)val;
    }

    @Override
    public <T> T getAndSaveIfNotExists(String path, T defaultValue) {
        if (!this.getConfig().isSet(path)) {
            this.getConfig().set(path, defaultValue);
            ++this.missingFields;
            return defaultValue;
        }
        Object val = defaultValue instanceof String ? this.getConfig().getString(path) : (defaultValue instanceof Integer ? Integer.valueOf(this.getConfig().getInt(path)) : (defaultValue instanceof Long ? Long.valueOf(this.getConfig().getLong(path)) : (defaultValue instanceof Boolean ? Boolean.valueOf(this.getConfig().getBoolean(path)) : (defaultValue instanceof Double ? Double.valueOf(this.getConfig().getDouble(path)) : (defaultValue instanceof List ? this.getConfig().getList(path) : this.getConfig().get(path))))));
        return (T)val;
    }

    @Override
    public int getMissingFields() {
        return this.missingFields;
    }

    @Override
    public void resetMissingFieldsCounter() {
        this.missingFields = 0;
    }

    @Override
    public void saveIfMissingFields() {
        if (this.missingFields > 0) {
            this.save();
            JavaPlugin plugin = this.getPlugin();
            if (plugin != null) {
                plugin.getLogger().info("Added " + this.missingFields + " missing fields to " + this.getFileName());
            }
            this.resetMissingFieldsCounter();
        }
    }

    @Override
    public String getStringAndSaveIfNotExists(String path, String defaultValue, String ... comments) {
        return this.getAndSaveIfNotExists(path, defaultValue, comments);
    }

    @Override
    public int getIntAndSaveIfNotExists(String path, int defaultValue, String ... comments) {
        return this.getAndSaveIfNotExists(path, defaultValue, comments);
    }

    @Override
    public boolean getBooleanAndSaveIfNotExists(String path, boolean defaultValue, String ... comments) {
        return this.getAndSaveIfNotExists(path, defaultValue, comments);
    }

    @Override
    public double getDoubleAndSaveIfNotExists(String path, double defaultValue, String ... comments) {
        return this.getAndSaveIfNotExists(path, defaultValue, comments);
    }

    @Override
    public List<String> getStringListAndSaveIfNotExists(String path, List<String> defaultValue, String ... comments) {
        return this.getAndSaveIfNotExists(path, defaultValue, comments);
    }

    @Override
    public long getLongAndSaveIfNotExists(String path, long defaultValue, String ... comments) {
        return this.getAndSaveIfNotExists(path, defaultValue, comments);
    }

    @Override
    public List<Integer> getIntegerListAndSaveIfNotExists(String path, List<Integer> defaultValue, String ... comments) {
        return this.getAndSaveIfNotExists(path, defaultValue, comments);
    }

    private JavaPlugin getPlugin() {
        try {
            Field field = Config.class.getDeclaredField("plugin");
            field.setAccessible(true);
            return (JavaPlugin)field.get(this);
        }
        catch (Exception e) {
            return null;
        }
    }
}

