/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.cooldowns;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import pl.ziomalu.backpackplus.BackpackPlus;

public abstract class Cooldown
implements Runnable {
    private final int cooldownSeconds;
    private BukkitTask task;
    private int secondsElapsed = 0;

    protected Cooldown(int seconds) {
        this.cooldownSeconds = seconds;
    }

    @Override
    public void run() {
        ++this.secondsElapsed;
        if (this.secondsElapsed < this.cooldownSeconds) {
            try {
                this.onTick();
            }
            catch (Throwable tickThrowable) {
                try {
                    this.onTickError(tickThrowable);
                }
                catch (Throwable throwable) {
                    BackpackPlus.getInstance().getLogger().warning("Failed to handle exception, got " + String.valueOf(tickThrowable) + ": " + throwable.getMessage());
                }
            }
        } else {
            this.cancel();
            this.onFinish();
        }
    }

    protected void onStart() {
    }

    protected void onTick() {
    }

    protected void onTickError(Throwable throwable) {
    }

    public abstract void onFinish();

    public final void start() {
        if (this.isRunning()) {
            BackpackPlus.getInstance().getLogger().warning("Task " + String.valueOf(this) + " is already running!");
            return;
        }
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)BackpackPlus.getInstance(), (Runnable)this, 0L, (long)this.cooldownSeconds);
        this.onStart();
    }

    protected void cancel() {
        if (this.isRunning()) {
            this.task.cancel();
        }
        this.task = null;
        this.secondsElapsed = 0;
    }

    public final boolean isRunning() {
        return this.task != null;
    }

    public int getRemainingTime() {
        return this.cooldownSeconds - this.secondsElapsed;
    }

    public int getElapsedTime() {
        return this.secondsElapsed;
    }

    @Generated
    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }
}

