/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lombok.Generated;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import me.ziomalu.api.gui.basic.GlassColors;
import me.ziomalu.api.gui.button.Button;
import me.ziomalu.api.gui.button.ButtonActionKey;
import me.ziomalu.api.gui.events.GUIOpenEvent;
import me.ziomalu.api.gui.interfaces.PageCreationCallback;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.items.CustomItems;

public abstract class GUI {
    public final HashMap<Integer, Page> pages = new HashMap();
    protected List<Player> viewers = new ArrayList<Player>();
    private boolean locked;
    private int maxCapacity = 54;
    private boolean logs = false;

    @Nullable
    public Page getFirstPage() {
        return this.pages.get(0);
    }

    @Nullable
    public Page getPage(int pageIndex) {
        return this.pages.get(pageIndex);
    }

    public List<Page> getPages() {
        return new ArrayList<Page>(this.pages.values());
    }

    public boolean hasPageNext(int index) {
        return this.pages.size() > index;
    }

    public boolean hasPagePrevious(int index) {
        return index > 0;
    }

    public void createPages(int capacity, String title, PageCreationCallback callback) {
        int requirePages = this.requiredPages(capacity);
        int requirePageSize = this.requirePageSize(capacity);
        for (int pageIndex = 0; pageIndex < requirePages; ++pageIndex) {
            String pageTitle = this.replacePageIndexOnTitle(title, pageIndex, requirePages);
            callback.execute(pageIndex, requirePageSize, pageTitle);
        }
    }

    public void createPages(int capacity, String title, Map<String, Object> variables, PageCreationCallback callback) {
        int requirePages = this.requiredPages(capacity);
        int requirePageSize = this.requirePageSize(capacity);
        variables.put("max_pages", requirePages);
        for (int pageIndex = 0; pageIndex < requirePages; ++pageIndex) {
            variables.put("page", pageIndex + 1);
            String pageTitle = StringParser.parseString(title, variables);
            callback.execute(pageIndex, requirePageSize, pageTitle);
        }
    }

    public void prepareCreatePage(int pageIndex, int pageSize, int requirePages, String title, PageCreationCallback callback) {
        String pageTitle = this.replacePageIndexOnTitle(title, pageIndex, requirePages);
        callback.execute(pageIndex, pageSize, pageTitle);
    }

    public Page createPage(InventoryHolder inventoryHolder, int index, int size, String title) {
        return new Page(inventoryHolder, index, size, title);
    }

    public void fillInTheExcess(ItemStack fillStack) {
        int totalSize = 0;
        if (this.pages.isEmpty()) {
            return;
        }
        boolean hasMultiplePages = this.pages.size() > 1;
        for (Page page : this.pages.values()) {
            Inventory currentInventory = page.getInventory();
            int inventorySize = currentInventory.getSize();
            int fillLimit = hasMultiplePages ? inventorySize - 9 : inventorySize;
            for (int slot = 0; slot < inventorySize; ++slot) {
                ItemStack slotItem = currentInventory.getItem(slot);
                if (BasicGuiItems.getInstance().isPageButtonItem(slotItem) || BasicGuiItems.getInstance().isGuiItem(slotItem)) continue;
                if (totalSize >= this.maxCapacity) {
                    currentInventory.setItem(slot, fillStack);
                }
                if (slot >= fillLimit) continue;
                ++totalSize;
            }
        }
    }

    public boolean hasPages() {
        return !this.pages.isEmpty();
    }

    public void setPage(Page page) {
        this.pages.put(page.getIndex(), page);
    }

    public String replacePageIndexOnTitle(String title, int currentPage, int maxPages) {
        title = title.replace("%page%", String.valueOf(currentPage + 1));
        title = title.replace("%max_pages%", String.valueOf(maxPages));
        return title;
    }

    public void openGUI(Player player, int pageIndex) {
        GUIOpenEvent guiOpenEvent;
        if (this.locked) {
            return;
        }
        Page page = this.getPage(pageIndex);
        if (page == null) {
            return;
        }
        player.openInventory(page.getInventory());
        if (!this.viewers.contains(player)) {
            this.viewers.add(player);
        }
        if (!(guiOpenEvent = new GUIOpenEvent(this, page, player)).isCancelled()) {
            Bukkit.getPluginManager().callEvent((Event)guiOpenEvent);
        }
    }

    public void closeInventories() {
        if (this.viewers.isEmpty()) {
            return;
        }
        this.viewers.forEach(HumanEntity::closeInventory);
    }

    public int requirePageSize(int size) {
        return size <= 9 ? 9 : (size <= 27 ? 27 : 54);
    }

    public int requiredPages(int size) {
        int requiredPageSize = this.requirePageSize(size);
        boolean isRequireButtons = size > 54;
        return (int)Math.ceil((double)size / (double)(requiredPageSize - (isRequireButtons ? 9 : 0)));
    }

    public void addButtonsIfNeed() {
        if (this.pages.isEmpty() || this.pages.size() < 2) {
            return;
        }
        ItemStack previousPageIcon = CustomItems.getPagePreviousStack();
        ItemStack nextPageIcon = CustomItems.getPageNextStack();
        for (Page page : this.pages.values()) {
            if (page.getIndex() >= 1) {
                Button pagePreviousButton = new Button(page, 45, ButtonActionKey.PAGE_PREVIOUS_KEY, previousPageIcon, new ClickType[]{ClickType.LEFT}){

                    @Override
                    public void onButtonClick(Page page, Player player, Event event) {
                        Page previous = GUI.this.getPage(page.getIndex() - 1);
                        if (previous == null) {
                            return;
                        }
                        this.getOnClickSound().playSound(player);
                        player.openInventory(previous.getInventory());
                    }
                };
                page.setItem(45, pagePreviousButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pagePreviousButton));
            }
            Button pageNextButton = new Button(page, 53, ButtonActionKey.PAGE_NEXT_KEY, nextPageIcon, new ClickType[]{ClickType.LEFT}){

                @Override
                public void onButtonClick(Page page, Player player, Event event) {
                    Page next = GUI.this.getPage(page.getIndex() + 1);
                    if (next == null) {
                        return;
                    }
                    this.getOnClickSound().playSound(player);
                    player.openInventory(next.getInventory());
                }
            };
            page.setItem(53, pageNextButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pageNextButton));
            page.fillInventory(CustomItems.getOverfillStack(), page.getIndex() >= 1 ? 46 : 45, 52);
        }
    }

    public void addButtonsIfNeed(GlassColors buttonFillColour, boolean glow) {
        if (this.pages.isEmpty() || this.pages.size() < 2) {
            return;
        }
        ItemStack previousPageIcon = CustomItems.getPagePreviousStack();
        ItemStack nextPageIcon = CustomItems.getPageNextStack();
        for (Page page : this.pages.values()) {
            if (page.getIndex() >= 1) {
                Button pagePreviousButton = new Button(page, 45, ButtonActionKey.PAGE_PREVIOUS_KEY, previousPageIcon, new ClickType[]{ClickType.LEFT}){

                    @Override
                    public void onButtonClick(Page page, Player player, Event event) {
                        Page previous = GUI.this.getPage(page.getIndex() - 1);
                        if (previous == null) {
                            return;
                        }
                        this.getOnClickSound().playSound(player);
                        player.openInventory(previous.getInventory());
                    }
                };
                page.setItem(45, pagePreviousButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pagePreviousButton));
            }
            Button pageNextButton = new Button(page, 53, ButtonActionKey.PAGE_NEXT_KEY, nextPageIcon, new ClickType[]{ClickType.LEFT}){

                @Override
                public void onButtonClick(Page page, Player player, Event event) {
                    Page next = GUI.this.getPage(page.getIndex() + 1);
                    if (next == null) {
                        return;
                    }
                    this.getOnClickSound().playSound(player);
                    player.openInventory(next.getInventory());
                }
            };
            page.setItem(53, pageNextButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pageNextButton));
            page.fillInventory(BasicGuiItems.getInstance().createBlankStainedGlassPane(buttonFillColour, glow), page.getIndex() >= 1 ? 46 : 45, 52);
        }
    }

    public void addButtonsIfNeed(GlassColors buttonFillColour, boolean glow, final Sound ... sounds) {
        if (this.pages.isEmpty() || this.pages.size() < 2) {
            return;
        }
        final Random random = new Random();
        ItemStack previousPageIcon = BasicGuiItems.getInstance().basicPreviousPageButton();
        ItemStack nextPageIcon = BasicGuiItems.getInstance().basicNextPageButton();
        for (Page page : this.pages.values()) {
            if (page.getIndex() >= 1) {
                Button pagePreviousButton = new Button(page, 45, ButtonActionKey.PAGE_PREVIOUS_KEY, previousPageIcon, new ClickType[]{ClickType.LEFT}){

                    @Override
                    public void onButtonClick(Page page, Player player, Event event) {
                        Page previous = GUI.this.getPage(page.getIndex() - 1);
                        if (previous == null) {
                            return;
                        }
                        if (sounds.length != 0) {
                            this.getOnClickSound().setSound(sounds[sounds.length == 1 ? 0 : random.nextInt(0, sounds.length)]);
                        }
                        this.getOnClickSound().playSound(player);
                        player.openInventory(previous.getInventory());
                    }
                };
                page.setItem(45, pagePreviousButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pagePreviousButton));
            }
            Button pageNextButton = new Button(page, 53, ButtonActionKey.PAGE_NEXT_KEY, nextPageIcon, new ClickType[]{ClickType.LEFT}){

                @Override
                public void onButtonClick(Page page, Player player, Event event) {
                    Page next = GUI.this.getPage(page.getIndex() + 1);
                    if (next == null) {
                        return;
                    }
                    if (sounds.length != 0) {
                        this.getOnClickSound().setSound(sounds[sounds.length == 1 ? 0 : random.nextInt(0, sounds.length)]);
                    }
                    this.getOnClickSound().playSound(player);
                    player.openInventory(next.getInventory());
                }
            };
            page.setItem(53, pageNextButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pageNextButton));
            page.fillInventory(BasicGuiItems.getInstance().createBlankStainedGlassPane(buttonFillColour, glow), page.getIndex() >= 1 ? 46 : 45, 52);
        }
    }

    public void addButtonsIfNeed(ItemStack buttonFillStack, ItemStack previousPageStack, ItemStack nextPageStack, final Sound ... sounds) {
        if (this.pages.isEmpty() || this.pages.size() < 2) {
            return;
        }
        final Random random = new Random();
        for (Page page : this.pages.values()) {
            if (page.getIndex() >= 1) {
                Button pagePreviousButton = new Button(page, 45, ButtonActionKey.PAGE_PREVIOUS_KEY, previousPageStack, new ClickType[]{ClickType.LEFT}){

                    @Override
                    public void onButtonClick(Page page, Player player, Event event) {
                        Page previous = GUI.this.getPage(page.getIndex() - 1);
                        if (previous == null) {
                            return;
                        }
                        if (sounds.length != 0) {
                            this.getOnClickSound().setSound(sounds[sounds.length == 1 ? 0 : random.nextInt(0, sounds.length)]);
                        }
                        this.getOnClickSound().playSound(player);
                        player.openInventory(previous.getInventory());
                    }
                };
                page.setItem(45, pagePreviousButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pagePreviousButton));
            }
            if (page.getIndex() < this.pages.size() - 1) {
                Button pageNextButton = new Button(page, 53, ButtonActionKey.PAGE_NEXT_KEY, nextPageStack, new ClickType[]{ClickType.LEFT}){

                    @Override
                    public void onButtonClick(Page page, Player player, Event event) {
                        Page next = GUI.this.getPage(page.getIndex() + 1);
                        if (next == null) {
                            return;
                        }
                        if (sounds.length != 0) {
                            this.getOnClickSound().setSound(sounds[sounds.length == 1 ? 0 : random.nextInt(0, sounds.length)]);
                        }
                        this.getOnClickSound().playSound(player);
                        player.openInventory(next.getInventory());
                    }
                };
                page.setItem(53, pageNextButton.getButtonIcon(), (slot, itemStack) -> page.addButton(slot, pageNextButton));
            }
            page.fillInventory(buttonFillStack, page.getIndex() >= 1 ? 46 : 45, page.getIndex() < this.pages.size() - 1 ? 52 : 53);
        }
    }

    public boolean hasViewers() {
        for (Page page : this.pages.values()) {
            Inventory inv = page.getInventory();
            if (inv.getViewers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Generated
    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    @Generated
    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    @Generated
    public void setLogs(boolean logs) {
        this.logs = logs;
    }
}

