/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.ziomalu.api.gui.button.Button;
import me.ziomalu.api.gui.interfaces.SetItemInGUICallback;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.inventoryholders.BackpackInventoryHolder;
import pl.ziomalu.backpackplus.utils.Utils;

public class Page {
    private final InventoryHolder inventoryHolder;
    protected final Map<Integer, List<Button>> buttons;
    private final int index;
    private String title;
    private int size;
    private Inventory inventory;

    public Page(InventoryHolder inventoryHolder, int index, int size, String title) {
        this.inventoryHolder = inventoryHolder;
        this.index = index;
        this.buttons = new HashMap<Integer, List<Button>>();
        this.title = title;
        this.size = size;
        this.updateInventory();
    }

    public void addButton(int slot, Button button) {
        this.buttons.computeIfAbsent(slot, k -> new ArrayList()).add(button);
        this.inventory.setItem(slot, button.getButtonIcon());
    }

    public void addButton(Button button) {
        this.addButton(button.getButtonSlot(), button);
    }

    public void setButton(int slot, boolean setIcon, Button ... buttons) {
        this.buttons.put(slot, List.of(buttons));
        if (setIcon) {
            this.inventory.setItem(slot, buttons[0].getButtonIcon());
        }
    }

    @Nullable
    public Button getButton(int slot, ClickType clickType) {
        List<Button> existingButtons = this.buttons.get(slot);
        if (existingButtons != null) {
            return existingButtons.stream().filter(button -> button.hasAction(clickType)).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    public Button getButton(int slot) {
        List<Button> existingButtons = this.buttons.get(slot);
        return existingButtons != null && !existingButtons.isEmpty() ? existingButtons.get(0) : null;
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateInventory();
    }

    public void setSize(int size) {
        this.size = size;
        this.updateInventory();
    }

    protected void updateInventory() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this.inventoryHolder, (int)this.size, (String)this.title);
    }

    public void setItem(int slot, ItemStack stack, SetItemInGUICallback callback) {
        this.inventory.setItem(slot, stack);
        callback.execute(slot, stack);
    }

    @Nullable
    public ItemStack getItem(int slot) {
        return this.inventory.getItem(slot);
    }

    public void addItem(ItemStack ... stacks) {
        this.inventory.addItem(stacks);
    }

    public void fillInventory(ItemStack stack, int startSlot, int endSlot) {
        int start = Math.max(0, startSlot);
        int end = Math.min(endSlot, this.size);
        for (int i = start; i <= end; ++i) {
            this.inventory.setItem(i, stack);
        }
    }

    private void handleBackpackInventoryClick(InventoryClickEvent e, BackpackInventoryHolder bpInventoryHolder) {
        ItemStack currentItem = e.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        Backpack backpack = BackpackManager.getInstance().getBackpackFromMap(bpInventoryHolder.backpackUniqueId());
        if (backpack != null) {
            backpack.updateUse();
        }
        if (Utils.isGuiOrPageButtonItem(currentItem)) {
            this.handleGuiButtonClick(e);
        }
    }

    public void handleGuiButtonClick(InventoryClickEvent e) {
        e.setCancelled(true);
        e.setResult(Event.Result.DENY);
        Button button = this.getButton(e.getSlot(), e.getClick());
        if (button == null) {
            return;
        }
        button.onButtonClick(this, (Player)e.getWhoClicked(), (Event)e);
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }
}

