/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.gui.basic;

import lombok.Generated;
import me.ziomalu.api.gui.basic.GlassColors;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.utils.SkullCreator;
import pl.ziomalu.backpackplus.utils.Text;

public class BasicGuiItems {
    private static BasicGuiItems instance;
    public static NamespacedKey GUI_ITEM;
    public static NamespacedKey BUTTON_NAMESPACE;
    private ItemStack basicPageNextStack;
    private ItemStack basicPagePreviousStack;

    public BasicGuiItems(Plugin plugin) {
        instance = this;
        GUI_ITEM = new NamespacedKey(plugin, "GUI_ITEM");
        BUTTON_NAMESPACE = new NamespacedKey(plugin, "BUTTON_NAMESPACE");
    }

    public ItemStack createBlankStainedGlassPane(GlassColors glassColor, boolean glowing) {
        ItemStack stack = new ItemStack(glassColor.getGlassPaneMaterial());
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        meta.setDisplayName(" ");
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE, ItemFlag.HIDE_PLACED_ON});
        if (glowing) {
            try {
                meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            }
            catch (NoSuchMethodError ignore) {
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        persistentDataContainer.set(GUI_ITEM, PersistentDataType.STRING, (Object)"blank");
        stack.setItemMeta(meta);
        return stack;
    }

    public ItemStack createBlankStainedGlassPane(GlassColors glassColor, String displayName, boolean glowing) {
        ItemStack stack = new ItemStack(glassColor.getGlassPaneMaterial());
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        meta.setDisplayName(displayName);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE, ItemFlag.HIDE_PLACED_ON});
        if (glowing) {
            try {
                meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            }
            catch (NoSuchMethodError ignore) {
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        persistentDataContainer.set(GUI_ITEM, PersistentDataType.STRING, (Object)"blank");
        stack.setItemMeta(meta);
        return stack;
    }

    public ItemStack basicNextPageButton() {
        if (this.basicPageNextStack != null) {
            return this.basicPageNextStack;
        }
        ItemStack skull = SkullCreator.itemFromUrl("http://textures.minecraft.net/texture/2b4e34d04d3a565f61668c709307c3519a4f706a69f0de20d2f03bdbc17e9205");
        ItemMeta meta = skull.getItemMeta();
        if (meta == null) {
            return skull;
        }
        meta.setDisplayName(Text.setColour("&2&l\u2192"));
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        persistentDataContainer.set(BUTTON_NAMESPACE, PersistentDataType.STRING, (Object)"button");
        skull.setItemMeta(meta);
        this.basicPageNextStack = skull;
        return skull;
    }

    public ItemStack basicPreviousPageButton() {
        if (this.basicPagePreviousStack != null) {
            return this.basicPagePreviousStack;
        }
        ItemStack skull = SkullCreator.itemFromUrl("http://textures.minecraft.net/texture/1fc2611fbabe4e799062f6b470ac5ae727e32ef00d2b115d38656e341c128936");
        ItemMeta meta = skull.getItemMeta();
        if (meta == null) {
            return skull;
        }
        meta.setDisplayName(Text.setColour("&c&l\u2190"));
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        persistentDataContainer.set(BUTTON_NAMESPACE, PersistentDataType.STRING, (Object)"button");
        skull.setItemMeta(meta);
        this.basicPagePreviousStack = skull;
        return skull;
    }

    public boolean isGuiItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!stack.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        return persistentDataContainer.has(GUI_ITEM, PersistentDataType.STRING);
    }

    public boolean isPageButtonItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!stack.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        return persistentDataContainer.has(BUTTON_NAMESPACE, PersistentDataType.STRING);
    }

    @Generated
    public static BasicGuiItems getInstance() {
        return instance;
    }
}

