/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.gui.button;

import java.util.Arrays;
import lombok.Generated;
import me.ziomalu.api.cooldowns.Cooldown;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.button.ButtonActionKey;
import me.ziomalu.api.gui.button.ButtonSound;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Button {
    private final Page page;
    private final ButtonActionKey actionKey;
    private final ClickType[] availableClicks;
    private ItemStack buttonIcon;
    private ButtonSound onClickSound;
    private Object param;
    private final int buttonSlot;
    private Cooldown cooldown;
    private boolean availableClick = true;

    public Button(Page page, int buttonSlot, ButtonActionKey actionKey, ItemStack buttonIcon, ClickType ... clickTypes) {
        this.page = page;
        this.buttonSlot = buttonSlot;
        this.actionKey = actionKey;
        this.buttonIcon = buttonIcon;
        this.availableClicks = clickTypes;
        this.onClickSound = new ButtonSound(Sound.UI_BUTTON_CLICK);
    }

    public Button(Page page, int buttonSlot, ButtonActionKey actionKey, ItemStack buttonIcon, Object param, ClickType ... clickTypes) {
        this.page = page;
        this.buttonSlot = buttonSlot;
        this.actionKey = actionKey;
        this.buttonIcon = buttonIcon;
        this.availableClicks = clickTypes;
        this.param = param;
        this.onClickSound = new ButtonSound(Sound.UI_BUTTON_CLICK);
    }

    public abstract void onButtonClick(Page var1, Player var2, Event var3);

    public boolean hasAction(ClickType clickType) {
        if (this.availableClicks.length == 0) {
            return true;
        }
        return Arrays.asList(this.availableClicks).contains(clickType);
    }

    public boolean hasCooldown() {
        return this.cooldown != null;
    }

    public void updateButtonIcon(ItemStack buttonIcon) {
        Inventory inventory = this.page.getInventory();
        this.buttonIcon = buttonIcon;
        inventory.setItem(this.buttonSlot, buttonIcon);
        inventory.getViewers().forEach(humanEntity -> {
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                player.updateInventory();
            }
        });
    }

    public void updateButton(ItemMeta buttonMeta) {
        this.buttonIcon.setItemMeta(buttonMeta);
    }

    @Generated
    public Page getPage() {
        return this.page;
    }

    @Generated
    public ButtonActionKey getActionKey() {
        return this.actionKey;
    }

    @Generated
    public ClickType[] getAvailableClicks() {
        return this.availableClicks;
    }

    @Generated
    public ItemStack getButtonIcon() {
        return this.buttonIcon;
    }

    @Generated
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Generated
    public void setButtonIcon(ItemStack buttonIcon) {
        this.buttonIcon = buttonIcon;
    }

    @Generated
    public void setOnClickSound(ButtonSound onClickSound) {
        this.onClickSound = onClickSound;
    }

    @Generated
    public ButtonSound getOnClickSound() {
        return this.onClickSound;
    }

    @Generated
    public Object getParam() {
        return this.param;
    }

    @Generated
    public int getButtonSlot() {
        return this.buttonSlot;
    }

    @Generated
    public void setCooldown(Cooldown cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public boolean isAvailableClick() {
        return this.availableClick;
    }

    @Generated
    public void setAvailableClick(boolean availableClick) {
        this.availableClick = availableClick;
    }
}

