/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.gui.button;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ButtonActionKey {
    public static final ButtonActionKey PAGE_NEXT_KEY = new ButtonActionKey("page_next_key");
    public static final ButtonActionKey PAGE_PREVIOUS_KEY = new ButtonActionKey("page_previous_key");
    public static final ButtonActionKey PAGE_NONE_KEY = new ButtonActionKey("page_none_key");
    public static final ButtonActionKey PAGE_CLOSE_KEY = new ButtonActionKey("page_close_key");
    private final String key;

    private static boolean isValidNamespaceChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-';
    }

    private static boolean isValidKeyChar(char c) {
        return ButtonActionKey.isValidNamespaceChar(c) || c == '/';
    }

    private static boolean isValidKey(String key) {
        int len = key.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (ButtonActionKey.isValidKeyChar(key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public ButtonActionKey(@NotNull String key) {
        Preconditions.checkArgument((boolean)ButtonActionKey.isValidKey(key), (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)key);
        this.key = key;
        String string = this.toString();
        Preconditions.checkArgument((string.length() < 256 ? 1 : 0) != 0, (String)"ButtonActionKey must be less than 256 characters", (Object)string);
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.key.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ButtonActionKey other = (ButtonActionKey)obj;
        return this.key.equals(other.key);
    }

    public String toString() {
        return this.key;
    }

    @NotNull
    public static ButtonActionKey randomKey() {
        return new ButtonActionKey(UUID.randomUUID().toString());
    }

    public static ButtonActionKey fromString(@NotNull String string) {
        Preconditions.checkArgument((!string.isEmpty() ? 1 : 0) != 0, (Object)"Input string must not be empty or null");
        return new ButtonActionKey(string);
    }
}

