/*
 * Decompiled with CFR 0.152.
 */
package me.ziomalu.api.logger;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;

public class ErrorLogger {
    private static ErrorLogger instance;
    private final Path logFilePath;
    private static final DateTimeFormatter formatter;

    private ErrorLogger() {
        String logsDir = "logs";
        try {
            Files.createDirectories(Paths.get(logsDir, new String[0]), new FileAttribute[0]);
            this.logFilePath = Paths.get(logsDir, "error.log");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create logs directory", e);
        }
    }

    public static synchronized ErrorLogger getInstance() {
        if (instance == null) {
            instance = new ErrorLogger();
        }
        return instance;
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Throwable throwable) {
        try {
            StringBuilder logEntry = new StringBuilder().append("[").append(LocalDateTime.now().format(formatter)).append("] ERROR: ").append(message).append("\n");
            if (throwable != null) {
                logEntry.append("Stack trace:\n");
                for (StackTraceElement element : throwable.getStackTrace()) {
                    logEntry.append("\tat ").append(element.toString()).append("\n");
                }
            }
            Files.write(this.logFilePath, logEntry.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Failed to write to error log: " + e.getMessage());
        }
    }

    public void logError(Level level, String message) {
        String levelPrefix = "[" + level.getName() + "] ";
        this.logError(levelPrefix + message);
    }

    public String getLogFilePath() {
        return this.logFilePath.toString();
    }

    public void clearLog() {
        try {
            Files.write(this.logFilePath, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Failed to clear log file: " + e.getMessage());
        }
    }

    static {
        formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }
}

