/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.Generated;
import me.ziomalu.api.ItemUtil;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.cache.CacheKeyManager;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.enums.State;
import pl.ziomalu.backpackplus.gui.backpack.PlayerBackpacksGUI;
import pl.ziomalu.backpackplus.interfaces.Callback;
import pl.ziomalu.backpackplus.inventoryholders.BackpackInventoryHolder;
import pl.ziomalu.backpackplus.items.Item;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.OfflinePlayersData;
import pl.ziomalu.backpackplus.utils.Utils;

public final class BackpackManager {
    private static BackpackManager instance;
    private static final NamespacedKey backpackUniqueIdKey;
    private static final NamespacedKey backpackUsed;
    private static final NamespacedKey backpackTierKey;
    private static final NamespacedKey database;
    private final Plugin plugin;
    private final FileConfiguration pluginConfig;
    private final ConcurrentMap<UUID, Backpack> backpacksMap;
    private final ConcurrentMap<UUID, Long> playersCooldowns;
    private final ConcurrentMap<UUID, UUID> backpacksUsedByPlayers;
    private final ConcurrentMap<Integer, BackpackSettings> backpackSettingsMap;
    private final ConcurrentMap<UUID, PlayerBackpacksGUI> playersBackpacksGUI;
    private final ConcurrentMap<UUID, ItemStack> playersBackpackInHand;
    private final List<ItemStack> blockedItemStacks;
    private final List<String> blockedEncodedItemStacks;
    private final List<Material> blockedMaterials;
    private final List<String> blockedMaterialsNames;
    private final List<ItemStack> backpackList = new ArrayList<ItemStack>();

    public BackpackManager(Plugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.pluginConfig = BackpackPlus.getInstance().getConfig();
        this.backpacksMap = new ConcurrentHashMap<UUID, Backpack>();
        this.playersCooldowns = new ConcurrentHashMap<UUID, Long>();
        this.backpacksUsedByPlayers = new ConcurrentHashMap<UUID, UUID>();
        this.backpackSettingsMap = new ConcurrentHashMap<Integer, BackpackSettings>();
        this.playersBackpacksGUI = new ConcurrentHashMap<UUID, PlayerBackpacksGUI>();
        this.playersBackpackInHand = new ConcurrentHashMap<UUID, ItemStack>();
        this.blockedItemStacks = new ArrayList<ItemStack>();
        this.blockedEncodedItemStacks = new ArrayList<String>();
        this.blockedMaterials = new ArrayList<Material>();
        this.blockedMaterialsNames = new ArrayList<String>();
        this.loadBlocked();
    }

    public Collection<Backpack> getBackpacks() {
        return this.backpacksMap.values();
    }

    public boolean backpackIsLoaded(UUID backpackUniqueId) {
        return this.backpacksMap.containsKey(backpackUniqueId);
    }

    public Backpack getBackpackFromMap(UUID backpackUniqueId) {
        return this.backpacksMap.getOrDefault(backpackUniqueId, null);
    }

    public void addBackpackToMap(Backpack backpack) {
        this.backpacksMap.put(backpack.getBackpackUniqueId(), backpack);
    }

    public void removeBackpackFromMap(UUID backpackUUID) {
        this.backpacksMap.remove(backpackUUID);
    }

    public List<Backpack> findBackpacksByLastPlayer(UUID playerUuid) {
        return this.backpacksMap.values().stream().filter(backpack -> playerUuid.equals(backpack.getLastPlayerUniqueId())).collect(Collectors.toList());
    }

    public void addPlayerCooldown(UUID playerUniqueId) {
        this.playersCooldowns.put(playerUniqueId, System.currentTimeMillis());
    }

    public boolean playerHasCooldown(UUID playerUniqueId, long cooldown) {
        if (!this.playersCooldowns.containsKey(playerUniqueId)) {
            return false;
        }
        long timeElapsed = System.currentTimeMillis() - this.getPlayerCooldown(playerUniqueId);
        if (timeElapsed < cooldown) {
            return true;
        }
        this.removePlayerCooldown(playerUniqueId);
        return false;
    }

    public long getPlayerCooldown(UUID playerUniqueId) {
        return this.playersCooldowns.getOrDefault(playerUniqueId, 0L);
    }

    public void removePlayerCooldown(UUID playerUniqueId) {
        this.playersCooldowns.remove(playerUniqueId);
    }

    public boolean playerUsedBackpack(UUID playerUniqueId) {
        return this.backpacksUsedByPlayers.get(playerUniqueId) != null;
    }

    public UUID getPlayerUsingBackpack(UUID playerUniqueId) {
        return (UUID)this.backpacksUsedByPlayers.get(playerUniqueId);
    }

    public void removeBackpackUsedByPlayer(UUID playerUniqueId) {
        this.backpacksUsedByPlayers.remove(playerUniqueId);
    }

    public Set<Integer> getBackpacksTiers() {
        return this.backpackSettingsMap.keySet();
    }

    public BackpackSettings getBackpackSettingsByTier(int backpackTier) {
        return this.backpackSettingsMap.getOrDefault(backpackTier, null);
    }

    public List<BackpackSettings> getBackpackSettings() {
        return new ArrayList<BackpackSettings>(this.backpackSettingsMap.values());
    }

    public void addBackpackSettings(BackpackSettings backpackSettings) {
        this.backpackSettingsMap.put(backpackSettings.getData().getTier(), backpackSettings);
    }

    public void clearBackpackSettings() {
        this.backpackSettingsMap.clear();
    }

    public void addBackpackItem(ItemStack backpackStack) {
        this.backpackList.add(backpackStack);
    }

    public void clearBackpacksItem() {
        this.backpackList.clear();
    }

    public void setBackpackUsedKeys(@NotNull ItemStack stack, UUID backpackUniqueId) {
        ItemMeta bMeta = stack.getItemMeta();
        Preconditions.checkArgument((bMeta != null ? 1 : 0) != 0, (Object)"ItemMeta cannot be null");
        PersistentDataContainer pdc = bMeta.getPersistentDataContainer();
        pdc.set(backpackUniqueIdKey, PersistentDataType.STRING, (Object)backpackUniqueId.toString());
        pdc.set(backpackUsed, PersistentDataType.INTEGER, (Object)1);
        pdc.set(database, PersistentDataType.STRING, (Object)DatabaseManager.getInstance().getType().name());
        try {
            bMeta.setMaxStackSize(Integer.valueOf(1));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        stack.setItemMeta(bMeta);
    }

    public void removeBackpackUsedKeys(ItemStack backpackStack) {
        ItemMeta bMeta = backpackStack.getItemMeta();
        Preconditions.checkArgument((bMeta != null ? 1 : 0) != 0, (Object)"ItemMeta cannot be null");
        PersistentDataContainer pdc = bMeta.getPersistentDataContainer();
        pdc.remove(backpackUniqueIdKey);
        pdc.set(backpackUsed, PersistentDataType.INTEGER, (Object)0);
        pdc.remove(database);
        try {
            bMeta.setMaxStackSize(Integer.valueOf(64));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        backpackStack.setItemMeta(bMeta);
    }

    public boolean backpackIsUsed(@NotNull ItemStack backpackStack) {
        ItemMeta meta = backpackStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return (Integer)pdc.getOrDefault(backpackUsed, PersistentDataType.INTEGER, (Object)0) == 1;
    }

    public int getBackpackTier(@NotNull ItemStack backpackStack) {
        ItemMeta meta = backpackStack.getItemMeta();
        if (meta == null) {
            return 0;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return (Integer)pdc.getOrDefault(backpackTierKey, PersistentDataType.INTEGER, (Object)0);
    }

    public UUID getBackpackUniqueId(@NotNull ItemStack backpackStack) {
        ItemMeta meta = backpackStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        String uniqueIdValue = (String)pdc.get(backpackUniqueIdKey, PersistentDataType.STRING);
        return uniqueIdValue != null ? UUID.fromString(uniqueIdValue) : null;
    }

    public boolean isBackpackStack(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR || !stack.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        return meta != null && meta.getPersistentDataContainer().has(backpackTierKey, PersistentDataType.INTEGER);
    }

    public int getBackpackSpace(int tier) {
        BackpackSettings settings = this.getBackpackSettingsByTier(tier);
        return settings != null ? settings.getData().getSize() : 0;
    }

    public void loadBlocked() {
        this.blockedMaterials.clear();
        this.blockedItemStacks.clear();
        this.blockedEncodedItemStacks.clear();
        this.blockedMaterialsNames.clear();
        this.loadBlockedMaterials(this.pluginConfig);
        this.loadBlockedItems(this.pluginConfig);
    }

    private void loadBlockedMaterials(FileConfiguration config) {
        if (config.isSet("blocked-materials")) {
            for (String matName : config.getStringList("blocked-materials")) {
                Material material = Material.getMaterial((String)matName.toUpperCase());
                if (material == null) {
                    this.plugin.getLogger().warning("Invalid material: " + matName + " Path: blocked-materials");
                    continue;
                }
                this.blockedMaterialsNames.add(matName);
                this.blockedMaterials.add(material);
            }
        }
    }

    private void loadBlockedItems(FileConfiguration config) {
        if (config.isSet("blocked-items")) {
            for (String encodedStr : config.getStringList("blocked-items")) {
                try {
                    ItemStack decodedStack = ItemUtil.itemFromBase64(encodedStr);
                    if (decodedStack == null) continue;
                    this.handleFireworks(decodedStack);
                    decodedStack.setAmount(1);
                    this.blockedItemStacks.add(decodedStack);
                    this.blockedEncodedItemStacks.add(encodedStr);
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to decode blocked item: ", ex);
                }
            }
        }
    }

    private void handleFireworks(ItemStack stack) {
        ItemMeta itemMeta;
        if (stack.hasItemMeta() && (itemMeta = stack.getItemMeta()) instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemMeta;
            if (fireworkMeta.getEffects().isEmpty()) {
                fireworkMeta.addEffect(FireworkEffect.builder().with(FireworkEffect.Type.BALL).withColor(Color.AQUA).build());
                fireworkMeta.removeEffect(0);
            }
            stack.setItemMeta((ItemMeta)fireworkMeta);
        }
    }

    public void addBlockedMaterial(Material type) {
        if (!this.blockedMaterials.contains(type)) {
            this.blockedMaterials.add(type);
            this.blockedMaterialsNames.add(type.name());
        }
    }

    public void addBlockedItem(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR) {
            return;
        }
        ItemStack clonedStack = stack.clone();
        clonedStack.setAmount(1);
        if (Item.isCustomItem(clonedStack)) {
            if (!this.blockedItemStacks.contains(clonedStack)) {
                this.blockedItemStacks.add(clonedStack);
                String encoded = ItemUtil.itemToBase64(clonedStack);
                if (!this.blockedEncodedItemStacks.contains(encoded)) {
                    this.blockedEncodedItemStacks.add(encoded);
                }
            }
        } else {
            this.addBlockedMaterial(clonedStack.getType());
        }
    }

    public boolean isBlocked(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR) {
            return false;
        }
        ItemStack clonedStack = stack.clone();
        clonedStack.setAmount(1);
        boolean isCustom = Item.isCustomItem(clonedStack);
        if (isCustom) {
            return this.blockedItemStacks.contains(clonedStack);
        }
        return this.blockedMaterials.contains(clonedStack.getType());
    }

    public boolean isBlocked(Material type) {
        return this.blockedMaterials.contains(type);
    }

    public void saveBlockedItems() {
        this.pluginConfig.set("blocked-materials", this.blockedMaterialsNames);
        this.pluginConfig.set("blocked-items", this.blockedEncodedItemStacks);
        BackpackPlus.getInstance().saveConfig();
    }

    public Collection<PlayerBackpacksGUI> getPlayersBackpacksGUI() {
        return this.playersBackpacksGUI.values();
    }

    public void addPlayerBackpacksGUI(PlayerBackpacksGUI playerBackpacksGUI) {
        this.playersBackpacksGUI.put(playerBackpacksGUI.getPlayerUniqueId(), playerBackpacksGUI);
    }

    public void removePlayerBackpackGUI(UUID playerUniqueId) {
        this.playersBackpacksGUI.remove(playerUniqueId);
    }

    public PlayerBackpacksGUI getPlayerBackpackGUIFromMap(UUID playerUniqueId) {
        return (PlayerBackpacksGUI)this.playersBackpacksGUI.get(playerUniqueId);
    }

    public boolean hasPlayerBackpacksGUI(UUID playerUniqueId) {
        return this.playersBackpacksGUI.containsKey(playerUniqueId);
    }

    public void addPlayerBackpackUsedStack(UUID playerUniqueId, ItemStack backpackStack) {
        if (backpackStack != null) {
            this.playersBackpackInHand.put(playerUniqueId, backpackStack);
        }
    }

    public ItemStack getPlayerUsedBackpackStack(UUID playerUniqueId) {
        return (ItemStack)this.playersBackpackInHand.get(playerUniqueId);
    }

    public void removePlayerUsedBackpackStack(UUID playerUniqueId) {
        this.playersBackpackInHand.remove(playerUniqueId);
    }

    public void openPlayerBackpackByUniqueId(Player player, UUID playerUniqueId) {
        if (!this.hasPlayerBackpacksGUI(playerUniqueId)) {
            this.handleNewBackpackGUI(player, playerUniqueId);
            return;
        }
        PlayerBackpacksGUI gui = this.getPlayerBackpackGUIFromMap(playerUniqueId);
        this.addPlayerBackpacksGUI(gui);
        if (gui.hasBackpacks()) {
            if (gui.isLoaded() && gui.getFirstPage() != null) {
                player.openInventory(gui.getFirstPage().getInventory());
            } else {
                this.sendMessage(player, "players-backpack-not-loaded");
            }
        } else {
            this.sendMessage(player, "player-not-created-backpacks");
        }
    }

    public void openPlayerBackpackByName(Player player, String playerName) {
        UUID playerUniqueId = (UUID)Cache.get(CacheKeyManager.playerUUID(playerName));
        if (playerUniqueId == null) {
            playerUniqueId = OfflinePlayersData.getInstance().getPlayerUniqueId(playerName);
        }
        if (playerUniqueId == null) {
            this.sendMessage(player, "player-is-offline", "%player%", playerName);
            return;
        }
        if (!this.hasPlayerBackpacksGUI(playerUniqueId)) {
            this.handleNewBackpackGUI(player, playerUniqueId);
            return;
        }
        PlayerBackpacksGUI gui = this.getPlayerBackpackGUIFromMap(playerUniqueId);
        gui.updateLastUse();
        this.addPlayerBackpacksGUI(gui);
        if (gui.hasBackpacks()) {
            if (gui.getFirstPage() != null) {
                player.openInventory(gui.getFirstPage().getInventory());
            } else {
                this.sendMessage(player, "players-backpack-not-loaded");
            }
        } else {
            this.sendMessage(player, "loading-in-progress");
        }
    }

    private void handleNewBackpackGUI(Player player, UUID playerUniqueId) {
        PlayerBackpacksGUI gui = new PlayerBackpacksGUI(playerUniqueId);
        if (gui.getCreationState() == State.LOADING) {
            this.sendMessage(player, "loading-in-progress");
        }
        if (gui.hasBackpacks()) {
            this.openBackpackGUIIfLoaded(player, gui);
        } else {
            this.sendMessage(player, "player-not-created-backpacks");
        }
        this.addPlayerBackpacksGUI(gui);
    }

    public void openBackpackGUIIfLoaded(Player player, PlayerBackpacksGUI gui) {
        Bukkit.getScheduler().runTaskLater((Plugin)BackpackPlus.getInstance(), task -> {
            if (gui.isLoaded() && gui.getCreationState() == State.LOADED) {
                player.openInventory(gui.getFirstPage().getInventory());
            } else if (gui.getCreationState() == State.LOADING) {
                this.openBackpackGUIIfLoaded(player, gui);
            } else {
                task.cancel();
            }
        }, 1L);
    }

    public final void sendMessage(Player player, String messageKey) {
        Utils.sendMessage(player, LanguageManager.getInstance().getString(messageKey));
    }

    public final void sendMessage(Player player, String messageKey, String placeholder, String value) {
        Utils.sendMessage(player, LanguageManager.getInstance().getString(messageKey).replace(placeholder, value));
    }

    public void playerHasOpenBackpackInventory(Player player, Callback callback) {
        Bukkit.getScheduler().runTaskLater((Plugin)BackpackPlus.getInstance(), () -> {
            if (player == null || !player.isOnline()) {
                callback.execute(false);
                return;
            }
            boolean hasOpen = player.getOpenInventory().getTopInventory().getHolder() instanceof BackpackInventoryHolder;
            callback.execute(hasOpen);
        }, 1L);
    }

    public void closeAllBackpacks() {
        if (this.backpacksMap.isEmpty()) {
            return;
        }
        for (Backpack backpack : this.backpacksMap.values()) {
            if (backpack == null) continue;
            backpack.closeAndSaveBackpack(true);
        }
    }

    public void saveAllBackpacksOnShutdown() {
        ArrayList backpacks = new ArrayList(this.backpacksMap.values());
        if (backpacks.isEmpty()) {
            Utils.debugLogToConsole(Level.INFO, "No backpacks to save on shutdown.");
            return;
        }
        Utils.debugLogToConsole(Level.INFO, "Saving " + backpacks.size() + " backpacks to the database...");
        for (Backpack backpack : backpacks) {
            backpack.closeBackpackInventory(true);
            try {
                DatabaseManager.getInstance().getDatabase().saveBackpackToDatabaseAsync(backpack, result -> {
                    if (result.booleanValue()) {
                        Utils.debugLogToConsole(Level.INFO, "Backpack " + String.valueOf(backpack.getBackpackUniqueId()) + " saved successfully.");
                    } else {
                        Utils.debugLogToConsole(Level.WARNING, "Failed to save backpack " + String.valueOf(backpack.getBackpackUniqueId()) + ".");
                    }
                });
            }
            catch (Exception ex) {
                Utils.debugLogToConsole(Level.SEVERE, "Error saving backpack " + String.valueOf(backpack.getBackpackUniqueId()), ex);
            }
        }
        Utils.debugLogToConsole(Level.INFO, "All backpacks have been saved.");
    }

    public void startAutoSaveTask() {
        BackpackPlus.getInstance().getServer().getScheduler().runTaskTimerAsynchronously((Plugin)BackpackPlus.getInstance(), this::saveAllBackpacksOnShutdown, 6000L, 6000L);
    }

    @Generated
    public static BackpackManager getInstance() {
        return instance;
    }

    @Generated
    public static NamespacedKey getBackpackUniqueIdKey() {
        return backpackUniqueIdKey;
    }

    @Generated
    public static NamespacedKey getBackpackUsed() {
        return backpackUsed;
    }

    @Generated
    public static NamespacedKey getBackpackTierKey() {
        return backpackTierKey;
    }

    @Generated
    public static NamespacedKey getDatabase() {
        return database;
    }

    @Generated
    public List<ItemStack> getBackpackList() {
        return this.backpackList;
    }

    static {
        backpackUniqueIdKey = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "backpackuuid");
        backpackUsed = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "backpackused");
        backpackTierKey = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "backpacktier");
        database = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "database");
    }
}

