/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus;

import java.text.SimpleDateFormat;
import java.util.Random;
import java.util.logging.Level;
import lombok.Generated;
import me.ziomalu.api.backpackplus.BackpackPlusAPI;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.init.Initialize;
import pl.ziomalu.backpackplus.items.BackpacksItems;
import pl.ziomalu.backpackplus.utils.Utils;

public final class BackpackPlus
extends JavaPlugin {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static BackpackPlus instance;
    private Random random;
    public BukkitTask clearCacheTask = null;
    private boolean isServerShutdown;
    public BackpackPlusAPI backpackPlusAPI;

    public void onEnable() {
        instance = this;
        this.isServerShutdown = false;
        this.saveDefaultConfig();
        if (!this.checkConfig()) {
            this.getLogger().severe("Outdated configuration detected.\nAction required:\n - Back up or rename config.yml\n - Restart the server to generate a new config\n - Merge your custom settings, then restart again\nThe plugin will now be disabled.\n");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.random = new Random();
        try {
            this.backpackPlusAPI = new BackpackPlusAPI(this);
            new BasicGuiItems((Plugin)this);
            new BackpacksItems();
            new Initialize(this);
            this.getLogger().info("Plugin initialized successfully.");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize plugin", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private boolean checkConfig() {
        int missingFields = 0;
        FileConfiguration config = this.getConfig();
        if (!config.isConfigurationSection("Gui.filling")) {
            ++missingFields;
        }
        if (!config.isConfigurationSection("Gui.overfill")) {
            ++missingFields;
        }
        if (!config.isConfigurationSection("Gui.page-next")) {
            ++missingFields;
        }
        if (!config.isConfigurationSection("Gui.page-previous")) {
            ++missingFields;
        }
        if (!config.isSet("play-song-when-item-moved-in-backpack")) {
            ++missingFields;
        }
        if (!config.isSet("limit-backpack-per-inventory-amount")) {
            ++missingFields;
        }
        if (!config.isSet("allow-bundles-in-backpacks")) {
            ++missingFields;
        }
        if (!config.isSet("keep-backpacks-after-death")) {
            ++missingFields;
        }
        if (!config.isConfigurationSection("Database.hikari-settings")) {
            ++missingFields;
        }
        if (!config.isConfigurationSection("Database.mysql-settings")) {
            ++missingFields;
        }
        if (!config.isConfigurationSection("Database.mysql-settings.performance")) {
            ++missingFields;
        }
        return missingFields <= 3;
    }

    public void onDisable() {
        this.isServerShutdown = true;
        Utils.debugLogToConsole("Starting plugin shutdown process...");
        if (BackpackManager.getInstance() != null) {
            Utils.debugLogToConsole("Saving all backpacks to the database...");
            BackpackManager.getInstance().closeAllBackpacks();
            Utils.debugLogToConsole("All backpack saved.");
        }
        Cache.shutdown();
        Utils.debugLogToConsole("Stopped background cache cleanup.");
        if (this.clearCacheTask != null) {
            this.clearCacheTask.cancel();
            Utils.debugLogToConsole("Cleared cache task canceled.");
        }
        if (DatabaseManager.getInstance() != null) {
            DatabaseManager.getInstance().disconnect();
            Utils.debugLogToConsole("Database connection closed.");
        }
        Utils.debugLogToConsole("Stopping all plugin skipped tasks...");
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        Utils.debugLogToConsole("All plugin task canceled.");
        Utils.debugLogToConsole("Plugin shutdown completed.");
    }

    @Generated
    public static BackpackPlus getInstance() {
        return instance;
    }

    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Generated
    public boolean isServerShutdown() {
        return this.isServerShutdown;
    }
}

