/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.OfflinePlayersData;
import pl.ziomalu.backpackplus.utils.Text;

public class DatabaseBackpack {
    private final UUID backpackUniqueId;
    private final UUID backpackOwnerUniqueId;
    private Timestamp lastUpdated;
    private final String ownerName;
    private final int backpackTier;
    private final String lastPlayer;
    private final ItemStack viewItemStack;
    private final ItemStack backpackStack;
    private final boolean hasSettings;
    private final BackpackSettings settings;

    public DatabaseBackpack(UUID backpackUniqueId, UUID backpackOwnerId, int backpackTier, UUID lastPlayerUniqueId) {
        this(backpackUniqueId, backpackOwnerId, backpackTier, null, lastPlayerUniqueId == null ? backpackOwnerId : lastPlayerUniqueId);
    }

    public DatabaseBackpack(UUID backpackUniqueId, UUID backpackOwnerId, int backpackTier, Timestamp lastUpdated, UUID lastPlayerUniqueId) {
        this.backpackUniqueId = backpackUniqueId;
        this.backpackOwnerUniqueId = backpackOwnerId;
        this.backpackTier = backpackTier;
        this.lastUpdated = lastUpdated;
        this.ownerName = OfflinePlayersData.getInstance().getPlayerName(this.backpackOwnerUniqueId);
        this.lastPlayer = lastPlayerUniqueId != null ? OfflinePlayersData.getInstance().getPlayerName(lastPlayerUniqueId) : "?";
        this.settings = BackpackManager.getInstance().getBackpackSettingsByTier(this.backpackTier);
        if (this.settings == null) {
            BackpackPlus.getInstance().getLogger().warning("Backpack settings for tier: " + backpackTier + " not found!");
            this.viewItemStack = this.createNoSettingsStack();
            this.backpackStack = null;
            this.hasSettings = false;
            return;
        }
        this.viewItemStack = this.createViewBackpackStack();
        this.backpackStack = this.createBackpackStack();
        this.hasSettings = true;
    }

    private List<String> generateLore() {
        List<String> langLoreList = LanguageManager.getInstance().getStringList("items.database-backpack-info.lore");
        ArrayList<String> lore = new ArrayList<String>();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("owner", this.ownerName == null ? this.backpackOwnerUniqueId.toString() : this.ownerName);
        variables.put("backpackUUID", this.backpackUniqueId.toString());
        variables.put("lastUpdate", BackpackPlus.DATE_FORMAT.format(this.lastUpdated));
        variables.put("lastPlayer", this.lastPlayer);
        for (String str : langLoreList) {
            lore.add(Text.setColour(StringParser.parseString(str, variables)));
        }
        return lore;
    }

    private ItemStack createViewBackpackStack() {
        ItemStack originalBackpackStack = this.settings.getBackpackStack().clone();
        ItemMeta meta = originalBackpackStack.getItemMeta();
        if (meta == null) {
            return originalBackpackStack;
        }
        meta.setLore(this.generateLore());
        originalBackpackStack.setItemMeta(meta);
        return originalBackpackStack;
    }

    public void updateLore() {
        ItemMeta meta = this.viewItemStack.getItemMeta();
        if (meta != null) {
            meta.setLore(this.generateLore());
            this.viewItemStack.setItemMeta(meta);
        }
    }

    private ItemStack createBackpackStack() {
        ItemStack backpack = this.settings.getBackpackStack().clone();
        ItemMeta bMeta = backpack.getItemMeta();
        if (bMeta == null) {
            return null;
        }
        PersistentDataContainer container = bMeta.getPersistentDataContainer();
        container.set(BackpackManager.getBackpackUniqueIdKey(), PersistentDataType.STRING, (Object)this.backpackUniqueId.toString());
        container.set(BackpackManager.getBackpackUsed(), PersistentDataType.INTEGER, (Object)1);
        container.set(BackpackManager.getDatabase(), PersistentDataType.STRING, (Object)DatabaseManager.getInstance().getType().name());
        backpack.setItemMeta(bMeta);
        return backpack;
    }

    private ItemStack createNoSettingsStack() {
        ItemStack stack = new ItemStack(Material.BARRIER);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return null;
        }
        List<String> langLore = LanguageManager.getInstance().getStringList("items.database-backpack-no-settings.lore");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("owner", this.ownerName == null ? this.backpackOwnerUniqueId.toString() : this.ownerName);
        variables.put("backpackUUID", this.backpackUniqueId.toString());
        variables.put("lastUpdate", BackpackPlus.DATE_FORMAT.format(this.lastUpdated));
        variables.put("lastPlayer", this.lastPlayer);
        variables.put("tier", this.backpackTier);
        String displayName = LanguageManager.getInstance().getString("items.database-backpack-no-settings.display-name");
        meta.setDisplayName(Text.setColour(displayName));
        ArrayList<String> lore = new ArrayList<String>();
        for (String str : langLore) {
            lore.add(Text.setColour(StringParser.parseString(str, variables)));
        }
        meta.setLore(lore);
        stack.setItemMeta(meta);
        return stack;
    }

    @Generated
    public UUID getBackpackUniqueId() {
        return this.backpackUniqueId;
    }

    @Generated
    public UUID getBackpackOwnerUniqueId() {
        return this.backpackOwnerUniqueId;
    }

    @Generated
    public void setLastUpdated(Timestamp lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Generated
    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    @Generated
    public String getOwnerName() {
        return this.ownerName;
    }

    @Generated
    public int getBackpackTier() {
        return this.backpackTier;
    }

    @Generated
    public String getLastPlayer() {
        return this.lastPlayer;
    }

    @Generated
    public ItemStack getViewItemStack() {
        return this.viewItemStack;
    }

    @Generated
    public ItemStack getBackpackStack() {
        return this.backpackStack;
    }

    @Generated
    public boolean isHasSettings() {
        return this.hasSettings;
    }
}

