/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParser {
    private static final Pattern CONDITIONAL_PATTERN = Pattern.compile("%\\[\\(([^)]+)\\)([^%]+)\\]%");
    private static final Pattern TERNARY_PATTERN = Pattern.compile("%\\[\\(([^)]+)\\)(.*?)\\s*~:\\s*(.*?)\\]%");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^-?\\d+(\\.\\d+)?$");
    private static final String[] OPERATORS = new String[]{">=", "<=", "==", "!=", ">", "<"};
    private static final int MAX_ITERATIONS = 100;

    public static String parseString(String template, Map<String, Object> variables) {
        if (template == null || variables == null) {
            return template != null ? template : "";
        }
        String result = template;
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            String placeholder = "%" + entry.getKey() + "%";
            result = result.replace(placeholder, entry.getValue().toString());
        }
        result = StringParser.processConditionals(result, variables);
        return result;
    }

    private static String processConditionals(String text, Map<String, Object> variables) {
        if (text == null || variables == null) {
            return text != null ? text : "";
        }
        text = StringParser.processTernaryConditionals(text, variables);
        text = StringParser.processStandardConditionals(text, variables);
        return text;
    }

    private static String processTernaryConditionals(String text, Map<String, Object> variables) {
        Matcher matcher;
        for (int iterations = 0; iterations < 100 && (matcher = TERNARY_PATTERN.matcher(text)).find(); ++iterations) {
            String condition = matcher.group(1);
            String trueText = matcher.group(2);
            String falseText = matcher.group(3);
            boolean conditionResult = StringParser.evaluateCondition(condition, variables);
            String selectedText = conditionResult ? trueText : falseText;
            String processedText = StringParser.replaceVariables(selectedText, variables);
            text = text.replace(matcher.group(0), processedText);
        }
        return text;
    }

    private static String replaceVariables(String text, Map<String, Object> variables) {
        String result = text;
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            String placeholder = "%" + entry.getKey() + "%";
            result = result.replace(placeholder, entry.getValue().toString());
        }
        return result;
    }

    private static String processStandardConditionals(String text, Map<String, Object> variables) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = CONDITIONAL_PATTERN.matcher(text);
        for (int iterations = 0; matcher.find() && iterations < 100; ++iterations) {
            String condition = matcher.group(1);
            String conditionalText = matcher.group(2);
            boolean conditionResult = StringParser.evaluateCondition(condition, variables);
            String replacement = conditionResult ? conditionalText : "";
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static boolean evaluateCondition(String condition, Map<String, Object> variables) {
        if (condition == null || condition.trim().isEmpty() || variables == null) {
            return false;
        }
        for (String operator : OPERATORS) {
            Object rightValue;
            String[] parts;
            if (!condition.contains(operator) || (parts = condition.split(Pattern.quote(operator), 2)).length != 2) continue;
            String leftSide = parts[0].trim();
            String rightSide = parts[1].trim();
            Object leftValue = variables.get(leftSide);
            if (leftValue == null || (rightValue = StringParser.parseValue(rightSide, variables)) == null && !rightSide.equalsIgnoreCase("null")) continue;
            return StringParser.compareValues(leftValue, rightValue, operator);
        }
        return false;
    }

    private static Object parseValue(String value, Map<String, Object> variables) {
        Boolean specialValue;
        String lowerValue;
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (variables.containsKey(trimmedValue)) {
            return variables.get(trimmedValue);
        }
        switch (lowerValue = trimmedValue.toLowerCase()) {
            case "true": {
                Boolean bl = true;
                break;
            }
            case "false": {
                Boolean bl = false;
                break;
            }
            case "null": {
                Boolean bl = null;
                break;
            }
            default: {
                Boolean bl = specialValue = null;
            }
        }
        if (specialValue != null || lowerValue.equals("null")) {
            return specialValue;
        }
        if (NUMBER_PATTERN.matcher(trimmedValue).matches()) {
            try {
                if (trimmedValue.contains(".")) {
                    return Double.parseDouble(trimmedValue);
                }
                long longValue = Long.parseLong(trimmedValue);
                if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return trimmedValue;
    }

    private static boolean compareValues(Object left, Object right, String operator) {
        if (left == null || right == null) {
            return switch (operator) {
                case "==" -> {
                    if (left == right) {
                        yield true;
                    }
                    yield false;
                }
                case "!=" -> {
                    if (left != right) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        if (left instanceof Number && right instanceof Number) {
            double leftNum = ((Number)left).doubleValue();
            double rightNum = ((Number)right).doubleValue();
            return switch (operator) {
                case ">" -> {
                    if (leftNum > rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (leftNum < rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (leftNum >= rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (leftNum <= rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case "==" -> {
                    if (Double.compare(leftNum, rightNum) == 0) {
                        yield true;
                    }
                    yield false;
                }
                case "!=" -> {
                    if (Double.compare(leftNum, rightNum) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        if (left instanceof String) {
            String leftStr = (String)left;
            if (right instanceof String) {
                String rightStr = (String)right;
                return switch (operator) {
                    case "==" -> leftStr.equals(rightStr);
                    case "!=" -> {
                        if (!leftStr.equals(rightStr)) {
                            yield true;
                        }
                        yield false;
                    }
                    case ">" -> {
                        if (leftStr.compareTo(rightStr) > 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<" -> {
                        if (leftStr.compareTo(rightStr) < 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case ">=" -> {
                        if (leftStr.compareTo(rightStr) >= 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<=" -> {
                        if (leftStr.compareTo(rightStr) <= 0) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
        }
        if (left instanceof Boolean) {
            Boolean leftBool = (Boolean)left;
            if (right instanceof Boolean) {
                Boolean rightBool = (Boolean)right;
                return switch (operator) {
                    case "==" -> leftBool.equals(rightBool);
                    case "!=" -> {
                        if (!leftBool.equals(rightBool)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
        }
        if (!left.getClass().equals(right.getClass())) {
            return switch (operator) {
                case "==" -> left.toString().equals(right.toString());
                case "!=" -> {
                    if (!left.toString().equals(right.toString())) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }
}

