/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.backpackcontent;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lombok.Generated;
import me.ziomalu.api.backpackplus.BackpackItem;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.backpackcontent.BackpackGUI;
import pl.ziomalu.backpackplus.backpackcontent.json.BackpackJson;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.enums.BackpackState;
import pl.ziomalu.backpackplus.enums.BackpackType;
import pl.ziomalu.backpackplus.events.BackpackStateChangeEvent;
import pl.ziomalu.backpackplus.interfaces.Callback;
import pl.ziomalu.backpackplus.items.Item;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.Utils;

public class Backpack {
    private final UUID backpackUniqueId;
    private final UUID backpackOwnerUniqueId;
    private BackpackJson backpackJson;
    private String content = "{}";
    private BackpackGUI backpackGUI;
    private BackpackState backpackState = BackpackState.LOADING;
    private final List<UUID> inspectors = new ArrayList<UUID>();
    private final int tier;
    private Date lastUpdated;
    private boolean locked = false;
    private UUID lastPlayerUniqueId;
    private long lastUsed;
    private final BackpackType backpackType;
    private final BackpackSettings backpackSettings;

    public Backpack(UUID backpackUniqueId, UUID backpackOwnerUniqueId, int tier, Callback callback) {
        this.backpackUniqueId = backpackUniqueId;
        this.backpackOwnerUniqueId = backpackOwnerUniqueId;
        this.tier = tier;
        this.lastUpdated = new Date();
        this.lastPlayerUniqueId = backpackOwnerUniqueId;
        this.backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(tier);
        this.backpackType = this.backpackSettings.getData().getBackpackType();
        this.backpackGUI = new BackpackGUI(this.backpackSettings.getData().getSize(), backpackUniqueId, this.backpackSettings.getData().getGuiTitle(), this, backpackGuiCallback -> {
            if (backpackGuiCallback instanceof BackpackGUI) {
                BackpackGUI gui = (BackpackGUI)backpackGuiCallback;
                this.content = gui.convertPagesToJson(tier, this.backpackSettings.getData().getSize());
                this.backpackJson = this.convertContent();
                callback.execute(this);
                Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> {
                    ItemStack backpackStack = BackpackManager.getInstance().getPlayerUsedBackpackStack(backpackOwnerUniqueId);
                    if (backpackStack != null) {
                        this.setLore(backpackStack, this);
                    }
                    this.setBackpackState(BackpackState.NORMAL);
                });
            } else {
                Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> this.setBackpackState(BackpackState.ERROR));
            }
            Utils.debugLogToConsole("[Backpack] created new backpack with UUID: " + String.valueOf(backpackUniqueId) + " Tier: " + tier);
        });
        this.updateUse();
    }

    public Backpack(UUID backpackUniqueId, UUID backpackOwnerUniqueId, int tier, String content, Date lastUpdated) {
        this.backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(tier);
        this.backpackUniqueId = backpackUniqueId;
        this.backpackOwnerUniqueId = backpackOwnerUniqueId;
        this.content = content;
        this.tier = tier;
        this.lastUpdated = lastUpdated;
        this.lastPlayerUniqueId = backpackOwnerUniqueId;
        this.backpackType = this.backpackSettings.getData().getBackpackType();
        this.initializeGui();
    }

    private void initializeGui() {
        BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(this.tier);
        if (backpackSettings == null) {
            this.setBackpackState(BackpackState.ERROR);
            return;
        }
        this.backpackGUI = new BackpackGUI(backpackSettings.getData().getSize(), this.backpackUniqueId, backpackSettings.getData().getGuiTitle(), this, guiCallback -> {
            if (guiCallback instanceof BackpackGUI) {
                BackpackGUI gui = (BackpackGUI)guiCallback;
                gui.loadFromJson(this.convertContent(), jsonCallback -> {
                    if (jsonCallback instanceof String) {
                        String json;
                        this.content = json = (String)jsonCallback;
                        this.backpackJson = this.convertContent();
                    } else {
                        this.content = gui.convertPagesToJson(this.tier, backpackSettings.getData().getSize());
                        this.backpackJson = this.convertContent();
                    }
                });
                Utils.debugLogToConsole("[Backpack] created new backpack from database content UUID: " + String.valueOf(this.backpackUniqueId) + " Tier: " + this.tier);
                Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> this.setBackpackState(BackpackState.NORMAL));
            }
        });
    }

    public void addInspector(UUID playerUniqueId) {
        this.inspectors.add(playerUniqueId);
    }

    public void removeInspector(UUID playerUniqueId) {
        this.inspectors.remove(playerUniqueId);
    }

    public boolean hasInspector(UUID playerUniqueId) {
        return this.inspectors.contains(playerUniqueId);
    }

    public boolean hasInspectors() {
        return !this.inspectors.isEmpty();
    }

    public void updateUse() {
        this.lastUsed = System.currentTimeMillis();
    }

    public void openFirstPage(Player player) {
        Page page = this.getBackpackGUI().getFirstPage();
        if (page == null) {
            return;
        }
        this.playBackpackOpenSound(player);
        player.openInventory(page.getInventory());
        this.updateUse();
    }

    private void playBackpackOpenSound(Player player, float volume, float pitch) {
        Random random = BackpackPlus.getInstance().getRandom();
        Sound sound = random.nextBoolean() ? Sound.ITEM_ARMOR_EQUIP_LEATHER : Sound.ITEM_ARMOR_EQUIP_ELYTRA;
        player.playSound((Entity)player, sound, volume, pitch);
    }

    private void playBackpackOpenSound(Player player) {
        Random random = BackpackPlus.getInstance().getRandom();
        Sound sound = random.nextBoolean() ? Sound.ITEM_ARMOR_EQUIP_LEATHER : Sound.ITEM_ARMOR_EQUIP_ELYTRA;
        player.playSound((Entity)player, sound, 1.0f, 0.0f);
    }

    private BackpackJson convertContent() {
        Gson gson = new Gson();
        Type type = new TypeToken<BackpackJson>(){}.getType();
        return (BackpackJson)gson.fromJson(this.content, type);
    }

    public void closeBackpackInventory(boolean closeAll) {
        for (Page page : this.backpackGUI.getPages()) {
            if (page.getInventory() == null || page.getInventory().getViewers().isEmpty()) continue;
            for (HumanEntity viewer : new ArrayList(page.getInventory().getViewers())) {
                if (this.inspectors.contains(viewer.getUniqueId()) && !closeAll) continue;
                viewer.closeInventory();
            }
        }
    }

    public void closeAndSaveBackpack(boolean closeViewers) {
        try {
            String json = this.backpackGUI.convertPagesToJson(this.tier, BackpackManager.getInstance().getBackpackSpace(this.tier));
            if (!this.content.equals(json)) {
                this.setBackpackState(BackpackState.UPDATING);
                DatabaseManager.getInstance().getDatabase().updateBackpackContentAsync(this, json, status -> {
                    if (status.booleanValue()) {
                        this.setContent(json);
                        Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> this.setBackpackState(BackpackState.NORMAL));
                    } else {
                        Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> this.setBackpackState(BackpackState.ERROR));
                    }
                });
            }
            if (!closeViewers) {
                return;
            }
            for (Page page : this.backpackGUI.getPages()) {
                if (page.getInventory() == null || page.getInventory().getViewers().isEmpty()) continue;
                for (HumanEntity viewer : new ArrayList(page.getInventory().getViewers())) {
                    if (this.inspectors.contains(viewer.getUniqueId())) continue;
                    viewer.closeInventory();
                }
            }
        }
        catch (Exception e) {
            BackpackPlus.getInstance().getLogger().severe("Error when closing and saving the backpack [UUID: " + String.valueOf(this.backpackUniqueId) + "]: " + e.getMessage());
        }
    }

    public final void setBackpackState(BackpackState state) {
        BackpackStateChangeEvent event = new BackpackStateChangeEvent(this, state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.backpackState = event.getState();
        }
    }

    public void setLore(ItemStack backpackStack, Backpack backpack) {
        UUID inHandBackpackUniqueId;
        if (backpack == null) {
            return;
        }
        if (backpackStack == null) {
            return;
        }
        ItemMeta meta = backpackStack.getItemMeta();
        if (meta == null) {
            return;
        }
        List<String> lore = backpack.getBackpackGUI().calculateContentLore();
        if (BackpackManager.getInstance().isBackpackStack(backpackStack) && !(inHandBackpackUniqueId = BackpackManager.getInstance().getBackpackUniqueId(backpackStack)).equals(backpack.getBackpackUniqueId())) {
            return;
        }
        meta.setLore(lore);
        backpackStack.setItemMeta(meta);
    }

    public List<BackpackItem> getItems() {
        ArrayList<BackpackItem> items = new ArrayList<BackpackItem>();
        if (this.backpackGUI == null || this.backpackGUI.getPages() == null) {
            return items;
        }
        for (Page page : this.backpackGUI.getPages()) {
            if (page == null || page.getInventory() == null) continue;
            for (ItemStack itemStack : page.getInventory().getContents()) {
                if (!this.isValidItem(itemStack)) continue;
                items.add(new BackpackItem(itemStack));
            }
        }
        return items;
    }

    public List<BackpackItem> getItems(boolean mergeSimilar) {
        if (!mergeSimilar) {
            return this.getItems();
        }
        HashMap<String, BackpackItem> mergedItems = new HashMap<String, BackpackItem>();
        for (BackpackItem backpackItem : this.getItems()) {
            ItemStack itemStack = backpackItem.getItemStack();
            String itemKey = this.generateItemKey(itemStack);
            BackpackItem existing = (BackpackItem)mergedItems.get(itemKey);
            if (existing != null) {
                existing.increaseAmount(backpackItem.getAmount());
                continue;
            }
            mergedItems.put(itemKey, backpackItem);
        }
        return new ArrayList<BackpackItem>(mergedItems.values());
    }

    private String generateItemKey(ItemStack itemStack) {
        if (Item.isCustomItem(itemStack)) {
            return "CUSTOM_" + String.valueOf(itemStack.getType()) + "_" + itemStack.getItemMeta().getDisplayName();
        }
        return "NORMAL_" + String.valueOf(itemStack.getType());
    }

    public void setLastPlayerUniqueId(UUID lastPlayerUniqueId) {
        this.lastPlayerUniqueId = lastPlayerUniqueId;
        this.setBackpackState(BackpackState.UPDATING);
        DatabaseManager.getInstance().getDatabase().updateBackpackLastPlayerUsedAsync(this.backpackUniqueId, this.lastPlayerUniqueId, status -> {
            if (status.booleanValue()) {
                Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> this.setBackpackState(BackpackState.NORMAL));
            } else {
                Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> this.setBackpackState(BackpackState.ERROR));
            }
        });
    }

    private boolean isValidItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        BasicGuiItems guiItems = BasicGuiItems.getInstance();
        return !guiItems.isGuiItem(itemStack) && !guiItems.isPageButtonItem(itemStack);
    }

    @Generated
    public UUID getBackpackUniqueId() {
        return this.backpackUniqueId;
    }

    @Generated
    public UUID getBackpackOwnerUniqueId() {
        return this.backpackOwnerUniqueId;
    }

    @Generated
    public BackpackJson getBackpackJson() {
        return this.backpackJson;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public BackpackGUI getBackpackGUI() {
        return this.backpackGUI;
    }

    @Generated
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public BackpackState getBackpackState() {
        return this.backpackState;
    }

    @Generated
    public List<UUID> getInspectors() {
        return this.inspectors;
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    @Generated
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Generated
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public UUID getLastPlayerUniqueId() {
        return this.lastPlayerUniqueId;
    }

    @Generated
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Generated
    public BackpackType getBackpackType() {
        return this.backpackType;
    }

    @Generated
    public BackpackSettings getBackpackSettings() {
        return this.backpackSettings;
    }
}

