/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.backpackcontent;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import me.ziomalu.api.ItemUtil;
import me.ziomalu.api.gui.GUI;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.backpackcontent.json.BackpackJson;
import pl.ziomalu.backpackplus.backpackcontent.json.BackpackJsonContent;
import pl.ziomalu.backpackplus.backpackcontent.json.BackpackJsonPage;
import pl.ziomalu.backpackplus.interfaces.Callback;
import pl.ziomalu.backpackplus.inventoryholders.BackpackInventoryHolder;
import pl.ziomalu.backpackplus.items.CustomItems;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class BackpackGUI
extends GUI {
    private final int capacity;
    private final String guiTitle;
    private final UUID backpackUniqueId;
    private final Logger logger = BackpackPlus.getInstance().getLogger();
    private final Backpack parent;

    public BackpackGUI(int capacity, UUID backpackUniqueId, String guiTitle, Backpack parent, Callback callback) {
        this.capacity = capacity;
        this.backpackUniqueId = backpackUniqueId;
        this.guiTitle = guiTitle;
        this.parent = parent;
        this.setMaxCapacity(capacity);
        CompletableFuture.runAsync(() -> {
            this.createEmptyPages();
            this.fillInTheExcess(CustomItems.getOverfillStack());
            this.addButtonsIfNeed(CustomItems.getFillingStack(), CustomItems.getPagePreviousStack(), CustomItems.getPageNextStack(), Sound.ITEM_ARMOR_EQUIP_LEATHER, Sound.ITEM_ARMOR_EQUIP_ELYTRA);
        }).thenRunAsync(() -> {
            callback.execute(this);
            Utils.debugLogToConsole("[BackpackGUI] Loaded");
        });
    }

    private void createEmptyPages() {
        this.createPages(this.capacity, this.guiTitle, (pageIndex, requirePageSize, pageTitle) -> {
            Page page = new Page(new BackpackInventoryHolder(pageIndex, this.backpackUniqueId, this, this.parent), pageIndex, requirePageSize, Text.setColour(pageTitle));
            this.setPage(page);
        });
    }

    public void loadFromJson(BackpackJson backpackJson, Callback callback) {
        if (backpackJson == null) {
            callback.execute(null);
            return;
        }
        if (this.pages.isEmpty()) {
            callback.execute(null);
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            for (BackpackJsonPage jPage : backpackJson.getPages()) {
                for (BackpackJsonContent jContent : jPage.getContents()) {
                    try {
                        Page page;
                        ItemStack decodedStack = ItemUtil.itemFromBase64(jContent.getContent());
                        if (decodedStack == null || (page = this.getPage(jPage.getIndex())) == null) continue;
                        page.getInventory().setItem(jContent.getSlot(), decodedStack);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        this.logger.log(Level.WARNING, String.format("Failed to decode the item in the backpack on the page: %s slot: %s", jPage.getIndex(), jContent.getSlot()), e);
                    }
                }
            }
            return this.convertPagesToJson(backpackJson.getTier(), backpackJson.getSize());
        }).thenAcceptAsync(result -> {
            callback.execute(result);
            Utils.debugLogToConsole("[BackpackGUI] [loadFromJson] Loading Finished");
        });
    }

    public String convertPagesToJson(int tier, int size) {
        Gson gson = new Gson();
        ArrayList<BackpackJsonPage> jPages = new ArrayList<BackpackJsonPage>();
        for (Page page : this.pages.values()) {
            ArrayList<BackpackJsonContent> slotsContents = new ArrayList<BackpackJsonContent>();
            for (int slot = 0; slot < page.getSize(); ++slot) {
                ItemStack slotStack = page.getItem(slot);
                try {
                    if (slotStack == null) continue;
                    String encodedStackData = ItemUtil.itemToBase64(slotStack);
                    slotsContents.add(new BackpackJsonContent(slot, encodedStackData));
                    continue;
                }
                catch (IllegalStateException ex) {
                    this.logger.log(Level.WARNING, String.format("Failed to convert item to base64: Item: %s", slotStack));
                }
            }
            jPages.add(new BackpackJsonPage(page.getIndex(), page.getSize(), slotsContents));
        }
        BackpackJson bJson = new BackpackJson(tier, size, jPages);
        if (!this.isPagesEmpty() && !bJson.getPages().isEmpty() && bJson.getPages().get(0).getContents().isEmpty()) {
            Utils.debugLogToConsole(Level.WARNING, String.format("It is possible that the player's backpack has been cleared backpackUniqueId: %s, \nOld content: %s", this.backpackUniqueId, this.parent.getContent()));
        }
        return gson.toJson((Object)bJson);
    }

    public List<String> calculateContentLore() {
        List lore = Optional.ofNullable(this.parent.getBackpackSettings().getData().getDescription()).map(ArrayList::new).orElseGet(ArrayList::new);
        if (!this.parent.getBackpackSettings().getData().isShowContent()) {
            if (lore.size() > 256) {
                return lore.subList(0, 256);
            }
            return lore;
        }
        HashMap<Material, Integer> defaultItems = new HashMap<Material, Integer>();
        HashMap<String, Integer> customItems = new HashMap<String, Integer>();
        for (Page page : this.pages.values()) {
            ItemStack[] invContents;
            Inventory inventory = page.getInventory();
            for (ItemStack stack : invContents = inventory.getContents()) {
                BasicGuiItems guiItems;
                if (stack == null || (guiItems = BasicGuiItems.getInstance()).isGuiItem(stack) || guiItems.isPageButtonItem(stack)) continue;
                if (stack.hasItemMeta() && stack.getItemMeta().hasDisplayName()) {
                    customItems.merge(stack.getItemMeta().getDisplayName(), stack.getAmount(), Integer::sum);
                    continue;
                }
                defaultItems.merge(stack.getType(), stack.getAmount(), Integer::sum);
            }
        }
        Map<Material, Integer> defaultItemsAmountSorted = Utils.sortByDescending(defaultItems);
        customItems.forEach((displayName, amount) -> {
            if (lore.size() < 256) {
                lore.add(Text.setColour("#f9c100" + amount + "x #dadada") + displayName);
            }
        });
        defaultItemsAmountSorted.forEach((material, amount) -> {
            if (lore.size() < 256) {
                StringBuilder requireName = new StringBuilder();
                requireName.append("#f9c100").append(amount).append("x #dadada");
                String[] matSentences = material.name().split("_");
                String materialName = Arrays.stream(matSentences).map(Utils::firstLetterUpper).collect(Collectors.joining(" "));
                requireName.append(materialName);
                lore.add(Text.setColour(requireName.toString()));
            }
        });
        if (lore.size() > 256) {
            return lore.subList(0, 256);
        }
        return lore;
    }

    public boolean isPagesEmpty() {
        boolean empty = true;
        for (Page page : this.pages.values()) {
            if (page == null || page.getInventory() == null || page.getInventory().isEmpty()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    @Generated
    public Backpack getParent() {
        return this.parent;
    }
}

