/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.ziomalu.api.gui.Page;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.database.Database;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.database.mysql.MySQL;
import pl.ziomalu.backpackplus.enums.State;
import pl.ziomalu.backpackplus.gui.backpack.BackpacksChoseGUI;
import pl.ziomalu.backpackplus.gui.backpack.backpacksgui.AllBackpacksGUI;
import pl.ziomalu.backpackplus.hooks.ResourcePackManagerHook;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.resourcepack.ResourcepackProvider;
import pl.ziomalu.backpackplus.resourcepack.ResourcepackSettings;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.OfflinePlayersData;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class BackpackCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender);
            return false;
        }
        if (args.length == 1) {
            if ("crafting".equalsIgnoreCase(args[0])) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("backpackplus.admin.crafting")) {
                        this.sendNoPerms((CommandSender)player);
                        return true;
                    }
                    Page backpackChoseGUI = BackpacksChoseGUI.getInstance().getFirstPage();
                    if (backpackChoseGUI == null) {
                        Utils.sendMessage(player, LanguageManager.getInstance().getString("unexpected-error"));
                        return true;
                    }
                    player.openInventory(BackpacksChoseGUI.getInstance().getFirstPage().getInventory());
                    return true;
                }
                Utils.sendMessage(sender, LanguageManager.getInstance().getString("command-only-player"));
            } else if ("resourcepack".equalsIgnoreCase(args[0])) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("backpackplus.command.resourcepack")) {
                        this.sendNoPerms((CommandSender)player);
                        return true;
                    }
                    try {
                        ResourcepackProvider.getInstance().setPlayerResourcePack(player, callback -> Utils.sendMessage(player, LanguageManager.getInstance().getString("resourcepack-loaded")));
                        return true;
                    }
                    catch (Exception ex) {
                        BackpackPlus.getInstance().getLogger().log(Level.WARNING, ex.getMessage());
                        Utils.sendMessage(player, LanguageManager.getInstance().getString("resourcepack-failed-load"));
                    }
                } else {
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("command-only-player"));
                }
            } else if ("players".equalsIgnoreCase(args[0])) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("backpackplus.admin.view.backpacks")) {
                        this.sendNoPerms((CommandSender)player);
                        return true;
                    }
                    AllBackpacksGUI allBackpacksGUI = AllBackpacksGUI.getInstance() != null ? AllBackpacksGUI.getInstance() : new AllBackpacksGUI();
                    allBackpacksGUI.load();
                    if (!allBackpacksGUI.hasPlayers()) {
                        Utils.sendMessage(player, LanguageManager.getInstance().getString("players-not-created-backpacks"));
                        return true;
                    }
                    if (allBackpacksGUI.getCreationState() != State.LOADED) {
                        Utils.sendMessage(player, LanguageManager.getInstance().getString("loading-in-progress"));
                        this.openAllPlayersGuiIfLoaded(player, allBackpacksGUI);
                    } else {
                        allBackpacksGUI.openGUI(player, 0);
                    }
                    return true;
                }
                Utils.sendMessage(sender, LanguageManager.getInstance().getString("command-only-player"));
            } else {
                this.sendUsage(sender);
            }
        } else if (args.length == 2) {
            if ("give".equalsIgnoreCase(args[0])) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("backpackplus.admin.give.backpacks")) {
                        this.sendNoPerms((CommandSender)player);
                        return true;
                    }
                    try {
                        int tier = Integer.parseInt(args[1]);
                        BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(tier);
                        if (backpackSettings == null) {
                            Utils.sendMessage(sender, LanguageManager.getInstance().getString("backpack-tier-not-found").replace("%tier%", String.valueOf(tier)));
                            return false;
                        }
                        player.getInventory().addItem(new ItemStack[]{backpackSettings.getBackpackStack().clone()});
                        Utils.sendMessage(sender, LanguageManager.getInstance().getString("backpack-added").replace("%tier%", String.valueOf(tier)));
                        return true;
                    }
                    catch (NumberFormatException ex) {
                        Utils.sendMessage(sender, LanguageManager.getInstance().getString("invalid-backpack-tier").replace("%tier%", args[1]));
                        return false;
                    }
                }
                Utils.sendMessage(sender, LanguageManager.getInstance().getString("command-only-player"));
            } else if ("block".equalsIgnoreCase(args[0]) && "hand".equalsIgnoreCase(args[1])) {
                if (sender instanceof Player) {
                    ItemStack playerUsedStack;
                    Player player = (Player)sender;
                    if (!player.hasPermission("backpackplus.admin.block")) {
                        this.sendNoPerms((CommandSender)player);
                        return true;
                    }
                    ItemStack mainHandStack = player.getInventory().getItemInMainHand();
                    ItemStack offHandStack = player.getInventory().getItemInOffHand();
                    Object object = !mainHandStack.getType().isAir() ? mainHandStack : (playerUsedStack = !offHandStack.getType().isAir() ? offHandStack : null);
                    if (playerUsedStack == null) {
                        Utils.sendMessage(player, LanguageManager.getInstance().getString("empty-hand"));
                        return true;
                    }
                    if (playerUsedStack.getType() == Material.FIREWORK_ROCKET) {
                        if (BackpackManager.getInstance().isBlocked(playerUsedStack.getType())) {
                            Utils.sendMessage(sender, LanguageManager.getInstance().getString("material-already-blocked").replace("%material%", playerUsedStack.getType().name().toLowerCase()));
                            return true;
                        }
                        Utils.sendMessage(sender, LanguageManager.getInstance().getString("material-has-blocked").replace("%material%", playerUsedStack.getType().name().toLowerCase()));
                        BackpackManager.getInstance().addBlockedMaterial(playerUsedStack.getType());
                        BackpackManager.getInstance().saveBlockedItems();
                        return true;
                    }
                    ItemStack stack = playerUsedStack.clone();
                    stack.setAmount(1);
                    if (BackpackManager.getInstance().isBlocked(stack)) {
                        Utils.sendMessage(sender, LanguageManager.getInstance().getString("item-already-blocked").replace("%item%", playerUsedStack.getType().name().toLowerCase()));
                        return true;
                    }
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("item-has-blocked").replace("%item%", playerUsedStack.getType().name().toLowerCase()));
                    BackpackManager.getInstance().addBlockedItem(stack);
                    BackpackManager.getInstance().saveBlockedItems();
                    return true;
                }
                Utils.sendMessage(sender, LanguageManager.getInstance().getString("command-only-player"));
            } else if ("backpacks".equalsIgnoreCase(args[0])) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("backpackplus.admin.view.backpacks")) {
                        this.sendNoPerms((CommandSender)player);
                        return true;
                    }
                    if (Utils.isValidUUID(args[1])) {
                        try {
                            UUID playerUniqueId = UUID.fromString(args[1]);
                            BackpackManager.getInstance().openPlayerBackpackByUniqueId(player, playerUniqueId);
                        }
                        catch (IllegalArgumentException ex) {
                            Utils.sendMessage(player, LanguageManager.getInstance().getString("invalid-uuid"));
                        }
                    } else {
                        UUID offlinePlayerUniqueId = OfflinePlayersData.getInstance().getPlayerUniqueId(args[1]);
                        if (offlinePlayerUniqueId == null) {
                            BackpackManager.getInstance().openPlayerBackpackByName(player, args[1]);
                        } else {
                            BackpackManager.getInstance().openPlayerBackpackByUniqueId(player, offlinePlayerUniqueId);
                        }
                    }
                } else {
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("command-only-player"));
                }
            } else if ("resourcepack".equalsIgnoreCase(args[0]) && "reload".equalsIgnoreCase(args[1])) {
                if (!sender.hasPermission("backpackplus.admin.resourcepack.reload")) {
                    this.sendNoPerms(sender);
                    return true;
                }
                BackpackPlus.getInstance().reloadConfig();
                ResourcepackSettings.getInstance().load();
                if (ResourcePackManagerHook.checkIfEnabled()) {
                    BackpackPlus.getInstance().getLogger().warning("ResourcePackManager is enabled you should use the command: /resourcepackmanager reload.");
                    return true;
                }
                try {
                    ResourcepackProvider.getInstance().applyResourcePackToAllPlayers();
                }
                catch (Exception player) {
                    // empty catch block
                }
                Utils.sendMessage(sender, LanguageManager.getInstance().getString("resourcepack-reloaded"));
            } else if ("settings".equalsIgnoreCase(args[0])) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.hasPermission("backpackplus.admin.settings")) {
                        this.sendNoPerms((CommandSender)player);
                        return true;
                    }
                    if (args[1].isEmpty()) {
                        return false;
                    }
                    try {
                        int backpackTier = Integer.parseInt(args[1]);
                        BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(backpackTier);
                        if (backpackSettings == null) {
                            Utils.sendMessage(sender, LanguageManager.getInstance().getString("backpack-tier-not-found").replace("%tier%", String.valueOf(backpackTier)));
                            return false;
                        }
                        backpackSettings.getBackpackSettingsMainGUI().openGUI(player);
                        return true;
                    }
                    catch (NumberFormatException ex) {
                        Utils.sendMessage(sender, LanguageManager.getInstance().getString("invalid-backpack-tier").replace("%tier%", args[1]));
                        return false;
                    }
                }
            } else {
                this.sendUsage(sender);
            }
        } else if (args.length == 3) {
            if ("give".equalsIgnoreCase(args[0])) {
                if (!sender.hasPermission("backpackplus.admin.give.backpacks")) {
                    this.sendNoPerms(sender);
                    return true;
                }
                Player argPlayer = Bukkit.getPlayer((String)args[2]);
                if (argPlayer == null) {
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("player-is-offline").replace("%player%", args[2]));
                    return true;
                }
                try {
                    int tier = Integer.parseInt(args[1]);
                    BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(tier);
                    if (backpackSettings == null) {
                        Utils.sendMessage(sender, LanguageManager.getInstance().getString("backpack-tier-not-found").replace("%tier%", String.valueOf(tier)));
                        return false;
                    }
                    argPlayer.getInventory().addItem(new ItemStack[]{backpackSettings.getBackpackStack().clone()});
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("backpack-added-player").replace("%tier%", String.valueOf(tier)).replace("%player%", args[2]));
                    return true;
                }
                catch (NumberFormatException ex) {
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("invalid-backpack-tier").replace("%tier%", args[1]));
                    return false;
                }
            }
            if ("block".equalsIgnoreCase(args[0]) && "name".equalsIgnoreCase(args[1])) {
                Material material = Material.getMaterial((String)args[2].toUpperCase());
                if (material == null) {
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("invalid-material").replace("%material%", args[2]));
                    return false;
                }
                if (BackpackManager.getInstance().isBlocked(material)) {
                    Utils.sendMessage(sender, LanguageManager.getInstance().getString("material-already-blocked").replace("%material%", material.name().toLowerCase()));
                    return true;
                }
                Utils.sendMessage(sender, LanguageManager.getInstance().getString("material-has-blocked").replace("%material%", material.name().toLowerCase()));
                BackpackManager.getInstance().addBlockedMaterial(material);
                BackpackManager.getInstance().saveBlockedItems();
                return true;
            }
            if ("mysql".equalsIgnoreCase(args[0]) && "pool".equalsIgnoreCase(args[1]) && "stats".equalsIgnoreCase(args[2]) && sender instanceof ConsoleCommandSender) {
                ConsoleCommandSender commandSender = (ConsoleCommandSender)sender;
                Database database = DatabaseManager.getInstance().getDatabase();
                if (database instanceof MySQL) {
                    MySQL mySQL = (MySQL)database;
                    mySQL.logPoolStats();
                } else {
                    commandSender.sendMessage(Text.setColour("&cThis option is only available for the MYSQL database"));
                }
            } else {
                this.sendUsage(sender);
            }
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            if (sender instanceof Player) {
                Material[] player2 = (Material[])sender;
                if (player2.hasPermission("backpackplus.admin.crafting")) {
                    list.add("crafting");
                }
                if (player2.hasPermission("backpackplus.command.resourcepack")) {
                    list.add("resourcepack");
                }
                if (player2.hasPermission("backpackplus.admin.view.backpacks")) {
                    list.add("players");
                    list.add("backpacks");
                }
                if (player2.hasPermission("backpackplus.admin.settings")) {
                    list.add("settings");
                }
            }
            if (sender instanceof ConsoleCommandSender) {
                list.add("mysql");
            }
            if (sender.hasPermission("backpackplus.admin.give.backpacks")) {
                list.add("give");
            }
            if (sender.hasPermission("backpackplus.admin.block")) {
                list.add("block");
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("backpacks") && sender.hasPermission("backpackplus.admin.view.backpacks")) {
                Bukkit.getOnlinePlayers().forEach(player -> list.add(player.getName()));
            }
            if (args[0].equalsIgnoreCase("give") && sender.hasPermission("backpackplus.admin.give.backpacks")) {
                BackpackManager.getInstance().getBackpacksTiers().forEach(tier -> list.add(String.valueOf(tier)));
            }
            if (args[0].equalsIgnoreCase("block") && sender.hasPermission("backpackplus.admin.block")) {
                list.add("name");
                list.add("hand");
            }
            if (args[0].equalsIgnoreCase("resourcepack") && sender.hasPermission("backpackplus.admin.resourcepack.reload")) {
                list.add("reload");
            }
            if (sender instanceof ConsoleCommandSender) {
                list.add("pool");
            }
            if (args[0].equalsIgnoreCase("settings") && sender.hasPermission("backpackplus.admin.settings")) {
                BackpackManager.getInstance().getBackpacksTiers().forEach(tier -> list.add(String.valueOf(tier)));
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("give") && sender.hasPermission("backpackplus.admin.give.backpacks")) {
                Bukkit.getOnlinePlayers().forEach(player -> list.add(player.getName()));
            } else if (args[0].equalsIgnoreCase("block") && args[1].equalsIgnoreCase("name") && sender.hasPermission("backpackplus.admin.block")) {
                for (Material material : Material.values()) {
                    list.add(material.name());
                }
            }
            if (sender instanceof ConsoleCommandSender) {
                list.add("stats");
            }
        }
        String curArg = args[args.length - 1].toLowerCase();
        ArrayList<String> completer = new ArrayList<String>();
        for (String s : list) {
            if (!s.toLowerCase().startsWith(curArg)) continue;
            completer.add(s);
        }
        return completer;
    }

    private void sendNoPerms(@NotNull CommandSender sender) {
        Utils.sendMessage(sender, LanguageManager.getInstance().getString("command-no-permissions"));
    }

    private void sendUsage(@NotNull CommandSender sender) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(Text.setColour("&1&m--------------------&e&lBackpack&7&lPlus&1&m--------------------"));
        if (sender.hasPermission("backpackplus.admin.crafting")) {
            messages.add(Text.setColour("&8/&fbackpack &bcrafting &8- &9Opens GUI with crafting backpacks."));
        }
        if (sender.hasPermission("backpackplus.admin.view.backpacks")) {
            messages.add(Text.setColour("&8/&fbackpack &bbackpacks &7<&fonline player &7| &fplayer uuid&7> &8- &9Displays all backpacks created by a given player."));
            messages.add(Text.setColour("&8/&fbackpack &bplayers &8- &9Displays all players who have created backpacks."));
        }
        if (sender.hasPermission("backpackplus.command.resourcepack")) {
            messages.add(Text.setColour("&8/&fbackpack &bresourcepack &8- &9Reloads resourcepack for client."));
        }
        if (sender.hasPermission("backpackplus.admin.resourcepack.reload")) {
            messages.add(Text.setColour("&8/&fbackpack &bresourcepack reload &8- &9Reloads resourcepack on the server."));
        }
        if (sender.hasPermission("backpackplus.admin.give.backpacks")) {
            messages.add(Text.setColour("&8/&fbackpack &bgive &7<&btier&7> &7[<&fplayer&7>] &8- &9Adds a backpack to you or the specified player"));
        }
        if (sender.hasPermission("backpackplus.admin.settings")) {
            messages.add(Text.setColour("&8/&fbackpack &bsettings &7<&btier&7> &8- &9Opens backpack settings"));
        }
        if (sender.hasPermission("backpackplus.admin.block")) {
            messages.add(Text.setColour("&8/&fbackpack &bblock &7<&fhand &7| &fname&7> &7[<&fmaterial name&7>] &8- &9Adds item to list of blocked items"));
        }
        messages.add(Text.setColour("&1&m--------------------&e&lBackpack&7&lPlus&1&m--------------------"));
        if (messages.size() <= 2) {
            this.sendNoPerms(sender);
            return;
        }
        messages.forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }

    private void openAllPlayersGuiIfLoaded(Player player, AllBackpacksGUI allBackpacksGUI) {
        Bukkit.getScheduler().runTaskLater((Plugin)BackpackPlus.getInstance(), task -> {
            if (allBackpacksGUI.getCreationState() == State.LOADED) {
                allBackpacksGUI.openGUI(player, 0);
                allBackpacksGUI.updateUse();
            } else if (allBackpacksGUI.getCreationState() != State.LOADING) {
                task.cancel();
            } else {
                this.openAllPlayersGuiIfLoaded(player, allBackpacksGUI);
            }
        }, 2L);
    }
}

