/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackPlus;

public class CraftingManager {
    public HashMap<NamespacedKey, List<ItemStack>> backpackCraftingRecipes;
    private final HashMap<UUID, Inventory> craftingEditors;
    private static CraftingManager instance;
    private final Plugin plugin;

    public CraftingManager(Plugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.craftingEditors = new HashMap();
        this.backpackCraftingRecipes = new HashMap();
    }

    public void addCraftingEditor(UUID playerUniqueId, Inventory inventory) {
        this.craftingEditors.put(playerUniqueId, inventory);
    }

    public void removeCraftingEditor(UUID playerUniqueId) {
        this.craftingEditors.remove(playerUniqueId);
    }

    public Inventory getEditorInventory(UUID playerUniqueId) {
        return this.craftingEditors.get(playerUniqueId);
    }

    public boolean isCraftingEditor(UUID playerUniqueId) {
        return this.craftingEditors.containsKey(playerUniqueId);
    }

    public void addRecipe(NamespacedKey craftingKey, ShapedRecipe recipe) {
        boolean added;
        if (BackpackPlus.getInstance().getServer().getRecipe(craftingKey) != null) {
            BackpackPlus.getInstance().getServer().removeRecipe(craftingKey);
        }
        if (!(added = this.plugin.getServer().addRecipe((Recipe)recipe))) {
            this.plugin.getLogger().warning(() -> "Recipe: " + craftingKey.getKey() + " Cannot be added!");
        }
        if (this.backpackCraftingRecipes.containsKey(craftingKey)) {
            this.backpackCraftingRecipes.replace(craftingKey, new ArrayList(recipe.getIngredientMap().values()));
        } else {
            this.backpackCraftingRecipes.put(craftingKey, new ArrayList(recipe.getIngredientMap().values()));
        }
    }

    @Generated
    public static CraftingManager getInstance() {
        return instance;
    }
}

