/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.DatabaseBackpack;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.database.BackpackInfo;
import pl.ziomalu.backpackplus.database.enums.DatabaseType;
import pl.ziomalu.backpackplus.gui.backpack.backpacksgui.PlayerBackpackGuiInfo;
import pl.ziomalu.backpackplus.utils.Utils;

public abstract class Database {
    private final DatabaseType type;
    protected final Plugin plugin = BackpackPlus.getInstance();

    public Database(DatabaseType type) {
        this.type = type;
    }

    public final DatabaseType getType() {
        return this.type;
    }

    public abstract void connect() throws SQLException;

    public abstract void disconnect();

    public abstract boolean isConnected();

    public abstract Connection getConnection() throws SQLException;

    public abstract int executeUpdate(String var1, Object ... var2) throws SQLException;

    public abstract boolean execute(String var1, Object ... var2) throws SQLException;

    public abstract boolean execute(String var1) throws SQLException;

    public abstract boolean objectExists(String var1) throws SQLException;

    protected void logError(String method, String query, SQLException ex) {
        this.plugin.getLogger().log(Level.SEVERE, String.format("Error in %s: query='%s', error='%s'%n", method, query, ex.getMessage()));
    }

    protected void setParameters(PreparedStatement statement, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
    }

    public abstract void createTables() throws SQLException;

    public abstract void loadBackpackFromDatabase(UUID var1, int var2, Consumer<Object> var3);

    public abstract void loadBackpackFromDatabaseAsync(UUID var1, int var2, @Nullable Consumer<Backpack> var3);

    public abstract void saveBackpackToDatabaseAsync(Backpack var1, Consumer<Boolean> var2);

    public final Backpack createBackpackFromResultSet(ResultSet resultSet, int backpackTier) throws SQLException {
        return new Backpack(UUID.fromString(resultSet.getString("backpackUUID")), UUID.fromString(resultSet.getString("backpackOwnerUUID")), backpackTier, resultSet.getString("content"), resultSet.getDate("last_updated"));
    }

    public abstract void updateBackpackContentAsync(@NotNull Backpack var1, String var2, Consumer<Boolean> var3);

    public final void updateBackpackLastPlayerUsedAsync(@NotNull UUID backpackUniqueId, @NotNull UUID lastPlayerUsedUniqueId, Consumer<Boolean> callback) {
        String query = "UPDATE backpacks SET last_player_uuid=? WHERE backpackUUID=?";
        CompletableFuture.supplyAsync(() -> {
            try {
                int rowsAffected = this.executeUpdate(query, lastPlayerUsedUniqueId.toString(), backpackUniqueId.toString());
                return rowsAffected > 0;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error updating backpack last player used", ex);
                return false;
            }
        }).thenAccept(result -> {
            Bukkit.getScheduler().runTask(this.plugin, () -> callback.accept((Boolean)result));
            Utils.debugLogToConsole("[Database] [updateBackpackLastPlayerUsed] Success: " + result);
        });
    }

    @Nullable
    public abstract Timestamp getBackpackLastUpdate(UUID var1);

    public abstract void updateBackpackOpenState(UUID var1, boolean var2);

    public abstract Optional<Boolean> getBackpackOpenState(UUID var1);

    public abstract Optional<BackpackInfo> getBackpackState(UUID var1);

    public abstract void addLastPlayerUUIDColumnIfNotExists();

    public abstract void addBackpackStateColumnIfNotExists();

    public abstract ConcurrentMap<UUID, PlayerBackpackGuiInfo> loadAllPlayersBackpacks(boolean var1);

    public abstract CompletableFuture<ConcurrentMap<UUID, PlayerBackpackGuiInfo>> loadAllPlayersBackpacksAsync(boolean var1);

    public abstract List<DatabaseBackpack> loadPlayerBackpacks(UUID var1);

    public abstract String getPlayerName(UUID var1);

    @Nullable
    public abstract UUID getPlayerUniqueId(String var1);

    public abstract void savePlayer(UUID var1, String var2);

    public abstract boolean playerExists(UUID var1);

    public abstract boolean playerDeathItemsExists(UUID var1);

    public abstract void savePlayerDeathItems(UUID var1, String var2);

    @Nullable
    public abstract String getPlayerAndDeleteDeathItems(UUID var1);

    public abstract void deletePlayerDeathItems(UUID var1);
}

