/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.database;

import lombok.Generated;
import me.ziomalu.api.config.ConfigValues;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ziomalu.backpackplus.database.HikariSettings;
import pl.ziomalu.backpackplus.database.mysql.MySQLSettings;
import pl.ziomalu.backpackplus.database.postgresql.PostgreSQLSettings;
import pl.ziomalu.backpackplus.utils.BukkitConsole;

public class DatabaseConfigSettings
extends ConfigValues {
    private static DatabaseConfigSettings instance;
    protected static MySQLSettings MYSQL_SETTINGS;
    protected static HikariSettings HIKARI_SETTINGS;
    protected static PostgreSQLSettings POSTGRESQL_SETTINGS;
    public static String DATABASE_TYPE;
    protected static String DATABASE_HOST;
    protected static int DATABASE_PORT;
    protected static String DATABASE_USERNAME;
    protected static String DATABASE_PASSWORD;
    protected static String DATABASE_NAME;
    protected static MySQLSettings.SSL_MODE MYSQL_SSL_MODE;
    protected static boolean MYSQL_ALLOW_PUBLIC_KEY_RETRIEVAL;
    protected static boolean MYSQL_ENABLE_PERFORMANCE_OPTIMIZATIONS;
    protected static boolean MYSQL_CACHE_PREP_STMTS;
    protected static int MYSQL_PREP_STMT_CACHE_SIZE;
    protected static int MYSQL_PREP_STMT_CACHE_SQL_LIMIT;
    protected static boolean MYSQL_USE_SERVER_PREP_STMTS;
    protected static boolean MYSQL_USE_LOCAL_SESSION_STATE;
    protected static boolean MYSQL_REWRITE_BATCHED_STATEMENTS;
    protected static boolean MYSQL_CACHE_RESULT_SET_METADATA;
    protected static boolean MYSQL_CACHE_SERVER_CONFIGURATION;
    protected static boolean MYSQL_ELIDE_SET_AUTO_COMMITS;
    protected static boolean MYSQL_MAINTAIN_TIME_STATS;
    private static int hikariCPMaxLifetimeMs;
    private static int hikariCPMaxPoolSize;
    private static int hikariCPMinIdle;
    private static int hikariCPLeakDetectionThresholdMs;
    private static int hikariCPIdleTimeoutMs;
    private static int connectionTimeoutMs;
    private static int validationTimeoutMs;
    private static int initializationFailTimeoutMs;
    private static long keepaliveTimeMs;

    public DatabaseConfigSettings(JavaPlugin plugin) {
        super(plugin);
        instance = this;
        this.load();
    }

    private void load() {
        DATABASE_TYPE = this.getStringAndSaveIfNotExists("Database.type", "SQLITE", "Possible use: MySQL | SQLite | PostgreSQL");
        DATABASE_HOST = this.getStringAndSaveIfNotExists("Database.host", "localhost", "Host to your database if you are using MYSQL or PostgreSQL");
        DATABASE_PORT = this.getIntAndSaveIfNotExists("Database.port", 3306, "Port to your database if you are using MYSQL or PostgreSQL");
        DATABASE_USERNAME = this.getStringAndSaveIfNotExists("Database.username", "root", "Username (login) for your database if you are using MYSQL or PostgreSQL");
        DATABASE_PASSWORD = this.getStringAndSaveIfNotExists("Database.password", "", "Your database password if you are using MYSQL or PostgreSQL");
        DATABASE_NAME = this.getStringAndSaveIfNotExists("Database.database", "backpacks", "Database name if you are using MYSQL or PostgreSQL");
        this.setComments("Database.mysql-settings", "MySQL settings including TLS and performance");
        String sslModeStr = this.getStringAndSaveIfNotExists("Database.mysql-settings.ssl-mode", MYSQL_SSL_MODE.name(), "Modern TLS switch (DISABLED | PREFERRED | REQUIRED | VERIFY_CA | VERIFY_IDENTITY)");
        try {
            MYSQL_SSL_MODE = MySQLSettings.SSL_MODE.valueOf(sslModeStr.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            MYSQL_SSL_MODE = MySQLSettings.SSL_MODE.VERIFY_IDENTITY;
            this.set("Database.mysql-settings.ssl-mode", MYSQL_SSL_MODE.name());
        }
        MYSQL_ALLOW_PUBLIC_KEY_RETRIEVAL = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.allow-public-key-retrieval", MYSQL_ALLOW_PUBLIC_KEY_RETRIEVAL, "Authorize client to retrieve RSA server public key. Advanced option.");
        this.setComments("Database.hikari-settings", "HikariCP settings for MySQL or PostgreSQL");
        hikariCPMaxLifetimeMs = this.getIntAndSaveIfNotExists("Database.hikari-settings.max-lifetime-ms", hikariCPMaxLifetimeMs, "The maximum connection lifetime in milliseconds (30 minutes)");
        hikariCPMaxPoolSize = this.getIntAndSaveIfNotExists("Database.hikari-settings.max-pool-size", hikariCPMaxPoolSize, "The maximum number of connections in the pool");
        hikariCPMinIdle = this.getIntAndSaveIfNotExists("Database.hikari-settings.min-idle", hikariCPMinIdle, "The minimum number of idle connections in the pool to maintain, set to -1 to ignore");
        hikariCPIdleTimeoutMs = this.getIntAndSaveIfNotExists("Database.hikari-settings.idle-timeout-ms", hikariCPIdleTimeoutMs, "The idle timeout in milliseconds, set to -1 to ignore (10 minutes)");
        hikariCPLeakDetectionThresholdMs = this.getIntAndSaveIfNotExists("Database.hikari-settings.leak-detection-threshold-ms", hikariCPLeakDetectionThresholdMs, "The connection leak detection threshold in milliseconds, set to -1 to ignore");
        connectionTimeoutMs = this.getIntAndSaveIfNotExists("Database.hikari-settings.connection-timeout-ms", connectionTimeoutMs, "Maximum time to wait for a connection from the pool (30 seconds)");
        validationTimeoutMs = this.getIntAndSaveIfNotExists("Database.hikari-settings.validation-timeout-ms", validationTimeoutMs, "Maximum time to wait for connection validation (5 seconds)");
        initializationFailTimeoutMs = this.getIntAndSaveIfNotExists("Database.hikari-settings.initialization-fail-timeout-ms", initializationFailTimeoutMs, "Maximum time to wait for pool initialization during startup (10 seconds)");
        keepaliveTimeMs = this.getLongAndSaveIfNotExists("Database.hikari-settings.keepalive-time-ms", keepaliveTimeMs, "How often to ping idle connections; must be < max-lifetime");
        this.setComments("Database.mysql-settings.performance", "MySQL performance optimization settings");
        MYSQL_ENABLE_PERFORMANCE_OPTIMIZATIONS = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.enable-optimizations", MYSQL_ENABLE_PERFORMANCE_OPTIMIZATIONS, "Enable MySQL performance optimizations", "Recommended: true for better performance");
        MYSQL_CACHE_PREP_STMTS = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.cache-prep-stmts", MYSQL_CACHE_PREP_STMTS, "Enable prepared statement caching");
        MYSQL_PREP_STMT_CACHE_SIZE = this.getIntAndSaveIfNotExists("Database.mysql-settings.performance.prep-stmt-cache-size", MYSQL_PREP_STMT_CACHE_SIZE, "Maximum number of cached prepared statements");
        MYSQL_PREP_STMT_CACHE_SQL_LIMIT = this.getIntAndSaveIfNotExists("Database.mysql-settings.performance.prep-stmt-cache-sql-limit", MYSQL_PREP_STMT_CACHE_SQL_LIMIT, "Maximum SQL length for caching (bytes)");
        MYSQL_USE_SERVER_PREP_STMTS = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.use-server-prep-stmts", MYSQL_USE_SERVER_PREP_STMTS, "Use server-side prepared statements");
        MYSQL_USE_LOCAL_SESSION_STATE = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.use-local-session-state", MYSQL_USE_LOCAL_SESSION_STATE, "Cache session state locally");
        MYSQL_REWRITE_BATCHED_STATEMENTS = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.rewrite-batched-statements", MYSQL_REWRITE_BATCHED_STATEMENTS, "Rewrite batched statements for better performance");
        MYSQL_CACHE_RESULT_SET_METADATA = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.cache-result-set-metadata", MYSQL_CACHE_RESULT_SET_METADATA, "Cache result set metadata");
        MYSQL_CACHE_SERVER_CONFIGURATION = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.cache-server-configuration", MYSQL_CACHE_SERVER_CONFIGURATION, "Cache server configuration");
        MYSQL_ELIDE_SET_AUTO_COMMITS = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.elide-set-auto-commits", MYSQL_ELIDE_SET_AUTO_COMMITS, "Skip unnecessary setAutoCommit calls");
        MYSQL_MAINTAIN_TIME_STATS = this.getBooleanAndSaveIfNotExists("Database.mysql-settings.performance.maintain-time-stats", MYSQL_MAINTAIN_TIME_STATS, "Maintain timing statistics (disable for better performance)");
        this.validateConfiguration();
        MYSQL_SETTINGS = new MySQLSettings(DATABASE_HOST, DATABASE_PORT, DATABASE_USERNAME, DATABASE_PASSWORD, DATABASE_NAME, MYSQL_SSL_MODE, MYSQL_ALLOW_PUBLIC_KEY_RETRIEVAL, MYSQL_ENABLE_PERFORMANCE_OPTIMIZATIONS, MYSQL_CACHE_PREP_STMTS, MYSQL_PREP_STMT_CACHE_SIZE, MYSQL_PREP_STMT_CACHE_SQL_LIMIT, MYSQL_USE_SERVER_PREP_STMTS, MYSQL_USE_LOCAL_SESSION_STATE, MYSQL_REWRITE_BATCHED_STATEMENTS, MYSQL_CACHE_RESULT_SET_METADATA, MYSQL_CACHE_SERVER_CONFIGURATION, MYSQL_ELIDE_SET_AUTO_COMMITS, MYSQL_MAINTAIN_TIME_STATS);
        HIKARI_SETTINGS = new HikariSettings(hikariCPMaxLifetimeMs, hikariCPMaxPoolSize, hikariCPMinIdle, hikariCPLeakDetectionThresholdMs, hikariCPIdleTimeoutMs, connectionTimeoutMs, validationTimeoutMs, initializationFailTimeoutMs, keepaliveTimeMs);
        POSTGRESQL_SETTINGS = new PostgreSQLSettings(DATABASE_HOST, DATABASE_PORT, DATABASE_USERNAME, DATABASE_PASSWORD, DATABASE_NAME);
        if (this.getMissingFields() == 0) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72Configuration loaded successfully. No missing fields detected.");
        } else {
            this.save();
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72Configuration loaded. \u00a7c" + this.getMissingFields() + " \u00a72missing fields have been added to the configuration.");
        }
    }

    private void validateConfiguration() {
        if (hikariCPMaxPoolSize <= 0) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cWarning: max-pool-size must be greater than 0. Using default value: 10");
            hikariCPMaxPoolSize = 10;
        }
        if (hikariCPMaxPoolSize > 50) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7eWarning: max-pool-size is very high (" + hikariCPMaxPoolSize + "). Consider reducing it for better performance.");
        }
        if (DATABASE_TYPE.equalsIgnoreCase("MYSQL") && DATABASE_PASSWORD.isEmpty()) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7eWarning: MySQL password is empty. This may cause connection issues.");
        }
        if (DATABASE_TYPE.equalsIgnoreCase("MYSQL") && (DATABASE_PORT <= 0 || DATABASE_PORT > 65535)) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cWarning: Invalid MySQL port (" + DATABASE_PORT + "). Using default: 3306");
            DATABASE_PORT = 3306;
        }
        if (hikariCPMinIdle > hikariCPMaxPoolSize && hikariCPMinIdle != -1) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cWarning: min-idle (" + hikariCPMinIdle + ") is greater than max-pool-size (" + hikariCPMaxPoolSize + "). Setting min-idle to max-pool-size.");
            hikariCPMinIdle = hikariCPMaxPoolSize;
        }
        if (connectionTimeoutMs < 1000) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7eWarning: connection-timeout-ms is very low (" + connectionTimeoutMs + "ms). This may cause connection failures.");
        }
        if (keepaliveTimeMs >= (long)hikariCPMaxLifetimeMs && hikariCPMaxLifetimeMs > 0) {
            long adjusted = Math.max(30000L, (long)hikariCPMaxLifetimeMs - 60000L);
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7eInfo: keepalive-time-ms (" + keepaliveTimeMs + ") adjusted to " + adjusted + " to be < max-lifetime.");
            keepaliveTimeMs = adjusted;
        }
    }

    public static MySQLSettings getMySQLSettings() {
        return MYSQL_SETTINGS;
    }

    public static HikariSettings getHikariSettings() {
        return HIKARI_SETTINGS;
    }

    public static PostgreSQLSettings getPostgreSQLSettings() {
        return POSTGRESQL_SETTINGS;
    }

    public static String getDatabaseType() {
        return DATABASE_TYPE;
    }

    @Generated
    public static DatabaseConfigSettings getInstance() {
        return instance;
    }

    static {
        DATABASE_TYPE = "SQLITE";
        DATABASE_HOST = "localhost";
        DATABASE_PORT = 3306;
        DATABASE_USERNAME = "root";
        DATABASE_PASSWORD = "";
        DATABASE_NAME = "backpacks";
        MYSQL_SSL_MODE = MySQLSettings.SSL_MODE.VERIFY_IDENTITY;
        MYSQL_ALLOW_PUBLIC_KEY_RETRIEVAL = true;
        MYSQL_ENABLE_PERFORMANCE_OPTIMIZATIONS = true;
        MYSQL_CACHE_PREP_STMTS = true;
        MYSQL_PREP_STMT_CACHE_SIZE = 250;
        MYSQL_PREP_STMT_CACHE_SQL_LIMIT = 2048;
        MYSQL_USE_SERVER_PREP_STMTS = true;
        MYSQL_USE_LOCAL_SESSION_STATE = true;
        MYSQL_REWRITE_BATCHED_STATEMENTS = true;
        MYSQL_CACHE_RESULT_SET_METADATA = true;
        MYSQL_CACHE_SERVER_CONFIGURATION = true;
        MYSQL_ELIDE_SET_AUTO_COMMITS = true;
        MYSQL_MAINTAIN_TIME_STATS = false;
        hikariCPMaxLifetimeMs = 1800000;
        hikariCPMaxPoolSize = 20;
        hikariCPMinIdle = 2;
        hikariCPLeakDetectionThresholdMs = 2000;
        hikariCPIdleTimeoutMs = 600000;
        connectionTimeoutMs = 30000;
        validationTimeoutMs = 5000;
        initializationFailTimeoutMs = 10000;
        keepaliveTimeMs = 120000L;
    }
}

