/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.database;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.database.Database;
import pl.ziomalu.backpackplus.database.DatabaseConfigSettings;
import pl.ziomalu.backpackplus.database.HikariSettings;
import pl.ziomalu.backpackplus.database.enums.DatabaseType;
import pl.ziomalu.backpackplus.database.mysql.MySQL;
import pl.ziomalu.backpackplus.database.mysql.MySQLSettings;
import pl.ziomalu.backpackplus.database.postgresql.PostgreSQL;
import pl.ziomalu.backpackplus.database.postgresql.PostgreSQLSettings;
import pl.ziomalu.backpackplus.database.sqlite.SQLite;
import pl.ziomalu.backpackplus.utils.BukkitConsole;

public final class DatabaseManager {
    private static DatabaseManager instance;
    private Database database;
    private DatabaseType type;
    private final Plugin plugin;
    private final Logger logger;

    public DatabaseManager(Plugin plugin, DatabaseType type) {
        instance = this;
        this.plugin = plugin;
        this.type = type;
        this.logger = plugin.getLogger();
    }

    public boolean connectMySQL() {
        MySQLSettings settings = DatabaseConfigSettings.MYSQL_SETTINGS;
        HikariSettings hikariSettings = DatabaseConfigSettings.HIKARI_SETTINGS;
        if (settings.getHost().contains(":")) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cInvalid host\u00a78: \u00a7f" + settings.getHost() + " \u00a7cPlugin will be disabled to prevent loss of items");
            this.plugin.getPluginLoader().disablePlugin(this.plugin);
            return false;
        }
        if (settings.getDatabase().isEmpty()) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cDatabase name not specified. \u00a7cPlugin will be disabled to prevent loss of items");
            this.plugin.getPluginLoader().disablePlugin(this.plugin);
            return false;
        }
        this.database = new MySQL(settings, hikariSettings);
        this.type = DatabaseType.MYSQL;
        try {
            this.database.connect();
            if (this.database.isConnected()) {
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72MySQL Successfully connected to database");
                return true;
            }
        }
        catch (SQLException ex) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cMySQL Failed to connect to database. \u00a7cPlugin will be disabled to prevent loss of items");
            this.logger.log(Level.SEVERE, "Failed to connect to the database: ", ex);
            this.plugin.getPluginLoader().disablePlugin(this.plugin);
        }
        return false;
    }

    public boolean connectPostgreSQL() {
        PostgreSQLSettings settings = DatabaseConfigSettings.POSTGRESQL_SETTINGS;
        HikariSettings hikariSettings = DatabaseConfigSettings.HIKARI_SETTINGS;
        if (settings.getHost().contains(":")) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cInvalid host\u00a78: \u00a7f" + settings.getHost() + " \u00a7cPlugin will be disabled to prevent loss of items");
            this.plugin.getPluginLoader().disablePlugin(this.plugin);
            return false;
        }
        if (settings.getDatabase().isEmpty()) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cDatabase name not specified. \u00a7cPlugin will be disabled to prevent loss of items");
            this.plugin.getPluginLoader().disablePlugin(this.plugin);
            return false;
        }
        this.database = new PostgreSQL(settings, hikariSettings);
        this.type = DatabaseType.POSTGRESQL;
        try {
            this.database.connect();
            if (this.database.isConnected()) {
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72PostgreSQL Successfully connected to database");
                return true;
            }
        }
        catch (SQLException ex) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cPostgreSQL Failed to connect to database. \u00a7cPlugin will be disabled to prevent loss of items");
            this.logger.log(Level.SEVERE, "Failed to connect to the database: ", ex);
            this.plugin.getPluginLoader().disablePlugin(this.plugin);
        }
        return false;
    }

    public boolean connectSQLite(String fileName) {
        this.database = new SQLite(fileName);
        this.type = DatabaseType.SQLITE;
        try {
            this.database.connect();
            if (this.database.isConnected()) {
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72SQLite Successfully connected to database");
                return true;
            }
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a7cSQLite Failed to connect to database. \u00a7cPlugin will be disabled to prevent loss of items");
            this.plugin.getPluginLoader().disablePlugin(this.plugin);
            return false;
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Failed to connect to the database: ", ex);
            return false;
        }
    }

    public void disconnect() {
        if (this.database != null) {
            this.database.disconnect();
        }
    }

    @Generated
    public static DatabaseManager getInstance() {
        return instance;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public DatabaseType getType() {
        return this.type;
    }
}

