/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.database.postgresql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.DatabaseBackpack;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.database.BackpackInfo;
import pl.ziomalu.backpackplus.database.Database;
import pl.ziomalu.backpackplus.database.HikariSettings;
import pl.ziomalu.backpackplus.database.enums.DatabaseType;
import pl.ziomalu.backpackplus.database.postgresql.PostgreSQLSettings;
import pl.ziomalu.backpackplus.gui.backpack.backpacksgui.PlayerBackpackGuiInfo;
import pl.ziomalu.backpackplus.utils.BukkitConsole;
import pl.ziomalu.backpackplus.utils.OfflinePlayersData;
import pl.ziomalu.backpackplus.utils.Utils;

public class PostgreSQL
extends Database {
    private final PostgreSQLSettings settings;
    private final HikariSettings hikariSettings;
    private HikariDataSource dataSource;

    public PostgreSQL(PostgreSQLSettings settings, HikariSettings hikariSettings) {
        super(DatabaseType.POSTGRESQL);
        this.settings = settings;
        this.hikariSettings = hikariSettings;
    }

    @Override
    public void connect() throws SQLException {
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            Class.forName("org.postgresql.Driver");
            HikariConfig config = new HikariConfig();
            config.setPoolName(BackpackPlus.getInstance().getName() + "PostgreSQLPool");
            config.setJdbcUrl("jdbc:postgresql://" + this.settings.getHost() + ":" + this.settings.getPort() + "/" + this.settings.getDatabase());
            config.setUsername(this.settings.getUsername());
            config.setPassword(this.settings.getPassword());
            config.setConnectionTestQuery("SELECT 1");
            config.setMaxLifetime((long)this.hikariSettings.getHikariCPMaxLifetimeMs());
            config.setMaximumPoolSize(this.hikariSettings.getHikariCPMaxPoolSize());
            if (this.hikariSettings.getHikariCPMinIdle() != -1) {
                config.setMinimumIdle(this.hikariSettings.getHikariCPMinIdle());
            }
            if (this.hikariSettings.getHikariCPIdleTimeoutMs() != -1) {
                config.setIdleTimeout((long)this.hikariSettings.getHikariCPIdleTimeoutMs());
            }
            if (this.hikariSettings.getHikariCPLeakDetectionThresholdMs() != -1) {
                config.setLeakDetectionThreshold((long)this.hikariSettings.getHikariCPLeakDetectionThresholdMs());
            }
            this.dataSource = new HikariDataSource(config);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("HikariCP library is missing!", e);
        }
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            this.dataSource.close();
            BackpackPlus.getInstance().getLogger().info("PostgreSQL Successfully disconnected from the database");
        }
    }

    @Override
    public boolean isConnected() {
        return this.dataSource != null && !this.dataSource.isClosed();
    }

    @Override
    public Connection getConnection() {
        if (!this.isConnected()) {
            this.plugin.getLogger().severe("Attempt to get connection while PostgreSQL is not connected.");
            throw new IllegalStateException("PostgreSQL is not connected");
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("Failed to get connection from HikariCP pool: " + ex.getMessage());
            throw new RuntimeException("Connection error", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String query, Object ... params) throws SQLException {
        try (Connection connection = this.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(query);
                try {
                    this.setParameters(statement, params);
                    n = statement.executeUpdate();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException ex) {
            this.logError("executeUpdate", query, ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String query, Object ... params) throws SQLException {
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(query);
                try {
                    this.setParameters(statement, params);
                    bl = statement.execute();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.logError("execute", query, ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String query) throws SQLException {
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                Statement statement = connection.createStatement();
                try {
                    bl = statement.execute(query);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.logError("execute", query, ex);
            throw ex;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean objectExists(String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void createTables() throws SQLException {
        try {
            this.execute("CREATE TABLE IF NOT EXISTS players (    id SERIAL PRIMARY KEY,    playerName VARCHAR(32) NOT NULL,    playerUniqueId VARCHAR(36) UNIQUE NOT NULL)");
            this.execute("CREATE TABLE IF NOT EXISTS backpacks (    id SERIAL PRIMARY KEY,    backpackUUID VARCHAR(36) NOT NULL,    backpackOwnerUUID VARCHAR(36) NOT NULL,    content TEXT,    last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP,    last_player_uuid VARCHAR(36),    is_open BOOLEAN DEFAULT FALSE    FOREIGN KEY (backpackOwnerUUID) REFERENCES players(playerUniqueId) ON DELETE CASCADE,    FOREIGN KEY (last_player_uuid) REFERENCES players(playerUniqueId) ON DELETE SET NULL)");
            this.execute("CREATE TABLE IF NOT EXISTS deaths_items (    id SERIAL PRIMARY KEY,    playerUniqueId VARCHAR(36) NOT NULL,    content TEXT,    FOREIGN KEY (playerUniqueId) REFERENCES players(playerUniqueId) ON DELETE CASCADE)");
            this.createIndexIfNotExists("backpacks", "idx_backpackOwnerUUID", "backpackOwnerUUID");
            this.createIndexIfNotExists("players", "idx_playerUniqueId", "playerUniqueId");
            this.createIndexIfNotExists("deaths_items", "idx_deaths_items_playerUniqueId", "playerUniqueId");
            this.plugin.getLogger().info("Tables and indexes created successfully.");
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create tables or indexes: ", ex);
            throw ex;
        }
    }

    private void createIndexIfNotExists(String tableName, String indexName, String columnName) {
        try {
            String query = String.format("CREATE INDEX IF NOT EXISTS %s ON %s(%s)", indexName, tableName, columnName);
            this.execute(query);
        }
        catch (SQLException e) {
            BackpackPlus.getInstance().getLogger().severe("Error creating index: " + e.getMessage());
        }
    }

    @Override
    public final void saveBackpackToDatabaseAsync(Backpack backpack, Consumer<Boolean> callback) {
        String query = "INSERT INTO backpacks (backpackUUID, backpackOwnerUUID, content, last_updated, last_player_uuid) VALUES (?, ?, ?, ?, ?)";
        CompletableFuture.supplyAsync(() -> {
            try {
                int rowsAffected = this.executeUpdate(query, backpack.getBackpackUniqueId().toString(), backpack.getBackpackOwnerUniqueId().toString(), backpack.getContent(), new Timestamp(backpack.getLastUpdated().getTime()), backpack.getBackpackOwnerUniqueId().toString());
                return rowsAffected > 0;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Error saving backpack to database", ex);
                return false;
            }
        }).thenAccept(result -> {
            Bukkit.getScheduler().runTask(this.plugin, () -> callback.accept((Boolean)result));
            Utils.debugLogToConsole("[PostgreSQL] [Database] [saveBackpackToDatabase] Success: " + result);
        });
    }

    @Override
    public final void updateBackpackContentAsync(@NotNull Backpack backpack, String jsonContent, Consumer<Boolean> callback) {
        String query = "UPDATE backpacks SET content=?, last_updated=?, last_player_uuid=? WHERE backpackUUID=?";
        CompletableFuture.supplyAsync(() -> {
            try {
                int rowsAffected = this.executeUpdate(query, jsonContent, new Timestamp(new Date().getTime()), backpack.getLastPlayerUniqueId().toString(), backpack.getBackpackUniqueId().toString());
                return rowsAffected > 0;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error updating backpack: ", ex);
                return false;
            }
        }).thenAccept(result -> {
            Bukkit.getScheduler().runTask(this.plugin, () -> callback.accept((Boolean)result));
            Utils.debugLogToConsole("[Database] [updateBackpackContent] Success: " + result);
        });
    }

    @Override
    public void loadBackpackFromDatabase(UUID backpackUniqueId, int backpackTier, Consumer<Object> callback) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM backpacks WHERE backpackUUID = ?");){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                Backpack backpack = null;
                if (resultSet.next()) {
                    backpack = this.createBackpackFromResultSet(resultSet, backpackTier);
                }
                callback.accept(backpack);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error loading backpack from database", ex);
            callback.accept(null);
        }
    }

    @Override
    public void loadBackpackFromDatabaseAsync(UUID backpackUniqueId, int backpackTier, Consumer<Backpack> callback) {
        CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).thenAccept(result -> Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> callback.accept((Backpack)result)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Timestamp getBackpackLastUpdate(UUID backpackUniqueId) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT last_updated FROM backpack WHERE backpackUUID = ?");){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Timestamp timestamp = resultSet.getTimestamp("last_updated");
                return timestamp;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting 'last_updated' from database for UUID: " + String.valueOf(backpackUniqueId), ex);
            return null;
        }
    }

    @Override
    public void updateBackpackOpenState(UUID backpackUniqueId, boolean isOpen) {
        String sql = "UPDATE backpacks SET is_open = ? WHERE backpackUUID = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBoolean(1, isOpen);
            statement.setObject(2, backpackUniqueId);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error updating backpack open state in PostgreSQL", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Boolean> getBackpackOpenState(UUID backpackUniqueId) {
        String sql = "SELECT is_open FROM backpacks WHERE backpackUUID = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return Optional.empty();
                Optional<Boolean> optional = Optional.of(resultSet.getBoolean("is_open"));
                return optional;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting 'is_open' from database for UUID: " + String.valueOf(backpackUniqueId), ex);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<BackpackInfo> getBackpackState(UUID backpackUniqueId) {
        String sql = "SELECT is_open, last_updated, last_player_uuid FROM backpacks WHERE backpackUUID = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return Optional.empty();
                boolean isOpen = rs.getBoolean("is_open");
                Timestamp lastUpdated = rs.getTimestamp("last_updated");
                UUID lastPlayerUniqueId = UUID.fromString(rs.getString("last_player_uuid"));
                Optional<BackpackInfo> optional = Optional.of(new BackpackInfo(isOpen, lastUpdated, lastPlayerUniqueId));
                return optional;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting backpack state from database for UUID: " + String.valueOf(backpackUniqueId), ex);
        }
        return Optional.empty();
    }

    @Override
    public void addLastPlayerUUIDColumnIfNotExists() {
        String checkColumnSQLPostgreSQL = "SELECT column_name FROM information_schema.columns WHERE table_name='backpacks' AND column_name='last_player_uuid'";
        String alterTableSQL = "ALTER TABLE backpacks ADD COLUMN last_player_uuid VARCHAR(36)";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(checkColumnSQLPostgreSQL);
             ResultSet rs = statement.executeQuery();){
            if (!rs.next()) {
                this.executeUpdate(alterTableSQL, new Object[0]);
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72Added missing column \u00a78'\u00a7flast_player_uuid\u00a78' \u00a72to database");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Error when modifying a table: " + ex.getMessage());
        }
    }

    @Override
    public void addBackpackStateColumnIfNotExists() {
        String checkColumnSQLPostgreSQL = "SELECT column_name FROM information_schema.columns WHERE table_name='backpacks' AND column_name='is_open'";
        String alterTableSQL = "ALTER TABLE backpacks ADD COLUMN is_open BOOLEAN DEFAULT FALSE";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(checkColumnSQLPostgreSQL);
             ResultSet rs = statement.executeQuery();){
            if (!rs.next()) {
                this.executeUpdate(alterTableSQL, new Object[0]);
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72Added missing column \u00a78'\u00a7fis_open\u00a78' \u00a72to database");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Error when modifying a table: " + ex.getMessage());
        }
    }

    @Override
    public ConcurrentMap<UUID, PlayerBackpackGuiInfo> loadAllPlayersBackpacks(boolean logs) {
        ConcurrentHashMap<UUID, PlayerBackpackGuiInfo> allPlayersBackpacks = new ConcurrentHashMap<UUID, PlayerBackpackGuiInfo>();
        try (Connection conn = this.getConnection();
             Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery("SELECT backpackOwnerUUID, COUNT(*) AS backpackCount, MAX(last_updated) AS latestUpdate FROM backpacks GROUP BY backpackOwnerUUID ORDER BY latestUpdate DESC");){
            while (rs.next()) {
                UUID playerUniqueId = UUID.fromString(rs.getString("backpackOwnerUUID"));
                Object playerName = OfflinePlayersData.getInstance().getPlayerName(playerUniqueId);
                if (playerName == null || ((String)playerName).isEmpty()) {
                    playerName = "&6Unknown &8| &f" + String.valueOf(playerUniqueId);
                }
                int backpackCount = rs.getInt("backpackCount");
                PlayerBackpackGuiInfo playerBackpackGuiInfo = new PlayerBackpackGuiInfo(playerUniqueId, (String)playerName, backpackCount);
                allPlayersBackpacks.put(playerUniqueId, playerBackpackGuiInfo);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Error loading all database players backpacks: ", ex);
            this.plugin.getLogger().warning(ex.getMessage());
        }
        return allPlayersBackpacks;
    }

    @Override
    public CompletableFuture<ConcurrentMap<UUID, PlayerBackpackGuiInfo>> loadAllPlayersBackpacksAsync(boolean logs) {
        return CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<UUID, PlayerBackpackGuiInfo> allPlayersBackpacks = new ConcurrentHashMap<UUID, PlayerBackpackGuiInfo>();
            String query = "SELECT backpackOwnerUUID, COUNT(*) AS backpackCount, MAX(last_updated) AS latestUpdate FROM backpacks GROUP BY backpackOwnerUUID ORDER BY latestUpdate DESC";
            try (Connection connection = this.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(query);){
                while (rs.next()) {
                    UUID playerUniqueId = UUID.fromString(rs.getString("backpackOwnerUUID"));
                    Object playerName = OfflinePlayersData.getInstance().getPlayerName(playerUniqueId);
                    if (playerName == null || ((String)playerName).isEmpty()) {
                        playerName = "&6Unknown &8| &f" + String.valueOf(playerUniqueId);
                    }
                    int backpackCount = rs.getInt("backpackCount");
                    PlayerBackpackGuiInfo playerBackpackGuiInfo = new PlayerBackpackGuiInfo(playerUniqueId, (String)playerName, backpackCount);
                    allPlayersBackpacks.put(playerUniqueId, playerBackpackGuiInfo);
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error loading all database players backpacks: ", ex);
            }
            return allPlayersBackpacks;
        });
    }

    @Override
    public List<DatabaseBackpack> loadPlayerBackpacks(UUID backpackOwnerUniqueId) {
        ArrayList<DatabaseBackpack> playerBackpacks = new ArrayList<DatabaseBackpack>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM backpacks WHERE backpackOwnerUUID=? ORDER BY last_updated DESC");){
            statement.setString(1, backpackOwnerUniqueId.toString());
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    String lastPlayerUUIDString = rs.getString("last_player_uuid");
                    UUID lastPlayerUUID = lastPlayerUUIDString != null && !lastPlayerUUIDString.isEmpty() ? UUID.fromString(lastPlayerUUIDString) : null;
                    playerBackpacks.add(new DatabaseBackpack(UUID.fromString(rs.getString("backpackUUID")), UUID.fromString(rs.getString("backpackOwnerUUID")), Utils.extractTier(rs.getString("content")), rs.getTimestamp("last_updated"), lastPlayerUUID));
                }
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Error loading player backpack: " + backpackOwnerUniqueId.toString(), ex);
        }
        return playerBackpacks;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getPlayerName(UUID playerUniqueId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public UUID getPlayerUniqueId(String playerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void savePlayer(UUID playerUniqueId, String playerName) {
        if (this.playerExists(playerUniqueId)) {
            return;
        }
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement("INSERT INTO players(playerUniqueId, playerName) VALUES (?, ?)");){
            statement.setString(1, playerUniqueId.toString());
            statement.setString(2, playerName);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error saving player (UUID and name) to database", ex);
        }
    }

    @Override
    public boolean playerExists(UUID playerUniqueId) {
        try {
            return this.objectExists(String.format("SELECT * FROM players WHERE playerUniqueId='%s'", playerUniqueId.toString()));
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error checking if player exists: " + String.valueOf(playerUniqueId), ex);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean playerDeathItemsExists(UUID playerUniqueId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void savePlayerDeathItems(UUID playerUniqueId, String jsonContent) {
        String query = "INSERT INTO deaths_items(playerUniqueId, content) VALUES (?, ?)";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, playerUniqueId.toString());
            statement.setString(2, jsonContent);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error saving player death items to database", ex);
        }
    }

    @Override
    @Nullable
    public String getPlayerAndDeleteDeathItems(UUID playerUniqueId) {
        String content = null;
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            Utils.debugLogToConsole(Level.INFO, "Transaction started for player: " + String.valueOf(playerUniqueId));
            try (PreparedStatement statement = connection.prepareStatement("SELECT content FROM deaths_items WHERE playerUniqueId=?");
                 PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM deaths_items WHERE playerUniqueId=?");){
                statement.setString(1, playerUniqueId.toString());
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        content = resultSet.getString("content");
                        Utils.debugLogToConsole(Level.INFO, "Content found for player: " + String.valueOf(playerUniqueId));
                    }
                    if (content != null) {
                        deleteStatement.setString(1, playerUniqueId.toString());
                        deleteStatement.executeUpdate();
                        Utils.debugLogToConsole(Level.INFO, "Content deleted for player: " + String.valueOf(playerUniqueId));
                    }
                    connection.commit();
                    Utils.debugLogToConsole(Level.INFO, "Transaction committed for player: " + String.valueOf(playerUniqueId));
                }
            }
            catch (SQLException ex) {
                connection.rollback();
                Utils.debugLogToConsole(Level.WARNING, "Transaction rolled back for player: " + String.valueOf(playerUniqueId));
                throw ex;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting and deleting player death items from database", ex);
        }
        return content;
    }

    @Override
    public void deletePlayerDeathItems(UUID playerUniqueId) {
        String query = "DELETE FROM deaths_items WHERE playerUniqueId=?";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, playerUniqueId.toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error deleting player death items from database", ex);
        }
    }
}

