/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.database.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.DatabaseBackpack;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.database.BackpackInfo;
import pl.ziomalu.backpackplus.database.Database;
import pl.ziomalu.backpackplus.database.enums.DatabaseType;
import pl.ziomalu.backpackplus.gui.backpack.backpacksgui.PlayerBackpackGuiInfo;
import pl.ziomalu.backpackplus.utils.BukkitConsole;
import pl.ziomalu.backpackplus.utils.OfflinePlayersData;
import pl.ziomalu.backpackplus.utils.Utils;

public class SQLite
extends Database {
    private Connection connection;
    private final String url;

    public SQLite(String databaseName) {
        super(DatabaseType.SQLITE);
        this.url = "jdbc:sqlite:plugins/" + BackpackPlus.getInstance().getName() + "/" + databaseName + ".db";
    }

    @Override
    public void connect() throws SQLException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to load SQLite JDBC class", ex);
        }
        this.connection = DriverManager.getConnection(this.url);
    }

    @Override
    public void disconnect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                BackpackPlus.getInstance().getLogger().info("SQLite Successfully disconnected from the database");
            }
        }
        catch (SQLException ex) {
            BackpackPlus.getInstance().getLogger().log(Level.SEVERE, "Error during SQL operation: ", ex);
        }
    }

    @Override
    public boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.connection;
    }

    @Override
    public int executeUpdate(String query, Object ... params) throws SQLException {
        int n;
        block8: {
            PreparedStatement statement = this.getConnection().prepareStatement(query);
            try {
                this.setParameters(statement, params);
                n = statement.executeUpdate();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.logError("executeUpdate", query, ex);
                    throw ex;
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public boolean execute(String query, Object ... params) throws SQLException {
        boolean bl;
        block8: {
            PreparedStatement statement = this.getConnection().prepareStatement(query);
            try {
                this.setParameters(statement, params);
                bl = statement.execute();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.logError("execute", query, ex);
                    throw ex;
                }
            }
            statement.close();
        }
        return bl;
    }

    @Override
    public boolean execute(String query) throws SQLException {
        boolean bl;
        block8: {
            Statement statement = this.getConnection().createStatement();
            try {
                bl = statement.execute(query);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.logError("execute", query, ex);
                    throw ex;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean objectExists(String query) throws SQLException {
        try (Statement statement = this.getConnection().createStatement();){
            boolean bl;
            block14: {
                ResultSet resultSet = statement.executeQuery(query);
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.logError("objectExists", query, ex);
            throw ex;
        }
    }

    @Override
    public void createTables() throws SQLException {
        try {
            this.execute("CREATE TABLE IF NOT EXISTS backpacks(id INTEGER PRIMARY KEY AUTOINCREMENT, backpackUUID VARCHAR(36), backpackOwnerUUID VARCHAR(36), content JSON, last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP, last_player_uuid VARCHAR(36), is_open INTEGER DEFAULT 0)");
            this.execute("CREATE TABLE IF NOT EXISTS players(id INTEGER PRIMARY KEY AUTOINCREMENT, playerName TEXT(32), playerUniqueId VARCHAR(36))");
            this.execute("CREATE TABLE IF NOT EXISTS deaths_items (id INTEGER PRIMARY KEY AUTOINCREMENT, playerUniqueId VARCHAR(36), content JSON)");
            this.execute("CREATE INDEX IF NOT EXISTS idx_backpackOwnerUUID ON backpacks(backpackOwnerUUID)");
            this.execute("CREATE INDEX IF NOT EXISTS idx_playerUniqueId ON players(playerUniqueId)");
            this.execute("CREATE INDEX IF NOT EXISTS idx_deaths_items_playerUniqueId ON deaths_items(playerUniqueId)");
            this.plugin.getLogger().info("Tables and indexes created successfully.");
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create tables or indexes: ", ex);
            throw ex;
        }
    }

    @Override
    public final void saveBackpackToDatabaseAsync(Backpack backpack, Consumer<Boolean> callback) {
        String query = "INSERT INTO backpacks (backpackUUID, backpackOwnerUUID, content, last_updated, last_player_uuid) VALUES (?, ?, ?, ?, ?)";
        CompletableFuture.supplyAsync(() -> {
            try {
                int rowsAffected = this.executeUpdate(query, backpack.getBackpackUniqueId().toString(), backpack.getBackpackOwnerUniqueId().toString(), backpack.getContent(), BackpackPlus.DATE_FORMAT.format(backpack.getLastUpdated()), backpack.getBackpackOwnerUniqueId().toString());
                return rowsAffected > 0;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Error saving backpack to database", ex);
                return false;
            }
        }).thenAccept(result -> {
            Bukkit.getScheduler().runTask(this.plugin, () -> callback.accept((Boolean)result));
            Utils.debugLogToConsole("[SQLite] [Database] [saveBackpackToDatabase] Success: " + result);
        });
    }

    @Override
    public final void updateBackpackContentAsync(@NotNull Backpack backpack, String jsonContent, Consumer<Boolean> callback) {
        String query = "UPDATE backpacks SET content=?, last_updated=?, last_player_uuid=? WHERE backpackUUID=?";
        CompletableFuture.supplyAsync(() -> {
            try {
                int rowsAffected = this.executeUpdate(query, jsonContent, BackpackPlus.DATE_FORMAT.format(new Date()), backpack.getLastPlayerUniqueId().toString(), backpack.getBackpackUniqueId().toString());
                return rowsAffected > 0;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error updating backpack: ", ex);
                return false;
            }
        }).thenAccept(result -> {
            Bukkit.getScheduler().runTask(this.plugin, () -> callback.accept((Boolean)result));
            Utils.debugLogToConsole("[Database] [updateBackpackContent] Success: " + result);
        });
    }

    @Override
    public void loadBackpackFromDatabase(UUID backpackUniqueId, int backpackTier, Consumer<Object> callback) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM backpacks WHERE backpackUUID=?");){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                Backpack backpack = null;
                if (resultSet.next()) {
                    backpack = this.createBackpackFromResultSet(resultSet, backpackTier);
                }
                callback.accept(backpack);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error loading backpack from database", ex);
            callback.accept(null);
        }
    }

    @Override
    public void loadBackpackFromDatabaseAsync(UUID backpackUniqueId, int backpackTier, Consumer<Backpack> callback) {
        CompletableFuture.supplyAsync(() -> {
            try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM backpacks WHERE backpackUUID=?");){
                Backpack backpack;
                block15: {
                    statement.setString(1, backpackUniqueId.toString());
                    ResultSet resultSet = statement.executeQuery();
                    try {
                        Backpack backpack2 = null;
                        if (resultSet.next()) {
                            backpack2 = this.createBackpackFromResultSet(resultSet, backpackTier);
                        }
                        backpack = backpack2;
                        if (resultSet == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return backpack;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Error loading backpack from database", ex);
                return null;
            }
        }).thenAccept(result -> Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> callback.accept((Backpack)result)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Timestamp getBackpackLastUpdate(UUID backpackUniqueId) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT last_updated FROM backpack WHERE backpackUUID = ?");){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Timestamp timestamp = resultSet.getTimestamp("last_updated");
                return timestamp;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting 'last_updated' from database for UUID: " + String.valueOf(backpackUniqueId), ex);
            return null;
        }
    }

    @Override
    public void updateBackpackOpenState(UUID backpackUniqueId, boolean isOpen) {
        String sql = "UPDATE backpacks SET is_open = ? WHERE backpackUUID = ?";
        try (PreparedStatement statement = this.getConnection().prepareStatement(sql);){
            statement.setBoolean(1, isOpen);
            statement.setString(2, backpackUniqueId.toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error updating backpack open state in SQLite", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Boolean> getBackpackOpenState(UUID backpackUniqueId) {
        String sql = "SELECT is_open FROM backpacks WHERE backpackUUID = ?";
        try (PreparedStatement statement = this.getConnection().prepareStatement(sql);){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return Optional.empty();
                Optional<Boolean> optional = Optional.of(resultSet.getBoolean("is_open"));
                return optional;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting 'is_open' from database for UUID: " + String.valueOf(backpackUniqueId), ex);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<BackpackInfo> getBackpackState(UUID backpackUniqueId) {
        String sql = "SELECT is_open, last_updated, last_player_uuid FROM backpacks WHERE backpackUUID = ?";
        try (PreparedStatement statement = this.getConnection().prepareStatement(sql);){
            statement.setString(1, backpackUniqueId.toString());
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return Optional.empty();
                boolean isOpen = rs.getBoolean("is_open");
                Timestamp lastUpdated = rs.getTimestamp("last_updated");
                String lastPlayerUuidString = rs.getString("last_player_uuid");
                UUID lastPlayerUniqueId = lastPlayerUuidString == null ? null : UUID.fromString(lastPlayerUuidString);
                Optional<BackpackInfo> optional = Optional.of(new BackpackInfo(isOpen, lastUpdated, lastPlayerUniqueId));
                return optional;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting backpack state from database for UUID: " + String.valueOf(backpackUniqueId), ex);
        }
        return Optional.empty();
    }

    @Override
    public void addLastPlayerUUIDColumnIfNotExists() {
        String checkColumnSQLSQLite = "PRAGMA table_info(backpacks)";
        String alterTableSQL = "ALTER TABLE backpacks ADD COLUMN last_player_uuid VARCHAR(36)";
        try (PreparedStatement statement = this.getConnection().prepareStatement(checkColumnSQLSQLite);
             ResultSet rs = statement.executeQuery();){
            boolean columnExists = false;
            while (rs.next()) {
                String columnName = rs.getString("name");
                if (!"last_player_uuid".equalsIgnoreCase(columnName)) continue;
                columnExists = true;
                break;
            }
            if (!columnExists) {
                this.executeUpdate(alterTableSQL, new Object[0]);
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72Added missing column \u00a78'\u00a7flast_player_uuid\u00a78' \u00a72to database");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Error when modifying a table: " + ex.getMessage());
        }
    }

    @Override
    public void addBackpackStateColumnIfNotExists() {
        String checkColumnSQL = "PRAGMA table_info(backpacks)";
        String alterTableSQL = "ALTER TABLE backpacks ADD COLUMN is_open INTEGER DEFAULT 0";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(checkColumnSQL);
             ResultSet rs = statement.executeQuery();){
            boolean columnExists = false;
            while (rs.next()) {
                String columnName = rs.getString("name");
                if (!"is_open".equalsIgnoreCase(columnName)) continue;
                columnExists = true;
                break;
            }
            if (!columnExists) {
                this.executeUpdate(alterTableSQL, new Object[0]);
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Database\u00a78] \u00a72Added missing column \u00a78'\u00a7fis_open\u00a78' \u00a72to database");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Error when modifying table: " + ex.getMessage());
        }
    }

    @Override
    public ConcurrentMap<UUID, PlayerBackpackGuiInfo> loadAllPlayersBackpacks(boolean logs) {
        ConcurrentHashMap<UUID, PlayerBackpackGuiInfo> allPlayersBackpacks = new ConcurrentHashMap<UUID, PlayerBackpackGuiInfo>();
        try (Statement statement = this.getConnection().createStatement();
             ResultSet rs = statement.executeQuery("SELECT backpackOwnerUUID, COUNT(*) AS backpackCount, MAX(last_updated) AS latestUpdate FROM backpacks GROUP BY backpackOwnerUUID ORDER BY latestUpdate DESC");){
            while (rs.next()) {
                UUID playerUniqueId = UUID.fromString(rs.getString("backpackOwnerUUID"));
                Object playerName = OfflinePlayersData.getInstance().getPlayerName(playerUniqueId);
                if (playerName == null || ((String)playerName).isEmpty()) {
                    playerName = "&6Unknown &8| &f" + String.valueOf(playerUniqueId);
                }
                int backpackCount = rs.getInt("backpackCount");
                PlayerBackpackGuiInfo playerBackpackGuiInfo = new PlayerBackpackGuiInfo(playerUniqueId, (String)playerName, backpackCount);
                allPlayersBackpacks.put(playerUniqueId, playerBackpackGuiInfo);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Error loading all database players backpacks: ", ex);
            this.plugin.getLogger().warning(ex.getMessage());
        }
        return allPlayersBackpacks;
    }

    @Override
    public CompletableFuture<ConcurrentMap<UUID, PlayerBackpackGuiInfo>> loadAllPlayersBackpacksAsync(boolean logs) {
        return CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<UUID, PlayerBackpackGuiInfo> allPlayersBackpacks = new ConcurrentHashMap<UUID, PlayerBackpackGuiInfo>();
            try (Statement statement = this.getConnection().createStatement();
                 ResultSet rs = statement.executeQuery("SELECT backpackOwnerUUID, COUNT(*) AS backpackCount, MAX(last_updated) AS latestUpdate FROM backpacks GROUP BY backpackOwnerUUID ORDER BY latestUpdate DESC");){
                while (rs.next()) {
                    UUID playerUniqueId = UUID.fromString(rs.getString("backpackOwnerUUID"));
                    Object playerName = OfflinePlayersData.getInstance().getPlayerName(playerUniqueId);
                    if (playerName == null || ((String)playerName).isEmpty()) {
                        playerName = "&6Unknown &8| &f" + String.valueOf(playerUniqueId);
                    }
                    int backpackCount = rs.getInt("backpackCount");
                    PlayerBackpackGuiInfo playerBackpackGuiInfo = new PlayerBackpackGuiInfo(playerUniqueId, (String)playerName, backpackCount);
                    allPlayersBackpacks.put(playerUniqueId, playerBackpackGuiInfo);
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error loading all database players backpacks: ", ex);
                this.plugin.getLogger().warning(ex.getMessage());
            }
            return allPlayersBackpacks;
        });
    }

    @Override
    public List<DatabaseBackpack> loadPlayerBackpacks(UUID backpackOwnerUniqueId) {
        ArrayList<DatabaseBackpack> playerBackpacks = new ArrayList<DatabaseBackpack>();
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM backpacks WHERE backpackOwnerUUID=? ORDER BY last_updated DESC");){
            statement.setString(1, backpackOwnerUniqueId.toString());
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    String lastPlayerUUIDString = rs.getString("last_player_uuid");
                    UUID lastPlayerUUID = lastPlayerUUIDString != null && !lastPlayerUUIDString.isEmpty() ? UUID.fromString(lastPlayerUUIDString) : null;
                    playerBackpacks.add(new DatabaseBackpack(UUID.fromString(rs.getString("backpackUUID")), UUID.fromString(rs.getString("backpackOwnerUUID")), Utils.extractTier(rs.getString("content")), rs.getTimestamp("last_updated"), lastPlayerUUID));
                }
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Error loading player backpack: " + backpackOwnerUniqueId.toString(), ex);
        }
        return playerBackpacks;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPlayerName(UUID playerUniqueId) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT playerName FROM players WHERE playerUniqueId=?");){
            String string;
            block14: {
                statement.setString(1, playerUniqueId.toString());
                ResultSet resultSet = statement.executeQuery();
                try {
                    String string2 = string = resultSet.next() ? resultSet.getString("playerName") : null;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return string;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting playerName from database", ex);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public UUID getPlayerUniqueId(String playerName) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT playerUniqueId FROM players WHERE playerName=?");){
            UUID uUID;
            block14: {
                statement.setString(1, playerName);
                ResultSet resultSet = statement.executeQuery();
                try {
                    UUID uUID2 = uUID = resultSet.next() ? UUID.fromString(resultSet.getString("playerUniqueId")) : null;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return uUID;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting playerUniqueId from database", ex);
            return null;
        }
    }

    @Override
    public void savePlayer(UUID playerUniqueId, String playerName) {
        if (this.playerExists(playerUniqueId)) {
            return;
        }
        try (PreparedStatement statement = this.getConnection().prepareStatement("INSERT INTO players(playerUniqueId, playerName) VALUES (?, ?)");){
            statement.setString(1, playerUniqueId.toString());
            statement.setString(2, playerName);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error saving player (UUID and name) to database", ex);
        }
    }

    @Override
    public boolean playerExists(UUID playerUniqueId) {
        try {
            return this.objectExists(String.format("SELECT * FROM players WHERE playerUniqueId='%s'", playerUniqueId.toString()));
        }
        catch (SQLException ex) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean playerDeathItemsExists(UUID playerUniqueId) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM deaths_items WHERE playerUniqueId=?");){
            boolean bl;
            block14: {
                statement.setString(1, playerUniqueId.toString());
                ResultSet resultSet = statement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting player death items info from database", ex);
            return false;
        }
    }

    @Override
    public void savePlayerDeathItems(UUID playerUniqueId, String jsonContent) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("INSERT INTO deaths_items(playerUniqueId, content) VALUES (?, ?)");){
            statement.setString(1, playerUniqueId.toString());
            statement.setString(2, jsonContent);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error saving player death items to database", ex);
        }
    }

    @Override
    @Nullable
    public String getPlayerAndDeleteDeathItems(UUID playerUniqueId) {
        String content = null;
        String selectQuery = "SELECT content FROM deaths_items WHERE playerUniqueId=?";
        String deleteQuery = "DELETE FROM deaths_items WHERE playerUniqueId=?";
        try {
            this.connection.setAutoCommit(false);
            Utils.debugLogToConsole(Level.INFO, "Transaction started for player: " + String.valueOf(playerUniqueId));
            try (PreparedStatement selectStatement = this.getConnection().prepareStatement(selectQuery);
                 PreparedStatement deleteStatement = this.getConnection().prepareStatement(deleteQuery);){
                selectStatement.setString(1, playerUniqueId.toString());
                try (ResultSet resultSet = selectStatement.executeQuery();){
                    if (resultSet.next()) {
                        content = resultSet.getString("content");
                        Utils.debugLogToConsole(Level.INFO, "Content found for player: " + String.valueOf(playerUniqueId));
                    }
                }
                if (content != null) {
                    deleteStatement.setString(1, playerUniqueId.toString());
                    deleteStatement.executeUpdate();
                    Utils.debugLogToConsole(Level.INFO, "Content deleted for player: " + String.valueOf(playerUniqueId));
                }
                this.connection.commit();
                Utils.debugLogToConsole(Level.INFO, "Transaction committed for player: " + String.valueOf(playerUniqueId));
            }
            catch (SQLException ex) {
                this.connection.rollback();
                Utils.debugLogToConsole(Level.WARNING, "Transaction rolled back for player: " + String.valueOf(playerUniqueId));
                throw ex;
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting and deleting player death items from database for player: " + String.valueOf(playerUniqueId), ex);
        }
        return content;
    }

    @Override
    public void deletePlayerDeathItems(UUID playerUniqueId) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("DELETE FROM deaths_items WHERE playerUniqueId=?");){
            statement.setString(1, playerUniqueId.toString());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error deleting player death items from database", ex);
        }
    }
}

