/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.gui.backpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import me.ziomalu.api.gui.GUI;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import me.ziomalu.api.gui.button.Button;
import me.ziomalu.api.gui.button.ButtonActionKey;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.crafting.CraftingManager;
import pl.ziomalu.backpackplus.inventoryholders.ChoseCraftingInventoryHolder;
import pl.ziomalu.backpackplus.items.CustomItems;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.Text;

public class BackpacksChoseGUI
extends GUI {
    private static BackpacksChoseGUI instance;
    private final int capacity;
    private static final ButtonActionKey CHOSE_BACKPACK_KEY;

    public BackpacksChoseGUI() {
        instance = this;
        this.capacity = BackpackManager.getInstance().getBackpackSettings().size();
        this.setMaxCapacity(this.capacity);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BackpackPlus.getInstance(), () -> {
            this.createEmptyPages();
            this.fillInTheExcess(CustomItems.getOverfillStack());
            this.addButtonsIfNeed();
            this.addBackpacksButtons();
        });
    }

    private void createEmptyPages() {
        String title = LanguageManager.getInstance().getString("gui.backpack-chose-crafting-gui.title");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.createPages(this.capacity, title, variables, (pageIndex, requirePageSize, pageTitle) -> {
            Page page = new Page(new ChoseCraftingInventoryHolder(this, pageIndex), pageIndex, requirePageSize, Text.setColour(pageTitle));
            this.setPage(page);
        });
    }

    private void addBackpacksButtons() {
        if (BackpackManager.getInstance().getBackpackSettings().isEmpty()) {
            return;
        }
        int currentSlot = 0;
        int currentPageIndex = 0;
        for (final BackpackSettings backpackSettings : BackpackManager.getInstance().getBackpackSettings()) {
            Page page;
            if (currentPageIndex > this.pages.size()) break;
            ItemStack backpackStack = backpackSettings.getBackpackStack().clone();
            ItemMeta meta = backpackStack.getItemMeta();
            if (meta != null) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("isCraftable", backpackSettings.getData().isCanBeCrafted());
                ArrayList<String> lore = new ArrayList<String>();
                List<String> langLore = LanguageManager.getInstance().getStringList("gui.backpack-chose-crafting-gui.buttons.select-backpack-button.lore");
                for (String str : langLore) {
                    lore.add(Text.setColour(StringParser.parseString(str, variables)));
                }
                meta.setLore(lore);
                backpackStack.setItemMeta(meta);
            }
            if ((page = this.getPage(currentPageIndex)) == null) {
                return;
            }
            Inventory inventory = page.getInventory();
            ItemStack invSlotStack = inventory.getItem(currentSlot);
            if (BasicGuiItems.getInstance().isGuiItem(invSlotStack) || BasicGuiItems.getInstance().isPageButtonItem(invSlotStack)) {
                ++currentPageIndex;
            }
            inventory.setItem(currentSlot, backpackStack);
            page.addButton(new Button(page, currentSlot, CHOSE_BACKPACK_KEY, backpackStack, backpackSettings, new ClickType[]{ClickType.LEFT}){

                @Override
                public void onButtonClick(Page page, Player player, Event event) {
                    this.getOnClickSound().setPitch(1.0f);
                    this.getOnClickSound().playSound(player);
                    if (!backpackSettings.getData().isCanBeCrafted()) {
                        player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
                        return;
                    }
                    Inventory editorInventory = backpackSettings.getEditCraftingPage().getInventory();
                    player.openInventory(editorInventory);
                    CraftingManager.getInstance().addCraftingEditor(player.getUniqueId(), editorInventory);
                }
            });
            ++currentSlot;
        }
    }

    @Generated
    public static BackpacksChoseGUI getInstance() {
        return instance;
    }

    static {
        CHOSE_BACKPACK_KEY = new ButtonActionKey("chose_backpack");
    }
}

