/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.gui.backpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import me.ziomalu.api.gui.GUI;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import me.ziomalu.api.gui.button.Button;
import me.ziomalu.api.gui.button.ButtonActionKey;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.DatabaseBackpack;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.enums.State;
import pl.ziomalu.backpackplus.events.PreBackpackOpenEvent;
import pl.ziomalu.backpackplus.inventoryholders.ViewPlayerBackpacksInventoryHolder;
import pl.ziomalu.backpackplus.items.CustomItems;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.utils.OfflinePlayersData;
import pl.ziomalu.backpackplus.utils.Text;

public class PlayerBackpacksGUI
extends GUI {
    private List<DatabaseBackpack> playerBackpacks;
    private final UUID playerUniqueId;
    private State creationState = State.LOADING;
    private long lastUse;
    private static final ButtonActionKey CLICK_TO_VIEW = new ButtonActionKey("click_to_view");
    private static final ButtonActionKey CLICK_TO_GIVE = new ButtonActionKey("click_to_give");

    public PlayerBackpacksGUI(UUID playerUniqueId) {
        this.playerUniqueId = playerUniqueId;
        this.playerBackpacks = new ArrayList<DatabaseBackpack>();
        this.loadBackpacks();
        if (!this.hasBackpacks()) {
            this.creationState = State.LOADED;
            return;
        }
        this.setMaxCapacity(this.playerBackpacks.size());
        CompletableFuture.runAsync(() -> {
            this.createPages();
            this.addButtonsIfNeed(CustomItems.getFillingStack(), CustomItems.getPagePreviousStack(), CustomItems.getPageNextStack(), new Sound[0]);
            this.fillInTheExcess(CustomItems.getOverfillStack());
            this.loadBackpackToPages();
        }).thenRunAsync(() -> {
            this.creationState = State.LOADED;
            this.updateLastUse();
        });
    }

    public void load() {
        this.pages.clear();
        this.loadBackpacks();
        if (!this.hasBackpacks()) {
            this.creationState = State.LOADED;
        }
        this.setMaxCapacity(this.playerBackpacks.size());
        CompletableFuture.runAsync(() -> {
            try {
                this.createPages();
                if (this.pages.size() > 1) {
                    this.addButtonsIfNeed(CustomItems.getFillingStack(), CustomItems.getPagePreviousStack(), CustomItems.getPageNextStack(), new Sound[0]);
                }
                this.loadBackpackToPages();
                this.fillInTheExcess(CustomItems.getOverfillStack());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).thenRunAsync(() -> {
            this.creationState = State.LOADED;
        });
        this.updateLastUse();
    }

    public void updateLastUse() {
        this.lastUse = System.currentTimeMillis();
    }

    public boolean hasBackpacks() {
        return !this.playerBackpacks.isEmpty();
    }

    public boolean isLoaded() {
        return this.creationState == State.LOADED;
    }

    private void createPages() {
        String offlinePlayerName = OfflinePlayersData.getInstance().getPlayerName(this.playerUniqueId);
        String playerName = offlinePlayerName == null ? this.playerUniqueId.toString() : offlinePlayerName;
        String title = LanguageManager.getInstance().getString("gui.player-backpacks-gui.title");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("playerName", playerName);
        this.createPages(this.getMaxCapacity(), title, variables, (pageIndex, requirePageSize, pageTitle) -> {
            Page page = new Page(new ViewPlayerBackpacksInventoryHolder(this.playerUniqueId, pageIndex, this), pageIndex, requirePageSize, Text.setColour(pageTitle));
            this.setPage(page);
        });
    }

    public void loadBackpackToPages() {
        if (this.playerBackpacks.isEmpty()) {
            return;
        }
        int currentSlot = 0;
        int currentPageIndex = 0;
        for (final DatabaseBackpack databaseBackpack : this.playerBackpacks) {
            if (currentPageIndex > this.pages.size()) break;
            ItemStack backpackStack = databaseBackpack.getViewItemStack();
            Page page = this.getPage(currentPageIndex);
            if (page == null) {
                return;
            }
            Inventory inventory = page.getInventory();
            ItemStack invSlotStack = inventory.getItem(currentSlot);
            if (BasicGuiItems.getInstance().isGuiItem(invSlotStack) || BasicGuiItems.getInstance().isPageButtonItem(invSlotStack)) {
                currentSlot = 0;
                if ((page = this.getPage(++currentPageIndex)) == null) {
                    return;
                }
                inventory = page.getInventory();
            }
            inventory.setItem(currentSlot, backpackStack);
            page.addButton(new Button(page, currentSlot, CLICK_TO_VIEW, backpackStack, databaseBackpack, new ClickType[]{ClickType.LEFT}){

                @Override
                public void onButtonClick(Page page, Player player, Event event) {
                    if (!databaseBackpack.isHasSettings()) {
                        return;
                    }
                    PlayerBackpacksGUI.this.updateLastUse();
                    this.getOnClickSound().setPitch(1.0f);
                    this.getOnClickSound().playSound(player);
                    PreBackpackOpenEvent preBackpackOpenEvent = new PreBackpackOpenEvent(databaseBackpack.getBackpackUniqueId(), databaseBackpack.getBackpackTier(), null, player, true);
                    Bukkit.getPluginManager().callEvent((Event)preBackpackOpenEvent);
                    if (!preBackpackOpenEvent.isCancelled() && preBackpackOpenEvent.getBackpack() != null) {
                        preBackpackOpenEvent.getBackpack().addInspector(player.getUniqueId());
                    }
                }
            });
            page.addButton(new Button(page, currentSlot, CLICK_TO_GIVE, backpackStack, databaseBackpack, new ClickType[]{ClickType.SHIFT_RIGHT}){

                @Override
                public void onButtonClick(Page page, Player player, Event event) {
                    if (!databaseBackpack.isHasSettings()) {
                        return;
                    }
                    PlayerBackpacksGUI.this.updateLastUse();
                    this.getOnClickSound().setPitch(1.0f);
                    this.getOnClickSound().playSound(player);
                    player.getInventory().addItem(new ItemStack[]{databaseBackpack.getBackpackStack().clone()});
                    String message = LanguageManager.getInstance().getString("backpack-added-inventory");
                    message = message.replace("%player%", databaseBackpack.getOwnerName() == null ? databaseBackpack.getBackpackOwnerUniqueId().toString() : databaseBackpack.getOwnerName());
                    List<String> langHoverList = LanguageManager.getInstance().getStringList("gui.player-backpacks-gui.hover-text");
                    ArrayList<String> hoverList = new ArrayList<String>();
                    HashMap<String, Object> variables = new HashMap<String, Object>();
                    variables.put("owner", databaseBackpack.getOwnerName() == null ? databaseBackpack.getBackpackUniqueId().toString() : databaseBackpack.getOwnerName());
                    variables.put("lastUpdated", BackpackPlus.DATE_FORMAT.format(databaseBackpack.getLastUpdated()));
                    variables.put("lastPlayer", databaseBackpack.getLastPlayer());
                    variables.put("backpackUUID", databaseBackpack.getBackpackUniqueId().toString());
                    for (String str : langHoverList) {
                        hoverList.add(Text.setColour(StringParser.parseString(str, variables)));
                    }
                    TextComponent textComponent = new TextComponent(Text.setColour(message));
                    textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new net.md_5.bungee.api.chat.hover.content.Text(String.join((CharSequence)"\n", hoverList))}));
                    player.spigot().sendMessage((BaseComponent)textComponent);
                }
            });
            ++currentSlot;
        }
    }

    private void loadBackpacks() {
        this.playerBackpacks = DatabaseManager.getInstance().getDatabase().loadPlayerBackpacks(this.playerUniqueId);
    }

    @Generated
    public List<DatabaseBackpack> getPlayerBackpacks() {
        return this.playerBackpacks;
    }

    @Generated
    public UUID getPlayerUniqueId() {
        return this.playerUniqueId;
    }

    @Generated
    public State getCreationState() {
        return this.creationState;
    }

    @Generated
    public long getLastUse() {
        return this.lastUse;
    }
}

