/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.gui.backpack.backpacksgui;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import me.ziomalu.api.gui.GUI;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import me.ziomalu.api.gui.button.Button;
import me.ziomalu.api.gui.button.ButtonActionKey;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.enums.State;
import pl.ziomalu.backpackplus.gui.backpack.backpacksgui.PlayerBackpackGuiInfo;
import pl.ziomalu.backpackplus.inventoryholders.ViewPlayersBackpacksInventoryHolder;
import pl.ziomalu.backpackplus.items.CustomItems;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.utils.Text;

public final class AllBackpacksGUI
extends GUI {
    private ConcurrentMap<UUID, PlayerBackpackGuiInfo> playersBackpack;
    private static AllBackpacksGUI instance;
    private State creationState = State.UNKNOWN;
    private static final ButtonActionKey CLICK_TO_OPEN;
    private long lastUsed;
    private boolean loaded = false;

    public boolean hasPlayers() {
        return !this.playersBackpack.isEmpty();
    }

    public void updateUse() {
        this.lastUsed = System.currentTimeMillis();
    }

    public AllBackpacksGUI() {
        instance = this;
        this.playersBackpack = new ConcurrentHashMap<UUID, PlayerBackpackGuiInfo>();
        this.creationState = State.LOADING;
        this.load();
        this.updateUse();
    }

    public void unload() {
        this.playersBackpack.clear();
        this.pages.clear();
    }

    public void load() {
        this.pages.clear();
        this.creationState = State.LOADING;
        DatabaseManager.getInstance().getDatabase().loadAllPlayersBackpacksAsync(true).thenAccept(loadedBackpacks -> {
            if (loadedBackpacks == null || loadedBackpacks.isEmpty()) {
                this.creationState = State.LOADED;
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> {
                this.playersBackpack = loadedBackpacks;
                this.setMaxCapacity(this.playersBackpack.size());
                this.createGuiPages();
                this.addButtonsIfNeed();
                this.setContent();
                this.fillInTheExcess(CustomItems.getOverfillStack());
                this.creationState = State.LOADED;
                this.updateUse();
            });
        });
    }

    private void createGuiPages() {
        String langTitle = LanguageManager.getInstance().getString("gui.all-backpack-gui.title");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("size", this.playersBackpack.size());
        String title = StringParser.parseString(langTitle, variables);
        this.createPages(this.getMaxCapacity(), title, variables, (pageIndex, requirePageSize, pageTitle) -> {
            Page page = new Page(new ViewPlayersBackpacksInventoryHolder(pageIndex, this), pageIndex, requirePageSize, Text.setColour(pageTitle));
            this.setPage(page);
        });
    }

    private void setContent() {
        if (this.playersBackpack.isEmpty()) {
            return;
        }
        int currentSlot = 0;
        int currentPageIndex = 0;
        for (final PlayerBackpackGuiInfo playerBackpackGuiInfo : this.playersBackpack.values()) {
            if (currentPageIndex >= this.pages.size()) break;
            Page page = this.getPage(currentPageIndex);
            if (page == null) {
                return;
            }
            Inventory inventory = page.getInventory();
            ItemStack invSlotStack = inventory.getItem(currentSlot);
            if (BasicGuiItems.getInstance().isGuiItem(invSlotStack) || BasicGuiItems.getInstance().isPageButtonItem(invSlotStack)) {
                currentSlot = 0;
                if ((page = this.getPage(++currentPageIndex)) == null) {
                    return;
                }
                inventory = page.getInventory();
            }
            Button button = new Button(page, currentSlot, CLICK_TO_OPEN, playerBackpackGuiInfo.getPlayerSkull().clone(), new ClickType[]{ClickType.LEFT}){

                @Override
                public void onButtonClick(Page page, Player player, Event event) {
                    this.getOnClickSound().playSound(player);
                    BackpackManager.getInstance().openPlayerBackpackByUniqueId(player, playerBackpackGuiInfo.getPlayerUniqueId());
                    AllBackpacksGUI.this.updateUse();
                }
            };
            playerBackpackGuiInfo.setButton(button);
            page.addButton(button);
            ++currentSlot;
        }
    }

    private void loadAllPlayersBackpacks() {
        DatabaseManager.getInstance().getDatabase().loadAllPlayersBackpacksAsync(true).thenAccept(loadedBackpacks -> {
            if (loadedBackpacks == null || loadedBackpacks.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> {
                this.playersBackpack = loadedBackpacks;
                this.loaded = true;
            });
        });
    }

    @Generated
    public static AllBackpacksGUI getInstance() {
        return instance;
    }

    @Generated
    public State getCreationState() {
        return this.creationState;
    }

    @Generated
    public long getLastUsed() {
        return this.lastUsed;
    }

    static {
        CLICK_TO_OPEN = new ButtonActionKey("click_to_open");
    }
}

