/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.gui.backpack.backpacksgui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.cache.CacheKeyManager;
import me.ziomalu.api.gui.button.Button;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class PlayerBackpackGuiInfo {
    private final UUID playerUniqueId;
    private final String playerName;
    private int backpackAmount;
    private ItemStack playerSkull;
    private Button button;

    public PlayerBackpackGuiInfo(UUID playerUniqueId, String playerName, int backpackAmount) {
        this.playerUniqueId = playerUniqueId;
        this.playerName = playerName;
        this.backpackAmount = backpackAmount;
        this.playerSkull = new ItemStack(Material.PLAYER_HEAD);
        this.initializePlayerSkullAsync();
    }

    private void initializePlayerSkullAsync() {
        ItemStack cachedSkull = (ItemStack)Cache.get(CacheKeyManager.playerSkull(this.playerUniqueId));
        if (cachedSkull != null) {
            this.playerSkull = cachedSkull;
            Utils.debugLogToConsole("Player skull found in cache for " + this.playerName);
            this.updateMeta();
            return;
        }
        this.playerSkull = Utils.getPlayerHead(Bukkit.getOfflinePlayer((UUID)this.playerUniqueId));
        this.updateMeta();
        Cache.put(CacheKeyManager.playerSkull(this.playerUniqueId), this.playerSkull);
        Utils.debugLogToConsole("Player skull created for " + this.playerName);
        Optional.ofNullable(this.button).ifPresent(button -> button.updateButtonIcon(this.playerSkull));
    }

    public void addOneToBackpackAmount() {
        ++this.backpackAmount;
        this.updateMeta();
    }

    private void updateMeta() {
        Optional.ofNullable(this.getSkullMeta()).ifPresent(meta -> this.playerSkull.setItemMeta((ItemMeta)meta));
    }

    private SkullMeta getSkullMeta() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("playerName", this.playerName);
        variables.put("amount", this.backpackAmount);
        String langDisplayName = LanguageManager.getInstance().getString("gui.player-backpack-gui-info.displayName");
        String displayName = StringParser.parseString(langDisplayName, variables);
        ArrayList<String> lore = new ArrayList<String>();
        List<String> langLore = LanguageManager.getInstance().getStringList("gui.player-backpack-gui-info.lore");
        for (String str : langLore) {
            lore.add(Text.setColour(StringParser.parseString(str, variables)));
        }
        return Optional.ofNullable((SkullMeta)this.playerSkull.getItemMeta()).map(skullMeta -> {
            skullMeta.setDisplayName(Text.setColour(displayName));
            skullMeta.setLore(lore);
            return skullMeta;
        }).orElseGet(() -> {
            Utils.debugLogToConsole(Level.WARNING, "Failed to update meta: ItemMeta is null");
            return null;
        });
    }

    @Generated
    public UUID getPlayerUniqueId() {
        return this.playerUniqueId;
    }

    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @Generated
    public int getBackpackAmount() {
        return this.backpackAmount;
    }

    @Generated
    public ItemStack getPlayerSkull() {
        return this.playerSkull;
    }

    @Generated
    public void setButton(Button button) {
        this.button = button;
    }
}

