/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.gui.backpack.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.ziomalu.api.gui.GUI;
import me.ziomalu.api.gui.Page;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.inventoryholders.BackpackAllowedItemsInventoryHolder;
import pl.ziomalu.backpackplus.items.Item;
import pl.ziomalu.backpackplus.items.NBTItem;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class AllowedItemsGUI
extends GUI {
    private final BackpackSettings settings;

    public AllowedItemsGUI(BackpackSettings backpackSettings) {
        this.settings = backpackSettings;
        this.initialize();
    }

    private void initialize() {
        this.setMaxCapacity(this.settings.getData().getAllowedItems().size() + 1);
        String allowedItemsGuiTitle = LanguageManager.getInstance().getString("gui.allowed-items-gui");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("size", this.settings.getData().getAllowedItems().size() + this.settings.getData().getAllowedNbt().size());
        variables.put("tier", this.settings.getData().getTier());
        this.createPages(this.getMaxCapacity(), allowedItemsGuiTitle, variables, (pageIndex, requirePageSize, pageTitle) -> {
            Page page = new Page(new BackpackAllowedItemsInventoryHolder(this, pageIndex, this.settings), pageIndex, requirePageSize, Text.setColour(pageTitle));
            this.setPage(page);
        });
        this.addButtonsIfNeed();
        this.setContent();
    }

    public void update() {
        this.pages.clear();
        this.initialize();
        this.setContent();
    }

    private void setContent() {
        int globalItemIndex = 0;
        int totalItems = this.settings.getData().getAllowedNbt().size() + this.settings.getData().getAllowedItems().size();
        for (Page page : this.pages.values()) {
            for (int slot = 0; slot < page.getInventory().getSize(); ++slot) {
                ItemStack currentStack = page.getInventory().getItem(slot);
                if (Utils.isGuiOrPageButtonItem(currentStack)) continue;
                if (globalItemIndex >= totalItems) break;
                ItemStack itemToSet = null;
                if (globalItemIndex < this.settings.getData().getAllowedNbt().size()) {
                    NBTItem nbtItem = this.settings.getData().getAllowedNbt().get(globalItemIndex);
                    if (nbtItem != null) {
                        itemToSet = nbtItem.toItemStack();
                    }
                } else {
                    Item allowedItem;
                    int allowedItemIndex = globalItemIndex - this.settings.getData().getAllowedNbt().size();
                    if (allowedItemIndex < this.settings.getData().getAllowedItems().size() && (allowedItem = this.settings.getData().getAllowedItems().get(allowedItemIndex)) != null) {
                        Object object = allowedItem.getObjectOfItem();
                        if (object instanceof ItemStack) {
                            itemToSet = (ItemStack)object;
                        } else if (object instanceof Material) {
                            itemToSet = new ItemStack((Material)object);
                        }
                    }
                }
                if (itemToSet == null) continue;
                page.getInventory().setItem(slot, itemToSet);
                ++globalItemIndex;
            }
            if (globalItemIndex < totalItems) continue;
            break;
        }
    }

    private int fillWithNbtItems(Page page, int startSlot) {
        int slot = startSlot;
        int nbtIndex = 0;
        while (nbtIndex < this.settings.getData().getAllowedNbt().size() && slot < page.getInventory().getSize()) {
            ItemStack currentStack = page.getInventory().getItem(slot);
            if (Utils.isGuiOrPageButtonItem(currentStack)) {
                ++slot;
                continue;
            }
            NBTItem nbtItem = this.settings.getData().getAllowedNbt().get(nbtIndex);
            if (nbtItem != null) {
                ItemStack itemStack = nbtItem.toItemStack();
                page.getInventory().setItem(slot, itemStack);
            }
            ++nbtIndex;
            ++slot;
        }
        return slot;
    }

    private int fillWithAllowedItems(Page page, int startSlot) {
        int slot = startSlot;
        int allowedIndex = 0;
        while (allowedIndex < this.settings.getData().getAllowedItems().size() && slot < page.getInventory().getSize()) {
            ItemStack currentStack = page.getInventory().getItem(slot);
            if (Utils.isGuiOrPageButtonItem(currentStack)) {
                ++slot;
                continue;
            }
            Item allowedItem = this.settings.getData().getAllowedItems().get(allowedIndex);
            if (allowedItem != null) {
                Object object = allowedItem.getObjectOfItem();
                ItemStack itemStack = object instanceof ItemStack ? (ItemStack)object : new ItemStack((Material)Objects.requireNonNull(object));
                page.getInventory().setItem(slot, itemStack);
            }
            ++allowedIndex;
            ++slot;
        }
        return slot;
    }

    private List<Item> getItemsFromPages() {
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<String> itemsNames = new ArrayList<String>();
        for (Page page : this.pages.values()) {
            Inventory pageInventory = page.getInventory();
            if (pageInventory == null) continue;
            for (int slot = 0; slot < pageInventory.getSize(); ++slot) {
                Item item;
                ItemStack slotStack = pageInventory.getItem(slot);
                if (slotStack == null || Utils.isGuiOrPageButtonItem(slotStack)) continue;
                slotStack.setAmount(1);
                if (NBTItem.isNBTItem(slotStack) || itemsNames.contains((item = new Item(slotStack)).toString())) continue;
                itemsNames.add(item.toString());
                items.add(item);
            }
        }
        return items;
    }

    private List<NBTItem> getNBTItemsFromPages() {
        ArrayList<NBTItem> items = new ArrayList<NBTItem>();
        ArrayList<String> itemsNames = new ArrayList<String>();
        for (Page page : this.pages.values()) {
            Inventory pageInventory = page.getInventory();
            if (pageInventory == null) continue;
            for (int slot = 0; slot < pageInventory.getSize(); ++slot) {
                String nbtString;
                ItemStack slotStack = pageInventory.getItem(slot);
                if (slotStack == null || Utils.isGuiOrPageButtonItem(slotStack)) continue;
                slotStack.setAmount(1);
                if (!NBTItem.isNBTItem(slotStack) || (nbtString = NBTItem.getNBTString(slotStack)) == null || itemsNames.contains(nbtString)) continue;
                itemsNames.add(nbtString);
                items.add(NBTItem.parseNBTItem(nbtString));
            }
        }
        return items;
    }

    public void save() {
        List<Item> items = this.getItemsFromPages();
        List<NBTItem> nbtItems = this.getNBTItemsFromPages();
        ArrayList newAllowedNBTItems = new ArrayList();
        nbtItems.forEach(item -> newAllowedNBTItems.add(item.toString()));
        ArrayList newAllowedItems = new ArrayList();
        items.forEach(item -> newAllowedItems.add(item.toString()));
        if (items.equals(this.settings.getData().getAllowedItems()) && nbtItems.equals(this.settings.getData().getAllowedNbt())) {
            return;
        }
        this.settings.getData().setAllowedItems(items);
        this.settings.getData().setAllowedNbt(nbtItems);
        ArrayList newContentList = new ArrayList();
        newContentList.addAll(newAllowedNBTItems);
        newContentList.addAll(newAllowedItems);
        BackpackPlus.getInstance().getConfig().set("backpack-tiers." + this.settings.getData().getTier() + ".allowed-items", newContentList);
        BackpackPlus.getInstance().saveConfig();
    }
}

