/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.gui.backpack.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import lombok.Generated;
import me.ziomalu.api.cooldowns.Cooldown;
import me.ziomalu.api.gui.GUI;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.button.Button;
import me.ziomalu.api.gui.button.ButtonActionKey;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.crafting.CraftingManager;
import pl.ziomalu.backpackplus.enums.BackpackType;
import pl.ziomalu.backpackplus.inventoryholders.BackpackSettingsInventoryHolder;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.Text;

public class BackpackSettingsMainGUI
extends GUI {
    private final List<UUID> allowedItemsEditors;
    private final BackpackSettings settings;
    private final Page page;
    private static final ButtonActionKey CHANGE_CRAFTING_SETTINGS_KEY = new ButtonActionKey("change_backpack_crafting");
    private static final ButtonActionKey CHANGE_ABILITY_CRAFTING_SETTINGS_KEY = new ButtonActionKey("change_ability_backpack_crafting");
    private static final ButtonActionKey ALLOWED_ITEMS_SETTINGS_KEY = new ButtonActionKey("allowed_items_crafting");
    private static final ButtonActionKey CHANGE_TYPE_SETTINGS_KEY = new ButtonActionKey("change_type_crafting");

    public boolean hasEditors() {
        return this.allowedItemsEditors != null && !this.allowedItemsEditors.isEmpty();
    }

    public void addEditor(UUID playerUniqueId) {
        this.allowedItemsEditors.add(playerUniqueId);
    }

    public void removeEditor(UUID playerUniqueId) {
        this.allowedItemsEditors.remove(playerUniqueId);
    }

    public boolean editorIsOnline() {
        if (!this.hasEditors()) {
            return false;
        }
        try {
            Optional editorUniqueIdOpt = this.allowedItemsEditors.stream().findFirst();
            if (editorUniqueIdOpt.isEmpty()) {
                return false;
            }
            Player player = Bukkit.getPlayer((UUID)((UUID)editorUniqueIdOpt.get()));
            return player != null && player.isOnline();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean playerIsEditor(UUID playerUniqueId) {
        return this.allowedItemsEditors != null && this.allowedItemsEditors.contains(playerUniqueId);
    }

    public BackpackSettingsMainGUI(BackpackSettings settings) {
        this.settings = settings;
        this.allowedItemsEditors = new ArrayList<UUID>();
        this.setMaxCapacity(27);
        String title = LanguageManager.getInstance().getString("gui.backpack-settings-main.title");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("tier", settings.getData().getTier());
        this.page = new Page(new BackpackSettingsInventoryHolder(this), 0, 27, Text.setColour(StringParser.parseString(title, variables)));
        this.createButtons();
    }

    private ItemMeta getEditCraftingButtonMeta(ItemStack craftingButtonStack) {
        ItemMeta meta = craftingButtonStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        String displayName = LanguageManager.getInstance().getString("gui.backpack-settings-main.buttons.edit-crafting-button.display-name");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("isCraftable", this.settings.getData().isCanBeCrafted());
        List<String> langListLore = LanguageManager.getInstance().getStringList("gui.backpack-settings-main.buttons.edit-crafting-button.lore");
        for (String string : langListLore) {
            lore.add(Text.setColour(StringParser.parseString(string, variables)));
        }
        meta.setDisplayName(Text.setColour(displayName));
        meta.setLore(lore);
        return meta;
    }

    private ItemMeta getAllowedItemsButtonMeta(ItemStack allowedItemsButtonStack) {
        ItemMeta meta = allowedItemsButtonStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        String displayName = LanguageManager.getInstance().getString("gui.backpack-settings-main.buttons.allowed-items-button.display-name");
        meta.setDisplayName(Text.setColour(displayName));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("isCraftable", this.settings.getData().isCanBeCrafted());
        variables.put("size", this.settings.getData().getAllowedItems().size() + this.settings.getData().getAllowedNbt().size());
        List<String> langListLore = LanguageManager.getInstance().getStringList("gui.backpack-settings-main.buttons.allowed-items-button.lore");
        for (String string : langListLore) {
            lore.add(Text.setColour(StringParser.parseString(string, variables)));
        }
        meta.setLore(lore);
        return meta;
    }

    private ItemMeta getChangeBackpackTypeButtonMeta(ItemStack changeTypeButtonStack) {
        ItemMeta meta = changeTypeButtonStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        String displayName = LanguageManager.getInstance().getString("gui.backpack-settings-main.buttons.change-backpack-type-button.display-name");
        meta.setDisplayName(Text.setColour(displayName));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("isCraftable", this.settings.getData().isCanBeCrafted());
        variables.put("type", this.settings.getData().getBackpackType().name());
        List<String> langListLore = LanguageManager.getInstance().getStringList("gui.backpack-settings-main.buttons.change-backpack-type-button.lore");
        for (String string : langListLore) {
            lore.add(Text.setColour(StringParser.parseString(string, variables)));
        }
        meta.setLore(lore);
        meta.addItemFlags(ItemFlag.values());
        return meta;
    }

    public void updateButtons() {
        this.createButtons();
    }

    private void createButtons() {
        ItemStack allowedItemsStack = new ItemStack(Material.BARREL);
        allowedItemsStack.setItemMeta(this.getAllowedItemsButtonMeta(allowedItemsStack));
        Button editAllowedItemsButton = this.getAllowedItemsButton(allowedItemsStack);
        this.page.setButton(editAllowedItemsButton.getButtonSlot(), true, editAllowedItemsButton);
        ItemStack editCraftingStack = new ItemStack(Material.CRAFTING_TABLE);
        editCraftingStack.setItemMeta(this.getEditCraftingButtonMeta(editCraftingStack));
        Button changeAbilityCraftingButton = this.getChangeAbilityCraftingButton(editCraftingStack);
        Button changeCraftingRecipeButton = this.getEditCraftingRecipeButton(editCraftingStack);
        this.page.setButton(changeAbilityCraftingButton.getButtonSlot(), true, changeAbilityCraftingButton, changeCraftingRecipeButton);
        ItemStack changeBackpackTypeStack = new ItemStack(Material.FLOWER_BANNER_PATTERN);
        changeBackpackTypeStack.setItemMeta(this.getChangeBackpackTypeButtonMeta(changeBackpackTypeStack));
        Button changeBackpackTypeButton = this.getChangeBackpackTypeButton(changeBackpackTypeStack);
        this.page.setButton(changeBackpackTypeButton.getButtonSlot(), true, changeBackpackTypeButton);
    }

    @NotNull
    private Button getChangeAbilityCraftingButton(final ItemStack editCraftingStack) {
        final Button changeAbilityCraftingButton = new Button(this.page, 13, CHANGE_ABILITY_CRAFTING_SETTINGS_KEY, editCraftingStack, new ClickType[]{ClickType.SHIFT_RIGHT}){

            @Override
            public void onButtonClick(Page page, Player player, Event event) {
                if (this.hasCooldown() && !this.isAvailableClick()) {
                    player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
                    String text = LanguageManager.getInstance().getString("button-cooldown");
                    text = text.replace("%time%", String.valueOf(this.getCooldown().isRunning() ? Integer.valueOf(this.getCooldown().getRemainingTime()) : "0"));
                    Text.sendPlayerMessage(player, text);
                    return;
                }
                this.getOnClickSound().playSound(player);
                boolean canBeCrafted = !BackpackSettingsMainGUI.this.settings.getData().isCanBeCrafted();
                BackpackSettingsMainGUI.this.settings.getData().setCanBeCrafted(canBeCrafted);
                BackpackPlus.getInstance().getConfig().set("backpack-tiers." + BackpackSettingsMainGUI.this.settings.getData().getTier() + ".can-be-crafted", (Object)canBeCrafted);
                BackpackPlus.getInstance().saveConfig();
                editCraftingStack.setItemMeta(BackpackSettingsMainGUI.this.getEditCraftingButtonMeta(editCraftingStack));
                this.updateButtonIcon(editCraftingStack);
                if (this.hasCooldown()) {
                    this.getCooldown().start();
                }
            }
        };
        changeAbilityCraftingButton.setCooldown(new Cooldown(5){

            @Override
            protected void onStart() {
                super.onStart();
                changeAbilityCraftingButton.setAvailableClick(false);
            }

            @Override
            public void onFinish() {
                changeAbilityCraftingButton.setAvailableClick(true);
            }
        });
        return changeAbilityCraftingButton;
    }

    @NotNull
    private Button getEditCraftingRecipeButton(ItemStack editCraftingStack) {
        return new Button(this.page, 13, CHANGE_CRAFTING_SETTINGS_KEY, editCraftingStack, new ClickType[]{ClickType.LEFT}){

            @Override
            public void onButtonClick(Page page1, Player player, Event event) {
                this.getOnClickSound().setPitch(1.0f);
                this.getOnClickSound().playSound(player);
                if (!BackpackSettingsMainGUI.this.settings.getData().isCanBeCrafted()) {
                    player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
                    return;
                }
                Inventory editorInventory = BackpackSettingsMainGUI.this.settings.getEditCraftingPage().getInventory();
                player.openInventory(editorInventory);
                CraftingManager.getInstance().addCraftingEditor(player.getUniqueId(), editorInventory);
            }
        };
    }

    @NotNull
    private Button getAllowedItemsButton(ItemStack allowedItemsStack) {
        final Button editAllowedItemsButton = new Button(this.page, 11, ALLOWED_ITEMS_SETTINGS_KEY, allowedItemsStack, new ClickType[]{ClickType.LEFT}){

            @Override
            public void onButtonClick(Page page, Player player, Event event) {
                if (!this.isAvailableClick() && this.hasCooldown()) {
                    player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
                    String text = LanguageManager.getInstance().getString("button-cooldown");
                    text = text.replace("%time%", String.valueOf(this.getCooldown().isRunning() ? Integer.valueOf(this.getCooldown().getRemainingTime()) : "0"));
                    Text.sendPlayerMessage(player, text);
                    return;
                }
                if (BackpackSettingsMainGUI.this.hasEditors() && !BackpackSettingsMainGUI.this.playerIsEditor(player.getUniqueId())) {
                    player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
                    Text.sendPlayerMessage(player, LanguageManager.getInstance().getString("allowed-items-gui-has-editor"));
                    return;
                }
                this.getOnClickSound().playSound(player);
                BackpackSettingsMainGUI.this.settings.getAllowedItemsGUI().update();
                Page firstPageAllowedItems = BackpackSettingsMainGUI.this.settings.getAllowedItemsGUI().getFirstPage();
                if (firstPageAllowedItems == null) {
                    Text.sendPlayerMessage(player, LanguageManager.getInstance().getString("allowed-items-could-open"));
                    return;
                }
                Inventory inventory = firstPageAllowedItems.getInventory();
                player.openInventory(inventory);
                BackpackSettingsMainGUI.this.addEditor(player.getUniqueId());
                if (this.hasCooldown()) {
                    this.getCooldown().start();
                }
            }
        };
        editAllowedItemsButton.setCooldown(new Cooldown(10){

            @Override
            protected void onStart() {
                super.onStart();
                editAllowedItemsButton.setAvailableClick(false);
            }

            @Override
            public void onFinish() {
                editAllowedItemsButton.setAvailableClick(true);
            }
        });
        return editAllowedItemsButton;
    }

    @NotNull
    private Button getChangeBackpackTypeButton(final ItemStack changeBackpackTypeStack) {
        final Button changeBackpackTypeButton = new Button(this.page, 15, CHANGE_TYPE_SETTINGS_KEY, changeBackpackTypeStack, new ClickType[]{ClickType.LEFT}){

            @Override
            public void onButtonClick(Page page, Player player, Event event) {
                if (this.hasCooldown() && !this.isAvailableClick()) {
                    player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
                    String text = LanguageManager.getInstance().getString("button-cooldown");
                    text = text.replace("%time%", String.valueOf(this.getCooldown().isRunning() ? Integer.valueOf(this.getCooldown().getRemainingTime()) : "0"));
                    Text.sendPlayerMessage(player, text);
                    return;
                }
                this.getOnClickSound().setPitch(1.0f);
                this.getOnClickSound().playSound(player);
                BackpackType[] types = BackpackType.values();
                int currentIndex = IntStream.range(0, types.length).filter(i -> types[i] == BackpackSettingsMainGUI.this.settings.getData().getBackpackType()).findFirst().orElse(-1);
                int nextIndex = (currentIndex + 1) % types.length;
                BackpackType nextType = types[nextIndex];
                BackpackSettingsMainGUI.this.settings.getData().setBackpackType(nextType);
                BackpackPlus.getInstance().getConfig().set("backpack-tiers." + BackpackSettingsMainGUI.this.settings.getData().getTier() + ".type", (Object)nextType.name());
                BackpackPlus.getInstance().saveConfig();
                changeBackpackTypeStack.setItemMeta(BackpackSettingsMainGUI.this.getChangeBackpackTypeButtonMeta(changeBackpackTypeStack));
                this.updateButtonIcon(changeBackpackTypeStack);
                if (this.hasCooldown()) {
                    this.getCooldown().start();
                }
            }
        };
        changeBackpackTypeButton.setCooldown(new Cooldown(5){

            @Override
            protected void onStart() {
                super.onStart();
                changeBackpackTypeButton.setAvailableClick(false);
            }

            @Override
            public void onFinish() {
                changeBackpackTypeButton.setAvailableClick(true);
            }
        });
        return changeBackpackTypeButton;
    }

    public void openGUI(Player player) {
        player.openInventory(this.page.getInventory());
    }

    @Generated
    public Page getPage() {
        return this.page;
    }
}

