/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.init;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import lombok.Generated;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.command.BackpackCommand;
import pl.ziomalu.backpackplus.crafting.CraftingManager;
import pl.ziomalu.backpackplus.database.DatabaseConfigSettings;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.database.enums.DatabaseType;
import pl.ziomalu.backpackplus.gui.backpack.BackpacksChoseGUI;
import pl.ziomalu.backpackplus.gui.backpack.backpacksgui.AllBackpacksGUI;
import pl.ziomalu.backpackplus.hooks.ResourcePackManagerHook;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.listeners.BackpackCraftListener;
import pl.ziomalu.backpackplus.listeners.BlockBackpacksContainersListener;
import pl.ziomalu.backpackplus.listeners.CraftingListener;
import pl.ziomalu.backpackplus.listeners.backpack.BackpackInventoryListener;
import pl.ziomalu.backpackplus.listeners.backpack.BackpackListener;
import pl.ziomalu.backpackplus.listeners.backpack.BackpackNameChangeListener;
import pl.ziomalu.backpackplus.listeners.backpack.ChangeBackpackCraftingListener;
import pl.ziomalu.backpackplus.listeners.backpack.ChoseBackpackListener;
import pl.ziomalu.backpackplus.listeners.backpack.ViewPlayerBackpacksListener;
import pl.ziomalu.backpackplus.listeners.backpack.ViewPlayersBackpacksListener;
import pl.ziomalu.backpackplus.listeners.backpack.settings.AllowedItemsGuiListener;
import pl.ziomalu.backpackplus.listeners.backpack.settings.BackpackSettingsListener;
import pl.ziomalu.backpackplus.listeners.player.PlayerDeathListener;
import pl.ziomalu.backpackplus.listeners.player.PlayerInteractionListener;
import pl.ziomalu.backpackplus.listeners.player.PlayerItemMoveListener;
import pl.ziomalu.backpackplus.listeners.player.PlayerItemPickupListener;
import pl.ziomalu.backpackplus.listeners.player.PlayerJoinListener;
import pl.ziomalu.backpackplus.listeners.player.PlayerLeaveListener;
import pl.ziomalu.backpackplus.metrics.Metrics;
import pl.ziomalu.backpackplus.resourcepack.ResourcepackProvider;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.settings.BackpackSettingsData;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.tasks.CacheClearRunnable;
import pl.ziomalu.backpackplus.utils.BukkitConsole;
import pl.ziomalu.backpackplus.utils.UpdateChecker;
import pl.ziomalu.backpackplus.utils.Utils;

public class Initialize {
    private final JavaPlugin plugin;
    private static Initialize instance;

    public Initialize(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.copyResourcepack();
        this.updateReadmeIfNewer();
        this.loadSettings();
        this.initDatabase();
        if (!plugin.isEnabled()) {
            return;
        }
        new BackpackManager((Plugin)plugin);
        new LanguageManager();
        new CraftingManager((Plugin)plugin);
        this.loadBackpackSettings();
        new BackpacksChoseGUI();
        new AllBackpacksGUI();
        if (!ResourcePackManagerHook.checkIfEnabled()) {
            new ResourcepackProvider();
        }
        this.loadListeners();
        this.registerCommands();
        BackpackPlus.getInstance().clearCacheTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)new CacheClearRunnable(), 0L, (long)Settings.CACHE_CLEAR_FREQUENCY * 20L);
        new Metrics(BackpackPlus.getInstance(), 18367);
        new UpdateChecker((Plugin)plugin, 109630).getLatestVersion(latestVersion -> {
            UpdateChecker.Version currentVersion = Utils.getPluginVersion();
            boolean isNewer = latestVersion.isNewer(currentVersion);
            if (isNewer) {
                BukkitConsole.getInstance().sendMessage("\u00a77=============================\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77=============================\u00a7r", "\u00a7ePlugin has an update\u00a78: \u00a78(\u00a7c" + latestVersion.getChannel().name() + " " + latestVersion.getVersionData().getVersionString() + "\u00a78)\u00a7r \u00a7ecurrent version\u00a78: \u00a78(\u00a7c" + currentVersion.getChannel().name() + " " + currentVersion.getVersionData().getVersionString() + "\u00a78)\u00a7r", "\u00a77You can download from\u00a78:", "\u00a7fhttps://legacy.curseforge.com/minecraft/bukkit-plugins/backpack-plus/", "\u00a7fhttps://www.spigotmc.org/resources/backpack-plus.109630/", "\u00a7fhttps://modrinth.com/plugin/backpack-plus/", "\u00a77=============================\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77=============================\u00a7r");
            } else if (currentVersion.getChannel() == UpdateChecker.VersionChannel.DEV) {
                BukkitConsole.getInstance().sendMessage("\u00a77=============================\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77=============================\u00a7r", "\u00a7eYou are using a development version of the plugin\u00a78: \u00a78(\u00a7c" + currentVersion.getChannel().name() + " " + currentVersion.getVersionData().getVersionString() + "-" + currentVersion.getBuildNumber() + "\u00a78)\u00a7r", "\u00a7eLatest release: \u00a78(\u00a7c" + latestVersion.getChannel().name() + " " + latestVersion.getVersionData().getVersionString() + "\u00a78)", "\u00a77This version may be unstable and is intended for testing purposes only.", "\u00a77=============================\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77=============================\u00a7r");
            } else {
                BukkitConsole.getInstance().sendMessage("\u00a77=============================\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77=============================\u00a7r", "\u00a7aThe plugin is up to date\u00a78: \u00a78(\u00a7c" + currentVersion.getChannel().name() + " " + currentVersion.getVersionData().getVersionString() + "\u00a78)\u00a7r", "\u00a77=============================\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77=============================\u00a7r");
            }
        });
    }

    private void registerCommands() {
        PluginCommand backpackCommand = BackpackPlus.getInstance().getCommand("backpackplus");
        BackpackCommand cmd = new BackpackCommand();
        backpackCommand.setExecutor((CommandExecutor)cmd);
        backpackCommand.setTabCompleter((TabCompleter)cmd);
    }

    private void initDatabase() {
        DatabaseType databaseType;
        new DatabaseConfigSettings(this.plugin);
        try {
            databaseType = DatabaseType.valueOf(DatabaseConfigSettings.DATABASE_TYPE.toUpperCase());
        }
        catch (Exception ex) {
            databaseType = DatabaseType.SQLITE;
            this.plugin.getLogger().warning("Not valid or not supported database type: " + DatabaseConfigSettings.DATABASE_TYPE + ", SQLite used");
        }
        new DatabaseManager((Plugin)this.plugin, databaseType);
        boolean connected = false;
        switch (databaseType) {
            case SQLITE: {
                connected = DatabaseManager.getInstance().connectSQLite("backpack");
                break;
            }
            case MYSQL: {
                connected = DatabaseManager.getInstance().connectMySQL();
                break;
            }
            case POSTGRESQL: {
                connected = DatabaseManager.getInstance().connectPostgreSQL();
                break;
            }
            default: {
                this.plugin.getLogger().severe("The database has not been implemented: " + String.valueOf((Object)databaseType));
            }
        }
        try {
            if (connected) {
                DatabaseManager.getInstance().getDatabase().createTables();
                DatabaseManager.getInstance().getDatabase().addLastPlayerUUIDColumnIfNotExists();
                DatabaseManager.getInstance().getDatabase().addBackpackStateColumnIfNotExists();
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning(ex.getMessage());
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    public void loadBackpackSettings() {
        BackpackManager.getInstance().clearBackpackSettings();
        BackpackManager.getInstance().clearBackpacksItem();
        FileConfiguration config = this.plugin.getConfig();
        if (!config.isSet("backpack-tiers")) {
            this.plugin.getLogger().warning("Failed to load backpacks, check config.yml, if you don't have a section called 'backpack-tiers' make a copy of the config.yml file and delete it then reload the server, Just remember you will have to re-set craftings etc.");
            return;
        }
        for (String stringTier : config.getConfigurationSection("backpack-tiers").getKeys(false)) {
            try {
                int backpackTier = Integer.parseInt(stringTier);
                BackpackSettingsData backpackSettingsData = new BackpackSettingsData(backpackTier);
                BackpackSettings backpackSettings = new BackpackSettings(backpackSettingsData);
                backpackSettings.initialize();
                BackpackManager.getInstance().addBackpackSettings(backpackSettings);
                ItemStack ba = backpackSettings.getBackpackStack().clone();
                BackpackManager.getInstance().addBackpackItem(ba);
            }
            catch (NumberFormatException ex) {
                BackpackPlus.getInstance().getLogger().warning("Backpack Tier is not a valid number: " + stringTier + " at path: backpack-tiers." + stringTier);
            }
            catch (IllegalArgumentException e) {
                BackpackPlus.getInstance().getLogger().warning("Error at backpack: " + stringTier + " message: " + e.getMessage());
            }
        }
    }

    private void loadSettings() {
        new Settings(this.plugin).load();
    }

    private void loadListeners() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerJoinListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new PlayerLeaveListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new PlayerItemPickupListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new PlayerItemMoveListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new PlayerInteractionListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new PlayerDeathListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new BackpackInventoryListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new ChoseBackpackListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new ChangeBackpackCraftingListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new ViewPlayerBackpacksListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new ViewPlayersBackpacksListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new BackpackNameChangeListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new CraftingListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new BackpackListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new BackpackSettingsListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new AllowedItemsGuiListener(), (Plugin)this.plugin);
        pm.registerEvents((Listener)new BackpackCraftListener(), (Plugin)this.plugin);
        if (Settings.BLOCK_BACKPACK_INSERT_CONTAINERS) {
            pm.registerEvents((Listener)new BlockBackpacksContainersListener(), (Plugin)this.plugin);
        }
    }

    private void copyResourcepack() {
        boolean dirCreated;
        File packDir = new File(this.plugin.getDataFolder(), "pack");
        if (!packDir.exists() && !(dirCreated = packDir.mkdirs())) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a7cFailed to create 'pack' directory.");
            return;
        }
        File destResourcepackFile = new File(packDir, "resourcepack.zip");
        if (!destResourcepackFile.exists()) {
            try (InputStream inputStream = this.plugin.getResource("pack/resourcepack.zip");){
                if (inputStream == null) {
                    BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a7cResource pack not found in resources!");
                    return;
                }
                Files.copy(inputStream, destResourcepackFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a72Resource pack copied to pack folder.");
            }
            catch (IOException ex) {
                this.plugin.getLogger().severe("Failed to copy resource pack: " + ex.getMessage());
            }
        }
    }

    private void updateReadmeIfNewer() {
        String pluginVersion;
        InputStream inputStream;
        String existingVersion;
        File destReadmeFile;
        block23: {
            boolean dirCreated;
            File packDir = new File(this.plugin.getDataFolder(), "pack");
            destReadmeFile = new File(packDir, "readme.md");
            if (!packDir.exists() && !(dirCreated = packDir.mkdirs())) {
                BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a7cFailed to create 'pack' directory.");
                return;
            }
            existingVersion = null;
            if (destReadmeFile.exists()) {
                existingVersion = this.extractVersionFromReadme(destReadmeFile);
            }
            try {
                inputStream = this.plugin.getResource("pack/readme.md");
                try {
                    if (inputStream != null) {
                        pluginVersion = this.extractVersionFromInputStream(inputStream);
                        break block23;
                    }
                    BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a7cReadme not found in resources!");
                    return;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to read plugin readme: " + e.getMessage());
                return;
            }
        }
        if (existingVersion == null || pluginVersion.compareTo(existingVersion) > 0) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a72New version found, updating readme...");
            try {
                inputStream = this.plugin.getResource("pack/readme.md");
                try {
                    if (inputStream == null) {
                        BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a7cReadme not found in resources!");
                        return;
                    }
                    Files.copy(inputStream, destReadmeFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a72Readme updated.");
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to update readme: " + e.getMessage());
            }
        } else {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Pack\u00a78] \u00a77No update needed; current readme is up to date.");
        }
    }

    private String extractVersionFromReadme(File readmeFile) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(readmeFile.toPath(), new OpenOption[0])));
        try {
            string = reader.lines().filter(line -> line.contains("Version:")).map(line -> line.split("Version:")[1].trim()).findFirst().orElse(null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to read existing readme version: " + e.getMessage());
                return null;
            }
        }
        reader.close();
        return string;
    }

    private String extractVersionFromInputStream(InputStream inputStream) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            string = reader.lines().filter(line -> line.contains("Version:")).map(line -> line.split("Version:")[1].trim()).findFirst().orElse(null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to read plugin readme version: " + e.getMessage());
                return null;
            }
        }
        reader.close();
        return string;
    }

    @Generated
    public static Initialize getInstance() {
        return instance;
    }
}

