/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.items;

import lombok.Generated;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.cache.CacheKeyManager;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.utils.SkullCreator;
import pl.ziomalu.backpackplus.utils.Text;

public class BackpacksItems {
    public static NamespacedKey backpackTierKey;
    public static NamespacedKey backpackUsed;
    private static BackpacksItems instance;

    public BackpacksItems() {
        instance = this;
        backpackTierKey = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "backpackTier");
        backpackUsed = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "backpackUsed");
    }

    public ItemStack backpackItemStack(String displayName, int backpackTier, int customModelId, Material backpackMaterial) {
        String key = CacheKeyManager.backpackTier(backpackTier);
        if (Cache.containsKey(key)) {
            return (ItemStack)Cache.get(key);
        }
        ItemStack backpackStack = this.materialBackpack(displayName, backpackTier, customModelId, backpackMaterial);
        if (backpackStack != null) {
            Cache.put(key, backpackStack);
        }
        return backpackStack;
    }

    public ItemStack backpackItemStack(String displayName, int backpackTier, String skullTexture) {
        String key = CacheKeyManager.backpackTier(backpackTier);
        if (Cache.containsKey(key)) {
            return (ItemStack)Cache.get(key);
        }
        ItemStack backpackStack = this.skullBackpack(displayName, backpackTier, skullTexture);
        if (backpackStack != null) {
            Cache.put(key, backpackStack);
        }
        return backpackStack;
    }

    private ItemStack skullBackpack(String displayName, int backpackTier, String skullTexture) {
        ItemStack skullStack = SkullCreator.itemFromBase64(skullTexture);
        if (skullStack == null) {
            return null;
        }
        ItemMeta skullMeta = skullStack.getItemMeta();
        if (skullMeta == null) {
            return skullStack;
        }
        skullMeta.setDisplayName(Text.setColour(displayName));
        PersistentDataContainer persistentDataContainer = skullMeta.getPersistentDataContainer();
        persistentDataContainer.set(backpackUsed, PersistentDataType.INTEGER, (Object)0);
        persistentDataContainer.set(backpackTierKey, PersistentDataType.INTEGER, (Object)backpackTier);
        skullStack.setItemMeta(skullMeta);
        return skullStack;
    }

    private ItemStack materialBackpack(String displayName, int backpackTier, int customModelId, Material backpackMaterial) {
        ItemStack stack = new ItemStack(backpackMaterial);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return null;
        }
        meta.setDisplayName(Text.setColour(displayName));
        meta.setCustomModelData(Integer.valueOf(customModelId));
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        persistentDataContainer.set(backpackUsed, PersistentDataType.INTEGER, (Object)0);
        persistentDataContainer.set(backpackTierKey, PersistentDataType.INTEGER, (Object)backpackTier);
        stack.setItemMeta(meta);
        return stack;
    }

    @Generated
    public static BackpacksItems getInstance() {
        return instance;
    }
}

