/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.items;

import me.ziomalu.api.gui.basic.BasicGuiItems;
import me.ziomalu.api.gui.basic.GlassColors;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.Text;

public class CustomItems {
    private static final FileConfiguration config = BackpackPlus.getInstance().getConfig();
    private static ItemStack OVERFILL_ITEMSTACK;
    private static ItemStack FILLING_ITEMSTACK;
    private static ItemStack PAGE_NEXT_ITEMSTACK;
    private static ItemStack PAGE_PREVIOUS_ITEMSTACK;

    public static ItemStack getOverfillStack() {
        ItemStack stack;
        if (OVERFILL_ITEMSTACK != null) {
            return OVERFILL_ITEMSTACK;
        }
        if (Settings.OVERFILL_USE_CUSTOM_MODEL) {
            int customModelId = Settings.OVERFILL_CUSTOM_MODEL_ID;
            String materialString = Settings.OVERFILL_CUSTOM_MODEL_MATERIAL;
            Material material = Material.getMaterial((String)materialString.toUpperCase());
            ItemStack itemStack = new ItemStack(material == null ? Material.MAP : material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(customModelId));
            itemMeta.setDisplayName(" ");
            itemMeta.addItemFlags(ItemFlag.values());
            PersistentDataContainer item = itemMeta.getPersistentDataContainer();
            item.set(BasicGuiItems.GUI_ITEM, PersistentDataType.STRING, (Object)"blank");
            itemStack.setItemMeta(itemMeta);
            OVERFILL_ITEMSTACK = itemStack;
            return itemStack;
        }
        GlassColors fillOverfillColor = GlassColors.Black;
        try {
            fillOverfillColor = GlassColors.valueOf(Settings.COLOUR_OVERFILL_SLOTS);
        }
        catch (IllegalArgumentException ex) {
            BackpackPlus.getInstance().getLogger().warning("Invalid Color Name provided: " + Settings.COLOUR_OVERFILL_SLOTS + " on: Gui.colour-overfill-slots");
        }
        OVERFILL_ITEMSTACK = stack = BasicGuiItems.getInstance().createBlankStainedGlassPane(fillOverfillColor, Settings.COLOUR_OVERFILL_SLOTS_GLOW);
        return stack;
    }

    public static ItemStack getFillingStack() {
        ItemStack stack;
        if (FILLING_ITEMSTACK != null) {
            return FILLING_ITEMSTACK;
        }
        if (Settings.FILLING_USE_CUSTOM_MODEL) {
            int customModelId = Settings.FILLING_CUSTOM_MODEL_ID;
            String materialString = Settings.FILLING_CUSTOM_MODEL_MATERIAL;
            Material material = Material.getMaterial((String)materialString.toUpperCase());
            ItemStack itemStack = new ItemStack(material == null ? Material.MAP : material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(customModelId));
            itemMeta.setDisplayName(" ");
            itemMeta.addItemFlags(ItemFlag.values());
            PersistentDataContainer item = itemMeta.getPersistentDataContainer();
            item.set(BasicGuiItems.GUI_ITEM, PersistentDataType.STRING, (Object)"blank");
            itemStack.setItemMeta(itemMeta);
            FILLING_ITEMSTACK = itemStack;
            return itemStack;
        }
        GlassColors fillOverfillColor = GlassColors.Black;
        try {
            fillOverfillColor = GlassColors.valueOf(Settings.FILLING_COLOR_BUTTONS);
        }
        catch (IllegalArgumentException ex) {
            BackpackPlus.getInstance().getLogger().warning("Invalid Color Name provided: " + Settings.FILLING_COLOR_BUTTONS + " on: Gui.filling-color-buttons");
        }
        FILLING_ITEMSTACK = stack = BasicGuiItems.getInstance().createBlankStainedGlassPane(fillOverfillColor, Settings.COLOUR_OVERFILL_SLOTS_GLOW);
        return stack;
    }

    public static ItemStack getPageNextStack() {
        ItemStack stack;
        if (PAGE_NEXT_ITEMSTACK != null) {
            return PAGE_NEXT_ITEMSTACK;
        }
        if (Settings.PAGE_NEXT_USE_CUSTOM_MODEL) {
            int customModelId = Settings.PAGE_NEXT_CUSTOM_MODEL_ID;
            String materialString = Settings.PAGE_NEXT_CUSTOM_MODEL_MATERIAL;
            Material material = Material.getMaterial((String)materialString.toUpperCase());
            ItemStack itemStack = new ItemStack(material == null ? Material.MAP : material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(customModelId));
            itemMeta.setDisplayName(Text.setColour("&2&l\u2192"));
            itemMeta.addItemFlags(ItemFlag.values());
            PersistentDataContainer item = itemMeta.getPersistentDataContainer();
            item.set(BasicGuiItems.BUTTON_NAMESPACE, PersistentDataType.STRING, (Object)"button");
            itemStack.setItemMeta(itemMeta);
            PAGE_NEXT_ITEMSTACK = itemStack;
            return itemStack;
        }
        PAGE_NEXT_ITEMSTACK = stack = BasicGuiItems.getInstance().basicNextPageButton();
        return stack;
    }

    public static ItemStack getPagePreviousStack() {
        ItemStack stack;
        if (PAGE_PREVIOUS_ITEMSTACK != null) {
            return PAGE_PREVIOUS_ITEMSTACK;
        }
        if (Settings.PAGE_PREVIOUS_USE_CUSTOM_MODEL) {
            int customModelId = Settings.PAGE_PREVIOUS_CUSTOM_MODEL_ID;
            String materialString = Settings.PAGE_PREVIOUS_CUSTOM_MODEL_MATERIAL;
            Material material = Material.getMaterial((String)materialString.toUpperCase());
            ItemStack itemStack = new ItemStack(material == null ? Material.MAP : material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(customModelId));
            itemMeta.setDisplayName(Text.setColour("&c&l\u2190"));
            itemMeta.addItemFlags(ItemFlag.values());
            PersistentDataContainer item = itemMeta.getPersistentDataContainer();
            item.set(BasicGuiItems.BUTTON_NAMESPACE, PersistentDataType.STRING, (Object)"button");
            itemStack.setItemMeta(itemMeta);
            PAGE_PREVIOUS_ITEMSTACK = itemStack;
            return itemStack;
        }
        PAGE_PREVIOUS_ITEMSTACK = stack = BasicGuiItems.getInstance().basicPreviousPageButton();
        return stack;
    }
}

