/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.items;

import java.io.IOException;
import java.util.Objects;
import me.ziomalu.api.ItemUtil;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.items.NBTItem;

public class Item {
    private Material material;
    private ItemStack item;
    private ItemType type;
    private NBTItem nbtItem;

    public Item(Material material) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.type = ItemType.MATERIAL;
    }

    public Item(ItemStack item) {
        Objects.requireNonNull(item, "ItemStack cannot be null");
        if (!Item.isCustomItem(item)) {
            this.material = item.getType();
            this.type = ItemType.MATERIAL;
        } else {
            this.item = item.clone();
            this.type = ItemType.STACK;
        }
    }

    public Item(String encodedString) {
        try {
            this.item = ItemUtil.itemFromBase64(encodedString);
            this.type = this.item != null ? ItemType.STACK : ItemType.UNKNOWN;
        }
        catch (IOException e) {
            this.type = ItemType.UNKNOWN;
        }
    }

    public Item(NBTItem nbtItem) {
        this.nbtItem = Objects.requireNonNull(nbtItem, "NBTItem cannot be null");
        this.type = ItemType.NBT;
    }

    @Nullable
    public Object getObjectOfItem() {
        return switch (this.type) {
            case ItemType.STACK -> this.item;
            case ItemType.MATERIAL -> this.material;
            default -> null;
        };
    }

    @Nullable
    public Material getMaterial() {
        return switch (this.type) {
            case ItemType.STACK -> {
                if (this.item != null) {
                    yield this.item.getType();
                }
                yield null;
            }
            case ItemType.MATERIAL -> this.material;
            default -> null;
        };
    }

    @Nullable
    public ItemStack getItem() {
        return this.type == ItemType.STACK ? this.item : null;
    }

    public static boolean isCustomItem(@Nullable ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.hasLore() || meta.hasEnchants() || meta.hasAttributeModifiers() || meta.hasCustomModelData() || meta.hasDisplayName() || !meta.getItemFlags().isEmpty() || !meta.getPersistentDataContainer().isEmpty();
    }

    public boolean isNBTItem() {
        return this.nbtItem != null;
    }

    @Nullable
    public String encodeItem() {
        return this.type == ItemType.STACK && this.item != null ? ItemUtil.itemToBase64(this.item) : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            if (Item.isCustomItem(stack)) {
                return this.item != null && this.item.isSimilar(stack);
            }
            return this.getMaterial() == stack.getType();
        }
        if (obj instanceof Material) {
            Material mat = (Material)obj;
            return this.getMaterial() == mat;
        }
        return false;
    }

    public String toString() {
        return switch (this.type) {
            case ItemType.STACK -> {
                if (Item.isCustomItem(this.item)) {
                    yield ItemUtil.itemToBase64(this.item);
                }
                yield this.item.getType().name();
            }
            case ItemType.MATERIAL -> this.material.name();
            case ItemType.NBT -> this.nbtItem.toString();
            default -> "";
        };
    }

    public static enum ItemType {
        MATERIAL,
        STACK,
        NBT,
        UNKNOWN;

    }
}

