/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import lombok.Generated;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.utils.Text;

public class NBTItem {
    private final String pluginName;
    private final String namespace;
    private final String type;
    private final NamespacedKey namespacedKey;
    public static final NamespacedKey NBT_ITEM_KEY = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "nbt_item_key");

    public NBTItem(String pluginName, String namespace, String type) {
        this.pluginName = Objects.requireNonNull(pluginName, "pluginName cannot be null");
        this.namespace = Objects.requireNonNull(namespace, "namespace cannot be null");
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.namespacedKey = this.createNamespacedKey();
    }

    public static NBTItem parseNBTItem(String namespaceString) {
        String nbtData = namespaceString.substring(4);
        String[] parts = nbtData.split("[:=]", 3);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid NBT format. Expected: nbt:plugin:namespace=type");
        }
        return new NBTItem(parts[0], parts[1], parts[2]);
    }

    private NamespacedKey createNamespacedKey() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(this.pluginName);
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin '" + this.pluginName + "' is not loaded");
        }
        try {
            return new NamespacedKey(plugin, this.namespace);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to create NamespacedKey for plugin '" + this.pluginName + "' with namespace '" + this.namespace + "'", e);
        }
    }

    @Nullable
    private PersistentDataContainer getPersistentDataContainer(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemMeta meta = stack.getItemMeta();
        return meta != null ? meta.getPersistentDataContainer() : null;
    }

    public boolean hasNamespace(ItemStack stack) {
        if (this.namespacedKey == null) {
            return false;
        }
        PersistentDataContainer dataContainer = this.getPersistentDataContainer(stack);
        return dataContainer != null && dataContainer.has(this.namespacedKey);
    }

    @Nullable
    private String getNamespaceValue(@Nullable ItemStack stack) {
        if (stack == null || this.namespacedKey == null) {
            return null;
        }
        PersistentDataContainer dataContainer = this.getPersistentDataContainer(stack);
        if (dataContainer == null || !this.hasNamespace(stack)) {
            return null;
        }
        try {
            MMOItems.getType((ItemStack)stack);
            return (String)dataContainer.get(this.namespacedKey, PersistentDataType.STRING);
        }
        catch (IllegalStateException e) {
            BackpackPlus.getInstance().getLogger().log(Level.INFO, "Failed to get namespace value for key " + String.valueOf(this.namespacedKey) + " - data type mismatch", e);
            return null;
        }
    }

    public boolean isSameType(ItemStack stack) {
        if (this.pluginName.equalsIgnoreCase("MMOItems")) {
            Type itemType = Type.get((String)this.type);
            return MMOItems.getType((ItemStack)stack) == itemType;
        }
        String namespacedValue = this.getNamespaceValue(stack);
        return this.type.equalsIgnoreCase(namespacedValue);
    }

    public String toString() {
        return String.format("nbt:%s:%s=%s", this.pluginName, this.namespace, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTItem nbtItem = (NBTItem)o;
        return this.pluginName.equals(nbtItem.pluginName) && this.namespace.equals(nbtItem.namespace) && this.type.equals(nbtItem.type);
    }

    public ItemStack toItemStack() {
        ItemStack nbtItem = new ItemStack(Material.PAPER);
        ItemMeta nbtMeta = nbtItem.getItemMeta();
        if (nbtMeta == null) {
            return null;
        }
        String langDisplayName = LanguageManager.getInstance().getString("nbt.nbt-item.displayName");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("plugin", this.pluginName);
        variables.put("namespace", this.namespace);
        variables.put("value", this.type);
        String displayName = StringParser.parseString(langDisplayName, variables);
        nbtMeta.setDisplayName(Text.setColour(displayName));
        ArrayList<String> lore = new ArrayList<String>();
        List<String> langLore = LanguageManager.getInstance().getStringList("nbt.nbt-item.lore");
        for (String str : langLore) {
            lore.add(Text.setColour(StringParser.parseString(str, variables)));
        }
        nbtMeta.setLore(lore);
        try {
            nbtMeta.setMaxStackSize(Integer.valueOf(1));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            nbtMeta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
        catch (NoSuchMethodError ignore) {
            nbtMeta.addEnchant(Enchantment.UNBREAKING, 1, true);
            nbtMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        PersistentDataContainer dataContainer = nbtMeta.getPersistentDataContainer();
        dataContainer.set(NBT_ITEM_KEY, PersistentDataType.STRING, (Object)this.toString());
        nbtItem.setItemMeta(nbtMeta);
        return nbtItem;
    }

    public static boolean isNBTItem(ItemStack stack) {
        PersistentDataContainer dataContainer;
        if (stack == null) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer persistentDataContainer = dataContainer = meta != null ? meta.getPersistentDataContainer() : null;
        if (dataContainer == null) {
            return false;
        }
        return dataContainer.has(NBT_ITEM_KEY);
    }

    @Nullable
    public static String getNBTString(ItemStack stack) {
        if (!NBTItem.isNBTItem(stack)) {
            return null;
        }
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        return (String)dataContainer.get(NBT_ITEM_KEY, PersistentDataType.STRING);
    }

    public int hashCode() {
        return Objects.hash(this.pluginName, this.namespace, this.type);
    }

    @Generated
    public String getPluginName() {
        return this.pluginName;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public NamespacedKey getNamespacedKey() {
        return this.namespacedKey;
    }
}

