/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.language;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import me.ziomalu.api.config.Config;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.BukkitConsole;
import pl.ziomalu.backpackplus.utils.Text;

public final class LanguageManager {
    private static LanguageManager instance;
    private Config currentLanguage;
    private final JavaPlugin plugin;
    private String currentLanguageName;

    public LanguageManager() {
        instance = this;
        this.plugin = BackpackPlus.getInstance();
        this.loadLanguages(Settings.LANGUAGE);
    }

    private void loadLanguages(String languageName) {
        File languageFile;
        File languageDirectory = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "localization");
        if (!languageDirectory.exists()) {
            languageDirectory.mkdirs();
            new Config(this.plugin, "localization", "chi.yml");
            new Config(this.plugin, "localization", "eng.yml");
            new Config(this.plugin, "localization", "fre.yml");
            new Config(this.plugin, "localization", "ger.yml");
            new Config(this.plugin, "localization", "jpn.yml");
            new Config(this.plugin, "localization", "pol.yml");
            new Config(this.plugin, "localization", "ukr.yml");
            new Config(this.plugin, "localization", "es.yml");
        }
        if ((languageFile = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "localization", languageName + ".yml")).exists() && languageFile.isFile()) {
            this.currentLanguage = new Config(this.plugin, "localization", languageName + ".yml");
            BukkitConsole.getInstance().sendMessage(String.format("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a72Language used\u00a78: \u00a76%s", languageName));
            this.currentLanguageName = languageName;
        } else {
            this.currentLanguage = new Config(this.plugin, "localization", "eng.yml");
            BukkitConsole.getInstance().sendMessage(String.format("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a7cLanguage not found\u00a78: \u00a7f%s&c, default language set\u00a78: \u00a7f%s", languageName, "eng"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(String path) {
        if (this.currentLanguage.getConfig().isSet(path)) {
            return this.currentLanguage.getConfig().getString(path, "");
        }
        try (InputStream defaultConfigStream = this.plugin.getResource("localization/" + this.currentLanguageName + ".yml");){
            if (defaultConfigStream != null) {
                YamlConfiguration originalConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultConfigStream));
                this.currentLanguage.getConfig().set(path, (Object)originalConfig.getString(path));
                if (!originalConfig.getComments(path).isEmpty()) {
                    this.currentLanguage.getConfig().setComments(path, originalConfig.getComments(path));
                }
                this.currentLanguage.save();
                String string = originalConfig.getString(path);
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.plugin.getLogger().warning("Language: " + this.currentLanguage.getFileName() + " missing: " + path);
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getStringList(String path) {
        if (this.currentLanguage.getConfig().isSet(path)) {
            return this.currentLanguage.getConfig().getStringList(path);
        }
        try (InputStream defaultConfigStream = this.plugin.getResource("localization/" + this.currentLanguageName + ".yml");){
            if (defaultConfigStream != null) {
                YamlConfiguration originalConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultConfigStream));
                this.currentLanguage.getConfig().set(path, (Object)originalConfig.getStringList(path));
                if (!originalConfig.getComments(path).isEmpty()) {
                    this.currentLanguage.getConfig().setComments(path, originalConfig.getComments(path));
                }
                this.currentLanguage.save();
                List list = originalConfig.getStringList(path);
                return list;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.plugin.getLogger().warning("Language: " + this.currentLanguage.getFileName() + " missing: " + path);
        return Collections.emptyList();
    }

    public String getAndSaveIfNotExistsString(String path, String defaultString, String ... comments) {
        if (!this.currentLanguage.getConfig().isSet(path)) {
            this.currentLanguage.set(path, defaultString);
            if (comments.length > 0) {
                this.currentLanguage.getConfig().setComments(path, Arrays.stream(comments).toList());
            }
        }
        return this.currentLanguage.getConfig().getString(path);
    }

    public static void sendMessage(Player player, String path) {
        if (player == null) {
            return;
        }
        String message = instance.getString(path);
        if (message.isEmpty()) {
            return;
        }
        player.sendMessage(Text.setColour(message));
    }

    @Generated
    public static LanguageManager getInstance() {
        return instance;
    }
}

