/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners;

import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.language.LanguageManager;

public class BackpackCraftListener
implements Listener {
    @EventHandler
    public void onBackpackPreCraft(PrepareItemCraftEvent e) {
        if (e.getRecipe() == null) {
            return;
        }
        if (!BackpackManager.getInstance().isBackpackStack(e.getRecipe().getResult())) {
            return;
        }
        ItemStack[] matrix = e.getInventory().getMatrix();
        if (this.containsFilledContainer(matrix)) {
            e.getInventory().setResult(null);
        }
    }

    @EventHandler
    public void onBackpackCraft(CraftItemEvent e) {
        if (!BackpackManager.getInstance().isBackpackStack(e.getRecipe().getResult())) {
            return;
        }
        ItemStack[] matrix = e.getInventory().getMatrix();
        if (this.containsFilledContainer(matrix)) {
            e.setCancelled(true);
            HumanEntity humanEntity = e.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                LanguageManager.sendMessage(player, "crafting.blocked-filled-container");
            }
        }
    }

    private boolean containsFilledContainer(ItemStack[] matrix) {
        for (ItemStack stack : matrix) {
            BlockStateMeta blockStateMeta;
            BlockState blockState;
            BundleMeta bundleMeta;
            ItemMeta meta;
            if (stack == null || stack.getType() == Material.AIR) continue;
            if (stack.getType() == Material.BUNDLE && (meta = stack.getItemMeta()) instanceof BundleMeta && !(bundleMeta = (BundleMeta)meta).getItems().isEmpty()) {
                return true;
            }
            meta = stack.getItemMeta();
            if (!(meta instanceof BlockStateMeta) || !((blockState = (blockStateMeta = (BlockStateMeta)meta).getBlockState()) instanceof Container)) continue;
            Container container = (Container)blockState;
            for (ItemStack item : container.getInventory().getContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                return true;
            }
        }
        return false;
    }
}

