/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.MinecraftVersion;
import pl.ziomalu.backpackplus.utils.Utils;

public class BlockBackpacksContainersListener
implements Listener {
    private List<InventoryType> containers = new ArrayList<InventoryType>();
    final Logger logger = BackpackPlus.getInstance().getLogger();

    public BlockBackpacksContainersListener() {
        this.containers = Settings.BLOCKED_CONTAINERS;
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_21)) {
            try {
                InventoryType crafter = InventoryType.valueOf((String)"CRAFTER");
                this.containers.add(crafter);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent e) {
        if (!this.containers.contains(e.getInitiator().getType())) {
            return;
        }
        ItemStack item = e.getItem();
        if (item.getType() != Material.AIR && BackpackManager.getInstance().isBackpackStack(item)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryPickupItem(InventoryPickupItemEvent e) {
        if (!this.containers.contains(e.getInventory().getType())) {
            return;
        }
        ItemStack item = e.getItem().getItemStack();
        if (item.getType() != Material.AIR && BackpackManager.getInstance().isBackpackStack(item)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (!this.containers.contains(e.getInventory().getType())) {
            return;
        }
        ItemStack currentItem = e.getCurrentItem();
        ItemStack cursorItem = e.getCursor();
        if (e.getClickedInventory() == null) {
            return;
        }
        switch (e.getAction()) {
            case MOVE_TO_OTHER_INVENTORY: {
                if (e.getClickedInventory().getType() != InventoryType.PLAYER) {
                    return;
                }
                if (!BackpackManager.getInstance().isBackpackStack(currentItem) && !BackpackManager.getInstance().isBackpackStack(cursorItem)) break;
                e.setCancelled(true);
                if (e.getCursor() == null || e.getCursor().getType() == Material.AIR && e.getClickedInventory().getType() == InventoryType.CHEST) {
                    return;
                }
                Utils.sendMessage((CommandSender)e.getWhoClicked(), LanguageManager.getInstance().getString("blocked-backpack-insert-message"));
                break;
            }
            case PLACE_ALL: 
            case PLACE_ONE: 
            case PLACE_SOME: 
            case SWAP_WITH_CURSOR: {
                if (e.getClickedInventory() == null) {
                    return;
                }
                if (!this.containers.contains(e.getClickedInventory().getType())) {
                    return;
                }
                if (!BackpackManager.getInstance().isBackpackStack(currentItem) && !BackpackManager.getInstance().isBackpackStack(cursorItem)) break;
                Utils.sendMessage((CommandSender)e.getWhoClicked(), LanguageManager.getInstance().getString("blocked-backpack-insert-message"));
                e.setCancelled(true);
                break;
            }
            case HOTBAR_SWAP: {
                ItemStack slotStack;
                if (e.getClick() == ClickType.SWAP_OFFHAND) {
                    if (!BackpackManager.getInstance().isBackpackStack(currentItem) && !BackpackManager.getInstance().isBackpackStack(cursorItem)) break;
                    e.setCancelled(true);
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), LanguageManager.getInstance().getString("blocked-backpack-insert-message"));
                    break;
                }
                if (e.getClick() != ClickType.NUMBER_KEY) break;
                if (e.getClickedInventory().getType() == InventoryType.PLAYER) {
                    return;
                }
                ItemStack rawSlotStack = e.getView().getItem(e.getRawSlot());
                ItemStack hotBarStack = e.getWhoClicked().getInventory().getItem(e.getHotbarButton());
                ItemStack itemStack = e.getClickedInventory() != null ? (e.getClickedInventory().getType() == InventoryType.PLAYER ? e.getClickedInventory().getItem(e.getSlot()) : null) : (slotStack = null);
                if (!BackpackManager.getInstance().isBackpackStack(hotBarStack) && !BackpackManager.getInstance().isBackpackStack(rawSlotStack) && !BackpackManager.getInstance().isBackpackStack(slotStack)) break;
                e.setCancelled(true);
                Utils.sendMessage((CommandSender)e.getWhoClicked(), LanguageManager.getInstance().getString("blocked-backpack-insert-message"));
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        ItemStack oldCursorStack = e.getOldCursor();
        if (e.getType() == DragType.SINGLE) {
            Map newItems = e.getNewItems();
            if (!newItems.isEmpty()) {
                boolean isBlocked = false;
                for (Map.Entry newItem : newItems.entrySet()) {
                    int rawSlot = (Integer)newItem.getKey();
                    if (rawSlot > e.getInventory().getSize() - 1 || !BackpackManager.getInstance().isBackpackStack((ItemStack)newItem.getValue())) continue;
                    isBlocked = true;
                    e.setCancelled(true);
                }
                if (isBlocked) {
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), LanguageManager.getInstance().getString("blocked-backpack-insert-message"));
                }
            } else {
                int rawSlot = (Integer)e.getRawSlots().iterator().next();
                if (rawSlot > e.getInventory().getSize() - 1) {
                    return;
                }
                if (BackpackManager.getInstance().isBackpackStack(oldCursorStack) || BackpackManager.getInstance().isBackpackStack(e.getCursor())) {
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), LanguageManager.getInstance().getString("blocked-backpack-insert-message"));
                    e.setCancelled(true);
                }
            }
        } else {
            boolean isBlocked = false;
            Iterator iterator = e.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int rawSlot = (Integer)iterator.next();
                if (rawSlot > e.getInventory().getSize() - 1 || !BackpackManager.getInstance().isBackpackStack(oldCursorStack)) continue;
                isBlocked = true;
                e.setCancelled(true);
            }
            if (isBlocked) {
                Utils.sendMessage((CommandSender)e.getWhoClicked(), LanguageManager.getInstance().getString("blocked-backpack-insert-message"));
            }
        }
    }
}

