/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.settings.Settings;

public class CraftingListener
implements Listener {
    @EventHandler
    public void onItemCraft(CraftItemEvent e) {
        if (!Settings.CRAFTING_BACKPACK_REQUIRES_PERMISSIONS) {
            return;
        }
        if (!BackpackManager.getInstance().isBackpackStack(e.getRecipe().getResult())) {
            return;
        }
        int backpackTier = BackpackManager.getInstance().getBackpackTier(e.getRecipe().getResult());
        BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(backpackTier);
        Player player = (Player)e.getView().getPlayer();
        if (backpackSettings.getData().getCraftPermission().isEmpty() || player.hasPermission(backpackSettings.getData().getCraftPermission())) {
            return;
        }
        e.setResult(Event.Result.DENY);
        e.setCancelled(true);
    }

    @EventHandler
    public void onItemPreCraft(PrepareItemCraftEvent e) {
        if (!Settings.CRAFTING_BACKPACK_REQUIRES_PERMISSIONS) {
            return;
        }
        if (e.getRecipe() == null) {
            return;
        }
        if (!BackpackManager.getInstance().isBackpackStack(e.getRecipe().getResult())) {
            return;
        }
        int backpackTier = BackpackManager.getInstance().getBackpackTier(e.getRecipe().getResult());
        BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(backpackTier);
        Player player = (Player)e.getView().getPlayer();
        if (backpackSettings.getData().getCraftPermission().isEmpty() || player.hasPermission(backpackSettings.getData().getCraftPermission())) {
            return;
        }
        e.getInventory().setResult(null);
    }
}

