/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.backpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import me.ziomalu.api.gui.Page;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.backpackcontent.BackpackGUI;
import pl.ziomalu.backpackplus.enums.BackpackType;
import pl.ziomalu.backpackplus.events.BackpackCloseEvent;
import pl.ziomalu.backpackplus.inventoryholders.BackpackInventoryHolder;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.settings.BackpackSettingsData;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.Utils;

public class BackpackInventoryListener
implements Listener {
    private final HashMap<UUID, Long> cooldowns = new HashMap();

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent e) {
        ClickType clickType = e.getClick();
        Player player = (Player)e.getWhoClicked();
        UUID playerUniqueId = player.getUniqueId();
        Inventory clicketInventory = e.getClickedInventory();
        InventoryView view = e.getView();
        InventoryAction action = e.getAction();
        InventoryType.SlotType slotType = e.getSlotType();
        ItemStack currentItem = e.getCurrentItem();
        ItemStack cursorItem = e.getCursor();
        if (currentItem == null && cursorItem == null) {
            return;
        }
        boolean cursorIsBackpack = BackpackManager.getInstance().isBackpackStack(cursorItem);
        boolean currentIsBackpack = BackpackManager.getInstance().isBackpackStack(currentItem);
        if (action.name().equals("PICKUP_ALL_INTO_BUNDLE")) {
            if (clickType == ClickType.LEFT) {
                if (currentItem != null && currentItem.getType() == Material.BUNDLE && cursorIsBackpack) {
                    e.setCancelled(true);
                    e.setResult(Event.Result.DENY);
                    return;
                }
                if (currentIsBackpack && cursorItem != null && cursorItem.getType() == Material.BUNDLE) {
                    e.setCancelled(true);
                    e.setResult(Event.Result.DENY);
                    return;
                }
            }
        } else if (action.name().equals("PLACE_ALL_INTO_BUNDLE") && clickType == ClickType.LEFT && currentItem != null && currentItem.getType().name().contains("BUNDLE") && cursorIsBackpack) {
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            return;
        }
        if (e.getInventory().getHolder() == null) {
            return;
        }
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (inventoryHolder instanceof BackpackInventoryHolder) {
            BackpackInventoryHolder holder = (BackpackInventoryHolder)inventoryHolder;
            this.onBackpackInventoryClick(e, holder);
            return;
        }
        if (cursorItem != null && cursorItem.getType().name().contains("BUNDLE")) {
            if (!currentIsBackpack) {
                return;
            }
            if (action == InventoryAction.PLACE_ALL || clickType == ClickType.RIGHT && action == InventoryAction.SWAP_WITH_CURSOR) {
                return;
            }
            if (clickType == ClickType.CREATIVE) {
                return;
            }
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            return;
        }
        if (currentItem != null && currentItem.getType().name().contains("BUNDLE")) {
            if (!cursorIsBackpack) {
                return;
            }
            if (clickType != ClickType.LEFT) {
                return;
            }
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            return;
        }
    }

    private void onBackpackInventoryClick(InventoryClickEvent e, BackpackInventoryHolder holder) {
        boolean clickedOffHandSlot;
        ClickType clickType = e.getClick();
        Player player = (Player)e.getWhoClicked();
        Inventory clickedInventory = e.getClickedInventory();
        InventoryAction action = e.getAction();
        int clickedSlot = e.getSlot();
        ItemStack currentItem = e.getCurrentItem();
        ItemStack cursorItem = e.getCursor();
        boolean cursorIsBackpack = BackpackManager.getInstance().isBackpackStack(cursorItem);
        boolean currentIsBackpack = BackpackManager.getInstance().isBackpackStack(currentItem);
        BackpackSettings backpackSettings = ((BackpackGUI)holder.gui()).getParent().getBackpackSettings();
        BackpackSettingsData backpackData = backpackSettings.getData();
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        ItemStack offHandItem = player.getInventory().getItemInOffHand();
        int heldItemSlot = player.getInventory().getHeldItemSlot();
        boolean mainHandIsBackpack = BackpackManager.getInstance().isBackpackStack(mainHandItem);
        boolean offHandIsBackpack = BackpackManager.getInstance().isBackpackStack(offHandItem);
        boolean clickedMainHandSlot = heldItemSlot == clickedSlot && clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER;
        boolean bl = clickedOffHandSlot = clickedSlot == 40 && clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER;
        if (clickedMainHandSlot && mainHandIsBackpack || clickedOffHandSlot && offHandIsBackpack) {
            e.setResult(Event.Result.DENY);
            e.setCancelled(true);
            LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
            return;
        }
        if (mainHandIsBackpack && offHandIsBackpack && (clickedMainHandSlot || clickedOffHandSlot)) {
            e.setResult(Event.Result.DENY);
            e.setCancelled(true);
            LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
            return;
        }
        if (action.name().equals("PLACE_FROM_BUNDLE")) {
            if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                return;
            }
            int slot = e.getSlot();
            if (slot >= 0 && slot < e.getView().getTopInventory().getSize() && cursorItem != null && cursorItem.getType().name().contains("BUNDLE")) {
                List<ItemStack> bundleContents = this.getBundleContents(cursorItem);
                for (ItemStack bundleItem : bundleContents) {
                    if (bundleItem == null) continue;
                    this.handleBlockedItems(e, backpackData, bundleItem);
                }
            }
        } else if (action.name().equals("PLACE_ALL_INTO_BUNDLE")) {
            if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                return;
            }
            if (cursorItem == null) {
                return;
            }
            if (this.isBlockedItem(cursorItem)) {
                e.setResult(Event.Result.DENY);
                e.setCancelled(true);
                return;
            }
        } else if (action.name().equals("PICKUP_ALL_INTO_BUNDLE")) {
            if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                return;
            }
            if (Utils.isBackpackStack(currentItem)) {
                e.setResult(Event.Result.DENY);
                e.setCancelled(true);
                return;
            }
        } else if (action.name().equals("PICKUP_FROM_BUNDLE")) {
            return;
        }
        switch (action) {
            case SWAP_WITH_CURSOR: {
                if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                    return;
                }
                if (cursorIsBackpack) {
                    e.setResult(Event.Result.DENY);
                    e.setCancelled(true);
                    LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                    return;
                }
                if (Utils.isGuiOrPageButtonItem(currentItem) || Utils.isGuiOrPageButtonItem(cursorItem)) {
                    Page page = holder.gui().getPage(holder.pageIndex());
                    if (page != null) {
                        page.handleGuiButtonClick(e);
                    }
                    return;
                }
                this.handleBlockedItems(e, backpackData, cursorItem);
                break;
            }
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_ONE: 
            case PICKUP_SOME: {
                if (Utils.isGuiOrPageButtonItem(currentItem)) {
                    Page page = holder.gui().getPage(holder.pageIndex());
                    if (page != null) {
                        page.handleGuiButtonClick(e);
                    }
                    return;
                }
                if (clickedInventory == null || clickedInventory.getType() == InventoryType.PLAYER) break;
                if (!e.isCancelled()) {
                    this.playRemoveItemSong((Player)e.getWhoClicked());
                }
                return;
            }
            case HOTBAR_SWAP: {
                if (clickType == ClickType.NUMBER_KEY) {
                    int hotbarButton = e.getHotbarButton();
                    ItemStack hotbarItem = player.getInventory().getItem(e.getHotbarButton());
                    if (Utils.isGuiOrPageButtonItem(currentItem)) {
                        e.setResult(Event.Result.DENY);
                        e.setCancelled(true);
                        return;
                    }
                    if (BackpackManager.getInstance().isBackpackStack(hotbarItem) && clickedInventory != null && clickedInventory.getType() != InventoryType.PLAYER) {
                        e.setResult(Event.Result.DENY);
                        e.setCancelled(true);
                        LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                        return;
                    }
                    if (hotbarButton == heldItemSlot && BackpackManager.getInstance().isBackpackStack(hotbarItem)) {
                        e.setResult(Event.Result.DENY);
                        e.setCancelled(true);
                        LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                        return;
                    }
                    if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) break;
                    this.handleBlockedItems(e, backpackData, hotbarItem);
                    break;
                }
                if (clickType != ClickType.SWAP_OFFHAND) break;
                ItemStack offHandStack = player.getInventory().getItemInOffHand();
                if (currentIsBackpack || BackpackManager.getInstance().isBackpackStack(offHandStack)) {
                    e.setResult(Event.Result.DENY);
                    e.setCancelled(true);
                    LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                    return;
                }
                if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) break;
                this.handleBlockedItems(e, backpackData, offHandStack);
                break;
            }
            case PLACE_ALL: 
            case PLACE_ONE: {
                if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                    return;
                }
                if (Utils.isGuiOrPageButtonItem(cursorItem)) {
                    Page page = holder.gui().getPage(holder.pageIndex());
                    if (page != null) {
                        page.handleGuiButtonClick(e);
                    }
                    return;
                }
                if (cursorIsBackpack) {
                    e.setResult(Event.Result.DENY);
                    e.setCancelled(true);
                    LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                    return;
                }
                if (clickedInventory == null || clickedInventory.getType() != InventoryType.PLAYER) {
                    this.handleBlockedItems(e, backpackData, cursorItem);
                }
                if (e.isCancelled()) break;
                this.playInsertItemSong((Player)e.getWhoClicked());
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: 
            case CLONE_STACK: {
                if (Utils.isGuiOrPageButtonItem(currentItem)) {
                    Page page = holder.gui().getPage(holder.pageIndex());
                    if (page != null) {
                        page.handleGuiButtonClick(e);
                    }
                    return;
                }
                if (currentIsBackpack) {
                    e.setResult(Event.Result.DENY);
                    e.setCancelled(true);
                    LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                    return;
                }
                if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                    this.handleBlockedItems(e, backpackData, currentItem);
                }
                if (e.isCancelled()) break;
                if (clickedInventory != null && clickedInventory.getType() != InventoryType.PLAYER) {
                    this.playRemoveItemSong((Player)e.getWhoClicked());
                    break;
                }
                this.playInsertItemSong((Player)e.getWhoClicked());
                break;
            }
            case NOTHING: {
                break;
            }
            case DROP_ONE_CURSOR: 
            case DROP_ALL_CURSOR: 
            case DROP_ALL_SLOT: 
            case DROP_ONE_SLOT: {
                if (clickedInventory != null && !(clickedInventory.getHolder() instanceof BackpackInventoryHolder)) {
                    return;
                }
                if (Utils.isGuiOrPageButtonItem(currentItem)) {
                    Page page = holder.gui().getPage(holder.pageIndex());
                    if (page != null) {
                        page.handleGuiButtonClick(e);
                    }
                    return;
                }
                if (currentIsBackpack) {
                    e.setResult(Event.Result.DENY);
                    e.setCancelled(true);
                    LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                    return;
                }
                if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                    this.handleBlockedItems(e, backpackData, currentItem);
                }
                if (e.isCancelled()) break;
                if (clickedInventory != null && clickedInventory.getType() != InventoryType.PLAYER) {
                    this.playRemoveItemSong((Player)e.getWhoClicked());
                    break;
                }
                this.playInsertItemSong((Player)e.getWhoClicked());
                break;
            }
            case COLLECT_TO_CURSOR: {
                if (cursorIsBackpack) {
                    e.setResult(Event.Result.DENY);
                    e.setCancelled(true);
                    LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                    return;
                }
                if (clickedInventory == null) break;
                if (clickedInventory.getType() == InventoryType.PLAYER) {
                    if (e.isCancelled()) break;
                    this.playRemoveItemSong((Player)e.getWhoClicked());
                    break;
                }
                if (clickedInventory.getHolder() == null || !(clickedInventory.getHolder() instanceof BackpackInventoryHolder) || e.isCancelled()) break;
                this.playInsertItemSong((Player)e.getWhoClicked());
                break;
            }
            default: {
                if (Utils.isGuiOrPageButtonItem(currentItem)) {
                    Page page = holder.gui().getPage(holder.pageIndex());
                    if (page != null) {
                        page.handleGuiButtonClick(e);
                    }
                    return;
                }
                if (currentIsBackpack) {
                    e.setResult(Event.Result.DENY);
                    e.setCancelled(true);
                    LanguageManager.sendMessage(player, "blocked-backpack-insert-message");
                    return;
                }
                if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER) {
                    this.handleBlockedItems(e, backpackData, currentItem);
                }
                if (e.isCancelled()) break;
                if (clickedInventory != null && clickedInventory.getType() != InventoryType.PLAYER) {
                    this.playRemoveItemSong((Player)e.getWhoClicked());
                    break;
                }
                this.playInsertItemSong((Player)e.getWhoClicked());
            }
        }
    }

    private void handleBlockedItems(InventoryClickEvent e, BackpackSettingsData backpackData, ItemStack checkStack) {
        boolean backpackIsFiltered;
        if (checkStack == null) {
            return;
        }
        if (checkStack.getType().name().contains("BUNDLE")) {
            if (!Settings.ALLOW_BUNDLES_IN_BACKPACKS) {
                e.setCancelled(true);
                e.setResult(Event.Result.DENY);
                return;
            }
            List<ItemStack> bundleContents = this.getBundleContents(checkStack);
            if (!bundleContents.isEmpty()) {
                for (ItemStack stack : bundleContents) {
                    if (!this.isBlockedItem(stack)) continue;
                    e.setCancelled(true);
                    e.setResult(Event.Result.DENY);
                    return;
                }
            }
        }
        boolean bl = backpackIsFiltered = backpackData.getBackpackType() == BackpackType.FILTERED;
        if (backpackIsFiltered) {
            boolean disallowedNBT;
            boolean disallowedItem = !backpackData.isAllowedItem(checkStack);
            boolean bl2 = disallowedNBT = !backpackData.isAllowedNBT(checkStack);
            if (disallowedNBT || disallowedItem) {
                e.setCancelled(true);
                e.setResult(Event.Result.DENY);
                LanguageManager.sendMessage((Player)e.getWhoClicked(), "filtered-backpack-item-not-allowed");
                return;
            }
        }
        if (Utils.isBlockedItem(checkStack)) {
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrag(InventoryDragEvent e) {
        if (e.getView().getTopInventory().getHolder() == null) {
            return;
        }
        if (e.getInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        ItemStack oldCursorStack = e.getOldCursor();
        ItemStack cursorStack = e.getCursor();
        DragType dragType = e.getType();
        Inventory topInv = e.getView().getTopInventory();
        InventoryType topInvType = topInv.getType();
        if (Settings.BLOCKED_CONTAINERS.contains(topInvType) && Settings.BLOCK_BACKPACK_INSERT_CONTAINERS || topInv.getHolder() instanceof BackpackInventoryHolder) {
            InventoryHolder holder = topInv.getHolder();
            BackpackInventoryHolder backpackInventoryHolder = null;
            BackpackSettings backpackSettings = null;
            BackpackSettingsData backpackData = null;
            if (holder instanceof BackpackInventoryHolder) {
                backpackInventoryHolder = (BackpackInventoryHolder)holder;
                backpackSettings = ((BackpackGUI)backpackInventoryHolder.gui()).getParent().getBackpackSettings();
                backpackData = backpackSettings.getData();
            }
            Map newItems2 = e.getNewItems();
            for (Map.Entry entry : newItems2.entrySet()) {
                int slot = (Integer)entry.getKey();
                ItemStack item = (ItemStack)entry.getValue();
                if (slot >= e.getView().getTopInventory().getSize()) continue;
                if (BackpackManager.getInstance().isBackpackStack(item)) {
                    e.setCancelled(true);
                    e.setResult(Event.Result.DENY);
                    return;
                }
                if (backpackSettings != null && backpackData.getBackpackType() == BackpackType.FILTERED) {
                    boolean disallowedNBT;
                    boolean disallowedItem = !backpackData.isAllowedItem(item);
                    boolean bl = disallowedNBT = !backpackData.isAllowedNBT(item);
                    if (disallowedNBT || disallowedItem) {
                        e.setCancelled(true);
                        e.setResult(Event.Result.DENY);
                        return;
                    }
                }
                if (Utils.isBlockedItem(item)) {
                    e.setCancelled(true);
                    e.setResult(Event.Result.DENY);
                    return;
                }
                if (Utils.hasBlockedItem(oldCursorStack, cursorStack)) {
                    e.setCancelled(true);
                    e.setResult(Event.Result.DENY);
                    return;
                }
                if (e.isCancelled()) continue;
                this.playInsertItemSong((Player)e.getWhoClicked());
            }
        }
    }

    private boolean hasCooldown(UUID playerUniqueId) {
        if (!this.cooldowns.containsKey(playerUniqueId)) {
            return false;
        }
        long timeElapsed = System.currentTimeMillis() - this.cooldowns.get(playerUniqueId);
        if (timeElapsed <= 200L) {
            return true;
        }
        this.cooldowns.remove(playerUniqueId);
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBackpackInventoryClose(InventoryCloseEvent e) {
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (!(inventoryHolder instanceof BackpackInventoryHolder)) {
            return;
        }
        BackpackInventoryHolder bpHolder = (BackpackInventoryHolder)inventoryHolder;
        Player player = (Player)e.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)BackpackPlus.getInstance(), () -> {
            if (player == null || !player.isOnline()) {
                return;
            }
            boolean stillOpenBackpack = false;
            InventoryView view = player.getOpenInventory();
            if (view != null && view.getTopInventory() != null) {
                InventoryHolder holder = view.getTopInventory().getHolder();
                stillOpenBackpack = holder instanceof BackpackInventoryHolder;
            }
            if (stillOpenBackpack) {
                return;
            }
            BackpackCloseEvent event = new BackpackCloseEvent(bpHolder.backpack(), player, this.getBackpackFromHands(player));
            Bukkit.getPluginManager().callEvent((Event)event);
        }, 1L);
    }

    private ItemStack getBackpackFromHands(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (BackpackManager.getInstance().isBackpackStack(mainHand) && BackpackManager.getInstance().backpackIsUsed(mainHand)) {
            return mainHand;
        }
        if (BackpackManager.getInstance().isBackpackStack(offHand) && BackpackManager.getInstance().backpackIsUsed(offHand)) {
            return offHand;
        }
        return null;
    }

    private void logEventInfo(InventoryClickEvent e) {
        ItemStack cursorItem;
        Logger logger = BackpackPlus.getInstance().getLogger();
        logger.info("==================== InventoryClickEvent Debug ====================");
        logger.info("[Event] Action: " + e.getAction().name());
        logger.info("[Event] Click Type: " + e.getClick().name());
        logger.info("[Event] Result: " + e.getResult().name());
        logger.info("[Event] Cancelled: " + e.isCancelled());
        logger.info("[Event] Slot Type: " + e.getSlotType().name());
        Player player = (Player)e.getWhoClicked();
        logger.info("[Player] Name: " + player.getName());
        logger.info("[Player] UUID: " + String.valueOf(player.getUniqueId()));
        logger.info("[Player] Game Mode: " + player.getGameMode().name());
        logger.info("[Player] Sneaking: " + player.isSneaking());
        logger.info("[Slot] Clicked Slot: " + e.getSlot());
        logger.info("[Slot] Raw Slot: " + e.getRawSlot());
        ItemStack currentItem = e.getCurrentItem();
        if (currentItem != null && currentItem.getType() != Material.AIR) {
            logger.info("[CurrentItem] Type: " + currentItem.getType().name());
            logger.info("[CurrentItem] Amount: " + currentItem.getAmount());
            logger.info("[CurrentItem] Has Meta: " + currentItem.hasItemMeta());
            if (currentItem.hasItemMeta() && currentItem.getItemMeta().hasDisplayName()) {
                logger.info("[CurrentItem] Display Name: " + currentItem.getItemMeta().getDisplayName());
            }
            if (currentItem.hasItemMeta() && currentItem.getItemMeta().hasCustomModelData()) {
                logger.info("[CurrentItem] Custom Model Data: " + currentItem.getItemMeta().getCustomModelData());
            }
        } else {
            logger.info("[CurrentItem] Type: AIR/NULL");
        }
        if ((cursorItem = e.getCursor()) != null && cursorItem.getType() != Material.AIR) {
            logger.info("[CursorItem] Type: " + cursorItem.getType().name());
            logger.info("[CursorItem] Amount: " + cursorItem.getAmount());
            logger.info("[CursorItem] Has Meta: " + cursorItem.hasItemMeta());
            if (cursorItem.hasItemMeta() && cursorItem.getItemMeta().hasDisplayName()) {
                logger.info("[CursorItem] Display Name: " + cursorItem.getItemMeta().getDisplayName());
            }
        } else {
            logger.info("[CursorItem] Type: AIR/NULL");
        }
        if (e.getHotbarButton() != -1) {
            logger.info("[Hotbar] Button: " + e.getHotbarButton());
            if (e.getHotbarButton() >= 0 && e.getHotbarButton() < 9) {
                ItemStack hotbarItem = player.getInventory().getItem(e.getHotbarButton());
                if (hotbarItem != null && hotbarItem.getType() != Material.AIR) {
                    logger.info("[Hotbar] Item: " + hotbarItem.getType().name() + " x" + hotbarItem.getAmount());
                } else {
                    logger.info("[Hotbar] Item: Empty");
                }
            }
        }
        if (e.getClickedInventory() != null) {
            ItemStack clickedItem;
            logger.info("[ClickedInventory] Type: " + e.getClickedInventory().getType().name());
            logger.info("[ClickedInventory] Size: " + e.getClickedInventory().getSize());
            if (e.getClickedInventory().getHolder() != null) {
                logger.info("[ClickedInventory] Holder: " + e.getClickedInventory().getHolder().getClass().getSimpleName());
            }
            if ((clickedItem = e.getClickedInventory().getItem(e.getSlot())) != null && clickedItem.getType() != Material.AIR) {
                logger.info("[ClickedSlot] Item: " + clickedItem.getType().name() + " x" + clickedItem.getAmount());
            } else {
                logger.info("[ClickedSlot] Item: Empty");
            }
        } else {
            logger.info("[ClickedInventory] Type: NULL");
        }
        logger.info("[MainInventory] Type: " + e.getInventory().getType().name());
        logger.info("[MainInventory] Size: " + e.getInventory().getSize());
        if (e.getInventory().getHolder() != null) {
            logger.info("[MainInventory] Holder: " + e.getInventory().getHolder().getClass().getSimpleName());
        }
        logger.info("[View] Title: " + e.getView().getTitle());
        logger.info("[View] Type: " + e.getView().getType().name());
        logger.info("[View] Top Inventory Size: " + e.getView().getTopInventory().getSize());
        logger.info("[View] Bottom Inventory Size: " + e.getView().getBottomInventory().getSize());
        ItemStack rawSlotItem = e.getView().getItem(e.getRawSlot());
        if (rawSlotItem != null && rawSlotItem.getType() != Material.AIR) {
            logger.info("[RawSlot] Item: " + rawSlotItem.getType().name() + " x" + rawSlotItem.getAmount());
        } else {
            logger.info("[RawSlot] Item: Empty");
        }
        logger.info("[Modifiers] Shift: " + e.getClick().isShiftClick());
        logger.info("[Modifiers] Right Click: " + e.getClick().isRightClick());
        logger.info("[Modifiers] Left Click: " + e.getClick().isLeftClick());
        logger.info("[Modifiers] Creative Action: " + e.getClick().isCreativeAction());
        logger.info("[Debug] Event Class: " + e.getClass().getSimpleName());
        logger.info("[Debug] Thread: " + Thread.currentThread().getName());
        logger.info("[Debug] Timestamp: " + System.currentTimeMillis());
        logger.info("================================================================");
    }

    public void logInventoryDragEvent(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        System.out.println("==================== INVENTORY DRAG EVENT ====================");
        System.out.println("Player: " + player.getName());
        System.out.println("Drag type: " + event.getType().name());
        System.out.println("Event cancelled: " + event.isCancelled());
        System.out.println("Result: " + event.getResult().name());
        ItemStack oldCursor = event.getOldCursor();
        ItemStack newCursor = event.getCursor();
        System.out.println("--- CURSOR ---");
        System.out.println("Old cursor: " + (String)(oldCursor != null ? oldCursor.getType().name() + " x" + oldCursor.getAmount() : "null"));
        System.out.println("New cursor: " + (String)(newCursor != null ? newCursor.getType().name() + " x" + newCursor.getAmount() : "null"));
        System.out.println("--- INVENTORY ---");
        System.out.println("Inventory type: " + event.getInventory().getType().name());
        System.out.println("Inventory size: " + event.getInventory().getSize());
        System.out.println("Inventory title: " + event.getView().getTitle());
        System.out.println("--- AFFECTED SLOTS ---");
        System.out.println("Raw slots: " + event.getRawSlots().toString());
        System.out.println("Inventory slots: " + event.getInventorySlots().toString());
        System.out.println("Number of affected slots: " + event.getRawSlots().size());
        System.out.println("--- NEW ITEMS ---");
        Map newItems = event.getNewItems();
        for (Map.Entry entry : newItems.entrySet()) {
            int slot = (Integer)entry.getKey();
            ItemStack item = (ItemStack)entry.getValue();
            System.out.println("Slot " + slot + ": " + (String)(item != null ? item.getType().name() + " x" + item.getAmount() : "null"));
        }
        System.out.println("--- SLOT DETAILS ---");
        for (Integer rawSlot : event.getRawSlots()) {
            ItemStack currentItem = event.getView().getItem(rawSlot.intValue());
            System.out.println("Raw slot " + rawSlot + " - current item: " + (String)(currentItem != null ? currentItem.getType().name() + " x" + currentItem.getAmount() : "empty"));
            if (rawSlot < event.getView().getTopInventory().getSize()) {
                System.out.println("  -> Slot in top inventory (chest/furnace/etc.)");
                continue;
            }
            System.out.println("  -> Slot in bottom inventory (player)");
        }
        System.out.println("--- DRAG TYPE ---");
        switch (event.getType()) {
            case SINGLE: {
                System.out.println("Single drag (left mouse button)");
                break;
            }
            case EVEN: {
                System.out.println("Even distribution (right mouse button)");
                break;
            }
            default: {
                System.out.println("Unknown drag type: " + String.valueOf(event.getType()));
            }
        }
        System.out.println("================================================================");
    }

    private boolean isBlockedItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (BackpackManager.getInstance().isBlocked(item)) {
            return true;
        }
        if (Utils.isGuiOrPageButtonItem(item)) {
            return true;
        }
        if (BackpackManager.getInstance().isBackpackStack(item)) {
            return true;
        }
        return item.getType() == Material.BUNDLE;
    }

    private void playInsertItemSong(Player player) {
        if (!Settings.PLAY_SONG_WHEN_ITEM_MOVED_IN_BACKPACK) {
            return;
        }
        float volume = new Random().nextFloat(0.7f, 2.0f);
        float pitch = new Random().nextFloat(0.0f, 0.7f);
        player.playSound((Entity)player, Sound.ITEM_BUNDLE_INSERT, volume, pitch);
    }

    private void playRemoveItemSong(Player player) {
        if (!Settings.PLAY_SONG_WHEN_ITEM_MOVED_IN_BACKPACK) {
            return;
        }
        float volume = new Random().nextFloat(0.7f, 2.0f);
        float pitch = new Random().nextFloat(0.0f, 0.5f);
        player.playSound((Entity)player, Sound.ITEM_BUNDLE_REMOVE_ONE, volume, pitch);
    }

    private List<ItemStack> getBundleContents(ItemStack bundle) {
        BundleMeta bundleMeta;
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        if (bundle != null && bundle.hasItemMeta() && (bundleMeta = (BundleMeta)bundle.getItemMeta()) != null && bundleMeta.hasItems()) {
            contents.addAll(bundleMeta.getItems());
        }
        return contents;
    }
}

