/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.backpack;

import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.database.BackpackInfo;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.enums.BackpackState;
import pl.ziomalu.backpackplus.events.BackpackCloseEvent;
import pl.ziomalu.backpackplus.events.BackpackCreateEvent;
import pl.ziomalu.backpackplus.events.BackpackOpenEvent;
import pl.ziomalu.backpackplus.events.BackpackStateChangeEvent;
import pl.ziomalu.backpackplus.events.PreBackpackOpenEvent;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.utils.Utils;

public class BackpackListener
implements Listener {
    @EventHandler
    public void onBackpackStateChange(BackpackStateChangeEvent event) {
        Utils.debugLogToConsole("Backpack state changed to: " + String.valueOf((Object)event.getState()) + " from: " + String.valueOf((Object)event.getPreviousState()));
    }

    @EventHandler
    public void onBackpackCreate(BackpackCreateEvent event) {
        ItemStack backpackStack;
        Utils.debugLogToConsole("[BackpackListener] [onBackpackCreate] called");
        UUID backpackUniqueId = UUID.randomUUID();
        Player player = event.getPlayer();
        int originalBackpacksAmount = event.getBackpackStack().getAmount();
        if (event.getBackpackStack().getAmount() > 1) {
            backpackStack = event.getBackpackStack().clone();
            backpackStack.setAmount(1);
            event.getBackpackStack().setAmount(originalBackpacksAmount - 1);
        } else {
            backpackStack = event.getBackpackStack();
        }
        BackpackManager.getInstance().setBackpackUsedKeys(backpackStack, backpackUniqueId);
        int backpackTier = BackpackManager.getInstance().getBackpackTier(backpackStack);
        new Backpack(backpackUniqueId, player.getUniqueId(), backpackTier, backpackCallback -> {
            if (backpackCallback instanceof Backpack) {
                Backpack backpack = (Backpack)backpackCallback;
                DatabaseManager.getInstance().getDatabase().saveBackpackToDatabaseAsync(backpack, value -> {
                    if (!value.booleanValue()) {
                        BackpackManager.getInstance().removeBackpackUsedKeys(backpackStack);
                        Utils.debugLogToConsole("[BackpackListener] [onBackpackCreate] failed to create a new backpack");
                        return;
                    }
                    if (originalBackpacksAmount > 1) {
                        if (player.getInventory().firstEmpty() == -1) {
                            World playerWorld = player.getWorld();
                            Location playerlocation = player.getLocation();
                            Utils.debugLogToConsole("[BackpackListener] [onBackpackCreate] Preparing to drop backpack item on X: " + playerlocation.getX() + " Y: " + playerlocation.getY() + " Z: " + playerlocation.getZ());
                            Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> playerWorld.dropItem(playerlocation, backpackStack));
                        } else {
                            player.getInventory().addItem(new ItemStack[]{backpackStack});
                        }
                    }
                    backpack.setLore(backpackStack, backpack);
                    BackpackManager.getInstance().addBackpackToMap(backpack);
                    Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> {
                        Utils.debugLogToConsole("[BackpackListener] [onBackpackCreate] calling to [BackpackOpenEvent]");
                        BackpackOpenEvent backpackOpenEvent = new BackpackOpenEvent(backpack, player, backpackStack, false);
                        Bukkit.getPluginManager().callEvent((Event)backpackOpenEvent);
                    });
                });
            }
        });
    }

    @EventHandler
    public void onPreBackpackOpen(PreBackpackOpenEvent event) {
        UUID backpackUniqueId = event.getBackpackUniqueId();
        int backpackTier = event.getBackpackTier();
        Player player = event.getPlayer();
        BackpackSettings settings = BackpackManager.getInstance().getBackpackSettingsByTier(backpackTier);
        Backpack memoryBackpack = BackpackManager.getInstance().getBackpackFromMap(backpackUniqueId);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BackpackPlus.getInstance(), () -> {
            Optional<BackpackInfo> dbInfoOpt = DatabaseManager.getInstance().getDatabase().getBackpackState(backpackUniqueId);
            if (dbInfoOpt.isPresent()) {
                BackpackInfo dbInfo = dbInfoOpt.get();
                if (dbInfo.isOpen() && dbInfo.lastPlayerUniqueId() != null && !dbInfo.lastPlayerUniqueId().equals(player.getUniqueId())) {
                    LanguageManager.sendMessage(player, "backpack-is-used-by-another-player");
                    event.setCancelled(true);
                    return;
                }
                if (memoryBackpack == null || dbInfo.lastUpdated().after(memoryBackpack.getLastUpdated())) {
                    DatabaseManager.getInstance().getDatabase().loadBackpackFromDatabaseAsync(backpackUniqueId, backpackTier, loadedBackpack -> Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> {
                        if (loadedBackpack == null) {
                            BackpackPlus.getInstance().getLogger().warning("Failed to find backpack in database. UUID: " + String.valueOf(backpackUniqueId) + ", Tier: " + backpackTier + ", Player: " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
                            LanguageManager.sendMessage(player, "backpack-loading-error");
                            return;
                        }
                        BackpackManager.getInstance().removeBackpackFromMap(backpackUniqueId);
                        BackpackManager.getInstance().addBackpackToMap((Backpack)loadedBackpack);
                        if (settings.getData().isOwnerOnly() && !event.isForce() && !loadedBackpack.getBackpackOwnerUniqueId().equals(player.getUniqueId())) {
                            LanguageManager.sendMessage(player, "not-owner");
                            event.setCancelled(true);
                            return;
                        }
                        if (!event.isCancelled()) {
                            BackpackOpenEvent openEvent = new BackpackOpenEvent((Backpack)loadedBackpack, player, event.getBackpackStack(), event.isForce());
                            Bukkit.getPluginManager().callEvent((Event)openEvent);
                        }
                    }));
                    return;
                }
            } else {
                BackpackPlus.getInstance().getLogger().warning("Failed to find backpack in database. UUID: " + String.valueOf(backpackUniqueId) + ", Tier: " + backpackTier + ", Player: " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
                LanguageManager.sendMessage(player, "backpack-loading-error");
                return;
            }
            if (settings.getData().isOwnerOnly() && !event.isForce() && !memoryBackpack.getBackpackOwnerUniqueId().equals(player.getUniqueId())) {
                LanguageManager.sendMessage(player, "not-owner");
                event.setCancelled(true);
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> {
                if (!event.isCancelled()) {
                    BackpackOpenEvent openEvent = new BackpackOpenEvent(memoryBackpack, player, event.getBackpackStack(), event.isForce());
                    Bukkit.getPluginManager().callEvent((Event)openEvent);
                }
            });
        });
    }

    @EventHandler
    public void onBackpackOpen(BackpackOpenEvent event) {
        Player player = event.getPlayer();
        if (event.getBackpack().getBackpackState() != BackpackState.NORMAL) {
            switch (event.getBackpack().getBackpackState()) {
                case ERROR: {
                    BackpackManager.getInstance().sendMessage(player, "backpack-loading-error");
                    event.setCancelled(true);
                    return;
                }
                case UPDATING: {
                    BackpackManager.getInstance().sendMessage(player, "backpack-updating");
                    event.setCancelled(true);
                    return;
                }
                case LOADING: {
                    BackpackManager.getInstance().sendMessage(player, "backpack-loading");
                    event.setCancelled(true);
                    return;
                }
            }
        }
        Backpack backpack = event.getBackpack();
        if (!event.isForceOpen() && backpack.isLocked() && !backpack.getLastPlayerUniqueId().equals(event.getPlayer().getUniqueId())) {
            BackpackManager.getInstance().sendMessage(player, "backpack-is-used-by-another-player");
            Utils.debugLogToConsole("Backpack Using by another player, LastPlayerUniqueId: " + String.valueOf(backpack.getLastPlayerUniqueId()) + " Current Player UniqueId: " + String.valueOf(event.getPlayer().getUniqueId()));
            event.setCancelled(true);
            return;
        }
        if (!event.isForceOpen()) {
            backpack.setLocked(event.isLockBackpack());
            backpack.setLastPlayerUniqueId(player.getUniqueId());
            DatabaseManager.getInstance().getDatabase().updateBackpackOpenState(backpack.getBackpackUniqueId(), true);
        }
        Utils.debugLogToConsole("\nBackpack opened: " + String.valueOf(event.getBackpack().getBackpackUniqueId()) + " by Player: " + event.getPlayer().getName() + String.format("(%s)", player.getUniqueId()) + " \nState: " + String.valueOf((Object)backpack.getBackpackState()) + " \nIs locked: " + backpack.isLocked() + " \nIs force open: " + event.isForceOpen() + " \nLock Backpack: " + event.isLockBackpack() + " \nLast Player UniqueId: " + String.valueOf(backpack.getLastPlayerUniqueId()));
        backpack.openFirstPage(event.getPlayer());
        player.setMetadata("BackpackPlus", (MetadataValue)new FixedMetadataValue((Plugin)BackpackPlus.getInstance(), (Object)event.getBackpack()));
    }

    @EventHandler
    public void onBackpackInventoryClose(BackpackCloseEvent event) {
        try {
            Player player = event.getPlayer();
            if (!player.hasMetadata("BackpackPlus")) {
                return;
            }
            Backpack backpack = event.getBackpack();
            if (backpack == null) {
                return;
            }
            Utils.debugLogToConsole("Backpack closed: " + String.valueOf(backpack.getBackpackUniqueId()) + " by player: " + player.getName());
            if (event.getBackpackStack() != null) {
                backpack.setLore(event.getBackpackStack(), backpack);
            }
            BackpackManager.getInstance().removePlayerUsedBackpackStack(player.getUniqueId());
            BackpackManager.getInstance().removeBackpackUsedByPlayer(player.getUniqueId());
            if (player.hasMetadata("BackpackPlus")) {
                player.removeMetadata("BackpackPlus", (Plugin)BackpackPlus.getInstance());
            }
            backpack.updateUse();
            if (backpack.getInspectors().contains(player.getUniqueId())) {
                backpack.removeInspector(player.getUniqueId());
                return;
            }
            if (backpack.getLastPlayerUniqueId().equals(player.getUniqueId())) {
                backpack.setLocked(false);
            }
            backpack.setLastPlayerUniqueId(player.getUniqueId());
            BackpackManager.getInstance().addPlayerCooldown(player.getUniqueId());
            backpack.closeAndSaveBackpack(false);
            DatabaseManager.getInstance().getDatabase().updateBackpackOpenState(backpack.getBackpackUniqueId(), false);
        }
        catch (IndexOutOfBoundsException e) {
            BackpackPlus.getInstance().getLogger().severe("An IndexOutOfBoundsException occurred in onBackpackInventoryClose: " + e.getMessage());
        }
        catch (Exception e) {
            BackpackPlus.getInstance().getLogger().severe("An exception occurred in onBackpackInventoryClose: " + e.getMessage());
        }
    }
}

